/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.distributeddeploy.fit.util;

import com.huawei.fitframework.annotation.Fitable;
import com.huawei.fitframework.exception.FitException;
import com.huawei.ism.tool.obase.exception.ToolException;
import com.huawei.ism.tool.obase.taskexecutor.TaskResult;
import com.huawei.yinglong.drop.entity.rest.entity.Response;
import com.huawei.yinglong.drop.entity.rest.entity.Result;

@Fitable
public class ResponseUtil {
    private static final int SUCCESS = 0;
    private static final int FAILED_CODE = 1;
    private static final int PART_FAILED_CODE = 2;

    public <T> Response<T> build(TaskResult result, T data) {
        return Response.builder().data(data).result(TaskResult.Result.SUCCESS.equals((Object)result.getResult()) ? this.successResult() : this.failedResult()).build();
    }

    public <T> Response<T> failed(String description, String suggestion) {
        return Response.builder().result(this.failedResult(description, suggestion)).build();
    }

    public <T> Response<T> failed(T data) {
        return Response.builder().result(this.failedResult()).data(data).build();
    }

    public <T> Response<T> warn(T data) {
        return Response.builder().result(this.warnResult()).data(data).build();
    }

    private Result warnResult() {
        return Result.builder().code(Integer.valueOf(2)).build();
    }

    public <T> Response<T> success(T data) {
        Response response = new Response();
        response.setResult(this.successResult());
        response.setData(data);
        return Response.builder().result(this.successResult()).data(data).build();
    }

    private Result failedResult(String description, String suggestion) {
        return Result.builder().code(Integer.valueOf(1)).description(description).suggestion(suggestion).build();
    }

    private Result failedResult() {
        return this.failedResult("", "");
    }

    private Result successResult() {
        return Result.builder().code(Integer.valueOf(0)).build();
    }

    public <T> Response<T> handleError(FitException exception, String defaultDescription) {
        Throwable throwable = exception.getCause();
        if (throwable instanceof AbstractMethodError) {
            AbstractMethodError abstractMethodError = (AbstractMethodError)throwable;
            return this.failed(abstractMethodError.getMessage(), "");
        }
        if (throwable instanceof ToolException) {
            ToolException toolException = (ToolException)throwable;
            return this.failed(toolException.getErrorLocaleDescription(), "");
        }
        return this.failed(defaultDescription, "");
    }

    public <T> Response<T> successWithDescription(T data, String description) {
        return Response.builder().result(Result.builder().code(Integer.valueOf(0)).description(description).build()).data(data).build();
    }
}

