/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.distributeddeploy.fit.util;

import com.huawei.ism.tool.base.utils.StringUtils;
import com.huawei.ism.tool.file.FileTypeUtils;
import com.huawei.ism.tool.obase.exception.ToolException;
import java.io.File;
import java.io.IOException;
import java.util.Locale;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import utils.FilesUtil;

public class ServerUtil {
    private static final Logger log = LoggerFactory.getLogger(ServerUtil.class);
    private static final int MAX_PATH_LENGTH = 128;
    private static boolean isPathLengthLimit = true;
    private static final long MAX_FILE_LENGTH = 0x8000000L;
    private static boolean isFileLengthLimit = true;
    private static final String NET_WORK_PATH_START = "\\";
    private static final String NET_WORK_PATH_SHORTCUT = "network shortcuts";

    public static void setPathLengthLimit(boolean isCheckPathLength) {
        isPathLengthLimit = isCheckPathLength;
    }

    public static void setFileLengthLimit(boolean isCheckFileLength) {
        isFileLengthLimit = isCheckFileLength;
    }

    public static boolean checkPathValid(String path) throws ToolException {
        if (path == null) {
            throw new ToolException("fit.importfile.verify.path.not.exit");
        }
        File file = new File(path);
        if (!file.exists()) {
            throw new ToolException("fit.importfile.verify.path.not.exit");
        }
        if (file.isDirectory()) {
            throw new ToolException("fit.importfile.verify.path.directory");
        }
        String canonicalPath = "";
        try {
            canonicalPath = file.getCanonicalPath();
        }
        catch (IOException e) {
            log.error("get getCanonicalPath fail", (Throwable)e);
            throw new ToolException("fit.importfile.verify.path.format.error");
        }
        if (canonicalPath.startsWith(NET_WORK_PATH_START) || canonicalPath.toLowerCase(Locale.ENGLISH).contains(NET_WORK_PATH_SHORTCUT)) {
            throw new ToolException("fit.importfile.verify.path.network.path");
        }
        if (isPathLengthLimit && canonicalPath.length() > 128) {
            throw new ToolException("fit.importfile.verify.path.over.length");
        }
        if (isFileLengthLimit && file.length() > 0x8000000L) {
            throw new ToolException("fit.importfile.verify.file.over.length");
        }
        if (!FileTypeUtils.getInstance().matchFileType(canonicalPath)) {
            throw new ToolException("fit.importfile.verify.path.type.illegal");
        }
        return true;
    }

    public static boolean commonDirCheck(String targetDir) throws ToolException {
        if (targetDir == null) {
            throw new ToolException("fit.export.template.verify.target.dir.empty");
        }
        File target = new File(targetDir);
        String canonicalPath = "";
        try {
            canonicalPath = target.getCanonicalPath();
        }
        catch (IOException e) {
            log.error("get getCanonicalPath fail", (Throwable)e);
            throw new ToolException("fit.importfile.verify.path.format.error", (Throwable)e);
        }
        if (isPathLengthLimit && canonicalPath.length() > 128) {
            throw new ToolException("fit.importfile.verify.path.over.length");
        }
        if (!FilesUtil.checkNormalPath((String)canonicalPath)) {
            throw new ToolException("path.check");
        }
        if (!target.exists() && !target.mkdirs()) {
            throw new ToolException("export.report.makeDir.err");
        }
        if (!target.isDirectory()) {
            throw new ToolException("fit.export.template.verify.target.dir.not.dir");
        }
        if (!target.canWrite()) {
            throw new ToolException("mainFrame.top.export.canNotWrite");
        }
        return true;
    }

    public static String[] splitTaskIdAndCheck(String taskId) throws ToolException {
        String[] split = ServerUtil.splitValues(taskId);
        if ("default".equals(split[1])) {
            return split;
        }
        if (!StringUtils.isValidIPV4(split[1]) && !StringUtils.isIpv6Address(split[1])) {
            throw new ToolException("bmcIpFrame.bmc.now.ip.addresserror");
        }
        return split;
    }

    private static String[] splitValues(String devId) throws ToolException {
        if (StringUtils.isNULLStr(devId)) {
            throw new ToolException("fit.task.verify.param.id.not.exist");
        }
        String[] split = devId.split("_");
        if (split.length < 2 || StringUtils.isNULLStr(split[0])) {
            throw new ToolException("fit.task.verify.param.id.not.exist");
        }
        if (StringUtils.isNULLStr(split[1])) {
            throw new ToolException("fit.task.verify.param.id.not.exist");
        }
        return split;
    }

    private ServerUtil() {
    }
}

