/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.distributeddeploy.fit.util;

import com.huawei.ism.tool.base.utils.StringUtils;
import com.huawei.ism.tool.distributeddeploy.entity.StepInfo;
import com.huawei.ism.tool.distributeddeploy.enumz.Status;
import com.huawei.ism.tool.distributeddeploy.fit.entity.DeployRunningDetail;
import com.huawei.ism.tool.distributeddeploy.fit.entity.RunningMessage;
import com.huawei.ism.tool.distributeddeploy.fit.entity.StepRunningDetail;
import com.huawei.ism.tool.distributeddeploy.logic.task.ItemTask;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;

public class TaskSumUtil {
    private static final String LIT_INDICATOR = "lit_indicator";
    private static final String OFF_INDICATOR = "off_indicator";

    public static boolean isStepTaskFinish(Status status) {
        return Arrays.asList(Status.PASS, Status.SUCCESSFUL, Status.NOT_PASS, Status.FAILED, Status.PAUSE).contains((Object)status);
    }

    public static boolean isPause(Status status) {
        return status == Status.PAUSE;
    }

    public static Status sumTaskStatus(List<RunningMessage> runningMessages) {
        if (TaskSumUtil.isRunning(runningMessages)) {
            return Status.TASK_RUNNING;
        }
        if (TaskSumUtil.isAllSuccess(runningMessages)) {
            return Status.SUCCESSFUL;
        }
        if (TaskSumUtil.isPartSuccess(runningMessages)) {
            return Status.PARTIALLY_SUCCEED;
        }
        if (TaskSumUtil.isAllFail(runningMessages)) {
            return Status.FAILED;
        }
        return Status.WAITING_EXEC;
    }

    private static boolean isAllSuccess(List<RunningMessage> runningMessages) {
        return runningMessages.stream().allMatch(TaskSumUtil::isNormal);
    }

    private static boolean isPartSuccess(List<RunningMessage> runningMessages) {
        return runningMessages.stream().anyMatch(TaskSumUtil::isNormal) && runningMessages.stream().anyMatch(TaskSumUtil::isAbnormal);
    }

    private static boolean isAllFail(List<RunningMessage> runningMessages) {
        return runningMessages.stream().allMatch(TaskSumUtil::isAbnormal);
    }

    private static boolean isRunning(List<RunningMessage> runningMessages) {
        return runningMessages.stream().anyMatch(TaskSumUtil::isRunning);
    }

    public static boolean isNormal(RunningMessage runningMessage) {
        return Arrays.asList(Status.PASS, Status.IGNORED, Status.NOT_INVOLVE, Status.SUCCESSFUL).contains((Object)runningMessage.getStatus());
    }

    public static boolean isAbnormal(RunningMessage runningMessage) {
        return Arrays.asList(Status.NOT_PASS, Status.PAUSE, Status.FAILED, Status.NO_CHECK, Status.PARTIALLY_SUCCEED).contains((Object)runningMessage.getStatus());
    }

    public static boolean isWaited(Status status) {
        return Arrays.asList(Status.WAITING, Status.WAITING_EXEC).contains((Object)status);
    }

    public static boolean isRunning(RunningMessage runningMessage) {
        return runningMessage.getStatus() == Status.TASK_RUNNING;
    }

    public static int calculateProgress(List<RunningMessage> runningMessages) {
        AtomicInteger totalProgress = new AtomicInteger();
        runningMessages.forEach(runningMessage -> totalProgress.getAndAdd(runningMessage.getProgress()));
        return totalProgress.get() / runningMessages.size();
    }

    public static String getCurrentDate() {
        return StringUtils.formatDate(new Date(), "yyyy-MM-dd HH:mm:ss");
    }

    public static boolean isConfirm(Status status) {
        return Arrays.asList(Status.CONFIRMING, Status.CONFIRM_TRUE, Status.CONFIRM_FALSE).contains((Object)status);
    }

    public static boolean isIndicatorTask(ItemTask itemTask) {
        return Arrays.asList(LIT_INDICATOR, OFF_INDICATOR).contains(itemTask.getId());
    }

    public static boolean checkStepDeployed(DeployRunningDetail deployRunningDetail, String stepId) {
        List deployedIds = deployRunningDetail.getStepRunningDetails().stream().map(StepRunningDetail::getStepInfo).map(StepInfo::getId).collect(Collectors.toList());
        return deployedIds.contains(stepId);
    }
}

