/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.distributeddeploy.logic.config;

import com.google.common.collect.ImmutableList;
import com.huawei.ism.tool.base.utils.StringUtils;
import com.huawei.ism.tool.distributeddeploy.logic.config.Platform;
import com.huawei.ism.tool.distributeddeploy.logic.config.PlatformStrategy;
import com.huawei.ism.tool.distributeddeploy.logic.config.VersionMappingStrategy;
import com.huawei.ism.tool.distributeddeploy.logic.importfile.DeployFileParseService;
import com.huawei.ism.tool.distributeddeploy.logic.importfile.entity.Attribute;
import com.huawei.ism.tool.distributeddeploy.logic.importfile.exception.ImportFileException;
import com.huawei.ism.tool.obase.exception.ToolException;
import java.io.File;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CustomVersionMappingStrategy {
    private static final Logger log = LoggerFactory.getLogger(CustomVersionMappingStrategy.class);
    private static final Map<String, Map<String, Map<String, PlatformStrategy>>> TASK_CUSTOM_STRATEGY = new ConcurrentHashMap<String, Map<String, Map<String, PlatformStrategy>>>();
    private static final Map<String, Platform> PLATFORM_MAP = new ConcurrentHashMap<String, Platform>();
    private static final List<String> VERSION_SUFFIXES = ImmutableList.of((Object)"", (Object)".convergence", (Object)".block");

    static void initPlatformMap(String version) {
        PLATFORM_MAP.clear();
        PLATFORM_MAP.put("TaiShan V1", Platform.TAISHAN_V1);
        PLATFORM_MAP.put("TaiShan V2", Platform.TAISHAN_V2);
        PLATFORM_MAP.put("x86_64", Platform.X86_64);
        PLATFORM_MAP.put("x86_v6", Platform.X86_V6);
        PLATFORM_MAP.put("OceanStor Pacific 9950", Platform.ATLANTIC);
        PLATFORM_MAP.put("OceanStor A310", Platform.NEW_ATLANTIC);
        PLATFORM_MAP.put("OceanStor Pacific 9550/9350/9150", Platform.PACIFIC);
        PLATFORM_MAP.put("OceanStor Pacific 9546/9346/9146", Platform.EAST_SEA);
        PLATFORM_MAP.put("x86_HG", Platform.HG_X86_64);
        PLATFORM_MAP.put("OceanStor Pacific 9520/9920", Platform.SI_NAN);
        PLATFORM_MAP.put(version.startsWith("a310") ? "OceanStor A310 SSM" : "OceanStor Pacific 9950 SSM", Platform.SSM_ATLANTIC);
    }

    public static Map<String, Map<String, PlatformStrategy>> buildStrategy(String filePath, @NotNull String version) throws ImportFileException, ToolException {
        if (StringUtils.isNULLStr(filePath)) {
            return Collections.emptyMap();
        }
        Map<String, List<Map<String, Attribute>>> fileData = DeployFileParseService.doParsing(new File(filePath), "config/wizard/versionMappingParse.xml");
        List<Map<String, Attribute>> versionMapping = fileData.get("versionMappingParse");
        List<Map<String, Attribute>> softwareVersion = fileData.get("softwareVersion");
        if (CollectionUtils.isEmpty(versionMapping) || CollectionUtils.isEmpty(softwareVersion)) {
            throw new ToolException("version.mapping.file.error");
        }
        String fileVersion = softwareVersion.get(0).get("version").getValue();
        if (VERSION_SUFFIXES.stream().noneMatch(suffix -> version.equals(fileVersion.concat((String)suffix)))) {
            throw new ToolException("version.mapping.version.match.error");
        }
        CustomVersionMappingStrategy.initPlatformMap(version);
        return CustomVersionMappingStrategy.buildStrategy(fileVersion, versionMapping, version);
    }

    public static void updateStrategy(@NotNull String key, Map<String, Map<String, PlatformStrategy>> strategy) {
        TASK_CUSTOM_STRATEGY.put(key, strategy);
    }

    public static Map<String, Map<String, PlatformStrategy>> getStrategy(@NotNull String key) {
        return TASK_CUSTOM_STRATEGY.getOrDefault(key, Collections.emptyMap());
    }

    private static Map<String, Map<String, PlatformStrategy>> buildStrategy(String fileVersion, List<Map<String, Attribute>> versionMapping, String selectVersion) throws ToolException {
        Map<String, List<Map>> serverTypeMap = versionMapping.stream().collect(Collectors.groupingBy(p -> ((Attribute)p.get("serverType")).getValue()));
        Map<String, PlatformStrategy> strategyMap = serverTypeMap.entrySet().stream().filter(entry -> PLATFORM_MAP.containsKey(entry.getKey())).collect(Collectors.toMap(entry -> PLATFORM_MAP.get(entry.getKey()).getId(), entry -> CustomVersionMappingStrategy.toPlatformStrategy((String)entry.getKey(), (List)entry.getValue())));
        CustomVersionMappingStrategy.compareVersionMapping(strategyMap, selectVersion);
        HashMap<String, Map<String, PlatformStrategy>> strategy = new HashMap<String, Map<String, PlatformStrategy>>();
        VERSION_SUFFIXES.forEach(suffix -> strategy.put(fileVersion.concat((String)suffix), strategyMap));
        return strategy;
    }

    static void compareVersionMapping(Map<String, PlatformStrategy> strategyMap, String selectVersion) throws ToolException {
        Map<String, PlatformStrategy> innerXmlStrategy = VersionMappingStrategy.INS.getStrategy().get(selectVersion);
        if (MapUtils.isEmpty(innerXmlStrategy)) {
            log.info("skip current version {} for has no inner strategy", (Object)selectVersion);
            return;
        }
        for (Map.Entry<String, PlatformStrategy> entry : innerXmlStrategy.entrySet()) {
            if (!strategyMap.containsKey(entry.getKey())) {
                throw new ToolException("version.mapping.check.version.failed");
            }
            List<String> fileKeys = strategyMap.get(entry.getKey()).getAttributeKey();
            List<String> innerKeys = entry.getValue().getAttributeKey();
            String unmatchKeys = innerKeys.stream().filter(key -> !fileKeys.contains(key)).collect(Collectors.joining(","));
            if (StringUtils.isNULLStr(unmatchKeys)) continue;
            throw new ToolException("version.mapping.check.version.failed");
        }
    }

    private static PlatformStrategy toPlatformStrategy(String serverType, List<Map<String, Attribute>> attributes) {
        PlatformStrategy strategy = new PlatformStrategy(PLATFORM_MAP.getOrDefault(serverType, Platform.UNKNOWN));
        attributes.forEach(attribute -> strategy.addAttribute(((Attribute)attribute.get("softwareName")).getValue(), ((Attribute)attribute.get("key")).getValue(), ((Attribute)attribute.get("version")).getValue(), ((Attribute)attribute.get("remark")).getValue(), ((Attribute)attribute.get("remark")).getValue()));
        return strategy;
    }

    private CustomVersionMappingStrategy() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

