/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.distributeddeploy.logic.config;

import com.huawei.ism.tool.distributeddeploy.logic.config.Platform;
import com.huawei.ism.tool.obase.utils.ApplicationContext;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public class PlatformStrategy {
    private static final Attribute NONE = new Attribute("--", "--", "--", "--", "--");
    private Platform platform;
    private Set<Attribute> attributes = new HashSet<Attribute>();

    public PlatformStrategy(Platform platform) {
        this.platform = platform;
    }

    public String getPlatformId() {
        return this.platform.getId();
    }

    public PlatformStrategy getSelf() {
        return this;
    }

    void addAttribute(String name, String key, String value, String zhUrl, String enUrl) {
        this.attributes.add(new Attribute(name, key, value, zhUrl, enUrl));
    }

    public String findAttributeValue(String key) {
        return this.attributes.stream().filter(attribute -> attribute.getKey().equals(key)).findFirst().orElse(NONE).getValue();
    }

    public String findAttributeUrl(String key) {
        return this.attributes.stream().filter(attribute -> attribute.getKey().equals(key)).findFirst().orElse(NONE).getUrl();
    }

    public List<String> getAttributeKey() {
        return this.attributes.stream().map(Attribute::getKey).collect(Collectors.toList());
    }

    public Platform getPlatform() {
        return this.platform;
    }

    private static class Attribute {
        private String name;
        private String key;
        private String value;
        private String zhUrl;
        private String enUrl;

        public String getUrl() {
            return ApplicationContext.getInstance().isEnglishEnv() ? this.enUrl : this.zhUrl;
        }

        public Attribute(String name, String key, String value, String zhUrl, String enUrl) {
            this.name = name;
            this.key = key;
            this.value = value;
            this.zhUrl = zhUrl;
            this.enUrl = enUrl;
        }

        public String getName() {
            return this.name;
        }

        public String getKey() {
            return this.key;
        }

        public String getValue() {
            return this.value;
        }

        public String getZhUrl() {
            return this.zhUrl;
        }

        public String getEnUrl() {
            return this.enUrl;
        }

        public void setName(String name) {
            this.name = name;
        }

        public void setKey(String key) {
            this.key = key;
        }

        public void setValue(String value) {
            this.value = value;
        }

        public void setZhUrl(String zhUrl) {
            this.zhUrl = zhUrl;
        }

        public void setEnUrl(String enUrl) {
            this.enUrl = enUrl;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Attribute)) {
                return false;
            }
            Attribute other = (Attribute)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$key = this.getKey();
            String other$key = other.getKey();
            if (this$key == null ? other$key != null : !this$key.equals(other$key)) {
                return false;
            }
            String this$zhUrl = this.getZhUrl();
            String other$zhUrl = other.getZhUrl();
            if (this$zhUrl == null ? other$zhUrl != null : !this$zhUrl.equals(other$zhUrl)) {
                return false;
            }
            String this$enUrl = this.getEnUrl();
            String other$enUrl = other.getEnUrl();
            return !(this$enUrl == null ? other$enUrl != null : !this$enUrl.equals(other$enUrl));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Attribute;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $key = this.getKey();
            result = result * 59 + ($key == null ? 43 : $key.hashCode());
            String $zhUrl = this.getZhUrl();
            result = result * 59 + ($zhUrl == null ? 43 : $zhUrl.hashCode());
            String $enUrl = this.getEnUrl();
            result = result * 59 + ($enUrl == null ? 43 : $enUrl.hashCode());
            return result;
        }
    }
}

