/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.distributeddeploy.logic.config;

import com.huawei.ism.tool.base.utils.StringUtils;
import com.huawei.ism.tool.base.utils.XmlUtils;
import com.huawei.ism.tool.distributeddeploy.common.Constants;
import com.huawei.ism.tool.distributeddeploy.common.Context;
import com.huawei.ism.tool.distributeddeploy.entity.CardInfo;
import com.huawei.ism.tool.distributeddeploy.entity.Product;
import com.huawei.ism.tool.distributeddeploy.entity.StepInfo;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ProductStrategy {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProductStrategy.class);
    private static final String XPATH_VERSION_EXP = "product/versionList/version";
    private static final String XPATH_LINK_EXP = "product/versionList/link";
    private static final String XPATH_MODEL_EXP = "modelList/model";
    private static final String XML_TAG_MODEL_NAME = "name";
    private static final String XML_TAG_MODEL_PLATFORM_KEY = "platformId";
    private static final String XML_TAG_MODEL_ID_KEY = "productUniqueId";
    private static final String XPATH_STEP_EXP = "product/stepList/step";
    private static final String XPATH_MODE_EXP = "product/cardList/card";
    private static final String XPATH_FIT_STEP_EXP = "product/fitStepList/step";
    private static final String XPATH_ITEM_EXP = "product/itemList/item";
    private static final String STRATEGY_PATH = Constants.STRATEGY_PACKAGE + File.separator + "strategy.xml";
    private static final String XML_TAG_ID = "id";
    private static final String XML_TAG_ITEM = "item";
    private static final String BMC_CONFIG_STRATEGY_PATH = Constants.STRATEGY_PACKAGE + File.separator + "config_strategy.xml";
    private static final String CUBE_STRATEGY_PATH = Constants.STRATEGY_PACKAGE + File.separator + "cube_strategy.xml";
    private static final String SYSTEM_STRATEGY_PATH = Constants.STRATEGY_PACKAGE + File.separator + "system_strategy.xml";
    private final List<StepInfo> bmcStepInfos = new ArrayList<StepInfo>();
    private final List<StepInfo> systemStepInfos = new ArrayList<StepInfo>();
    private final List<StepInfo> cubeStepInfos = new ArrayList<StepInfo>();
    private final List<StepInfo> stepInfoList = new ArrayList<StepInfo>();
    private final Map<String, StepInfo> fitStepInfoMap = new LinkedHashMap<String, StepInfo>();
    private final Map<String, StepInfo.Item> itemMap = new HashMap<String, StepInfo.Item>();
    private final Map<String, Map<String, Product>> products = new HashMap<String, Map<String, Product>>();
    private final List<CardInfo> modeList = new ArrayList<CardInfo>();
    public static final ProductStrategy INS = new ProductStrategy();

    private ProductStrategy() {
        this.initStrategy(STRATEGY_PATH, this.stepInfoList);
        this.initStrategy(CUBE_STRATEGY_PATH, this.cubeStepInfos);
        this.initStrategy(BMC_CONFIG_STRATEGY_PATH, this.bmcStepInfos);
        this.initStrategy(SYSTEM_STRATEGY_PATH, this.systemStepInfos);
    }

    void initStrategy(String path, List<StepInfo> stepInfoList) {
        File strategyFile = new File(path);
        if (!strategyFile.exists()) {
            LOGGER.warn("Strategy file is not exist.");
        }
        try (InputStream inputStream = Files.newInputStream(strategyFile.toPath(), new OpenOption[0]);){
            Document doc = XmlUtils.parseDocument(inputStream);
            this.initSupportProduct(doc);
            this.initMode(doc);
            this.initDeployStep(doc, stepInfoList);
            this.appendFitItems(doc);
            this.initFitDeployStep(doc);
            this.initLinkStrategy(doc, strategyFile, stepInfoList);
        }
        catch (Exception e) {
            LOGGER.error("Parse strategy file error.", (Throwable)e);
        }
    }

    private void initLinkStrategy(Document doc, File strategyFile, List<StepInfo> stepInfoList) throws IOException {
        NodeList linkNodeList = XmlUtils.searchNodeByExp(doc, XPATH_LINK_EXP);
        if (linkNodeList.getLength() <= 0) {
            return;
        }
        for (int index = 0; index < linkNodeList.getLength(); ++index) {
            Node item = linkNodeList.item(index);
            if (!(item instanceof Element)) continue;
            this.initStrategy(new File(strategyFile.getParentFile(), ((Element)item).getAttribute(XML_TAG_ID)).getCanonicalPath(), stepInfoList);
        }
    }

    private void initMode(Document doc) {
        NodeList nodeList = XmlUtils.searchNodeByExp(doc, XPATH_MODE_EXP);
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (!(node instanceof Element)) continue;
            Element stepEle = (Element)node;
            String id = stepEle.getAttribute(XML_TAG_ID);
            this.modeList.add(new CardInfo(id));
        }
    }

    private void initDeployStep(Document doc, List<StepInfo> stepInfoList) {
        NodeList nodeList = XmlUtils.searchNodeByExp(doc, XPATH_STEP_EXP);
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (!(node instanceof Element)) continue;
            Element stepEle = (Element)node;
            String stepId = stepEle.getAttribute(XML_TAG_ID);
            stepInfoList.add(new StepInfo(stepId, this.initItemList(stepEle)));
        }
    }

    private void initFitDeployStep(Document doc) {
        NodeList nodeList = XmlUtils.searchNodeByExp(doc, XPATH_FIT_STEP_EXP);
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (!(node instanceof Element)) continue;
            Element stepEle = (Element)node;
            String stepId = stepEle.getAttribute(XML_TAG_ID);
            this.fitStepInfoMap.put(stepId, new StepInfo(stepId, this.buildItemList(stepEle)));
        }
    }

    private List<StepInfo.Item> buildItemList(Element stepEle) {
        return XmlUtils.getChildren(stepEle, XML_TAG_ITEM).stream().map(itemEle -> itemEle.getAttribute(XML_TAG_ID)).filter(itemId -> this.itemMap.containsKey(itemId)).map(this::getItem).collect(Collectors.toList());
    }

    private StepInfo.Item getItem(String itemId) {
        return this.itemMap.get(itemId);
    }

    private void appendFitItems(Document doc) {
        NodeList nodeList = XmlUtils.searchNodeByExp(doc, XPATH_ITEM_EXP);
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (!(node instanceof Element)) continue;
            Element itemEle = (Element)node;
            String itemId = itemEle.getAttribute(XML_TAG_ID);
            this.itemMap.put(itemId, this.buildItem(itemEle));
        }
    }

    private List<StepInfo.Item> initItemList(Element stepEle) {
        return XmlUtils.getChildren(stepEle, XML_TAG_ITEM).stream().map(this::buildItem).collect(Collectors.toList());
    }

    private StepInfo.Item buildItem(Element itemEle) {
        boolean continueExecWhenFailed = !"false".equals(itemEle.getAttribute("failed_continue"));
        Element involveElement = XmlUtils.getChild(itemEle, "involve");
        List<String> involves = Collections.EMPTY_LIST;
        if (involveElement != null && !StringUtils.isNULLStr(involveElement.getTextContent())) {
            involves = Arrays.stream(involveElement.getTextContent().split(",")).map(String::trim).collect(Collectors.toList());
        }
        boolean canJudgeInvolveAfter = "true".equals(itemEle.getAttribute("can_judge_involve_after"));
        String failedRetry = itemEle.getAttribute("failed_retry");
        String supportScene = itemEle.getAttribute("supportScene");
        supportScene = StringUtils.isNULLStr(supportScene) ? "full" : supportScene + "full";
        int failedRetryTimes = StringUtils.isNULLStr(failedRetry) ? 0 : Integer.parseInt(failedRetry);
        StepInfo.Item item = new StepInfo.Item();
        item.setCanJudgeInvolveAfter(canJudgeInvolveAfter);
        item.setFailedContinue(continueExecWhenFailed);
        item.setCanRetry("true".equals(itemEle.getAttribute("can_retry")));
        item.setCanIgnore("true".equals(itemEle.getAttribute("can_ignore")));
        item.setFailedRetryTimes(failedRetryTimes);
        item.setInvolves(involves);
        item.setSupportScene(supportScene);
        item.setId(itemEle.getAttribute(XML_TAG_ID));
        boolean isCheckSupportAlone = "true".equals(itemEle.getAttribute("isCheckSupportAlone"));
        item.setCheckSupportAlone(isCheckSupportAlone);
        this.itemMap.put(item.getId(), item);
        return item;
    }

    private void initSupportProduct(Document doc) {
        NodeList nodeList = XmlUtils.searchNodeByExp(doc, XPATH_VERSION_EXP);
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (!(node instanceof Element)) continue;
            Element modelEle = (Element)node;
            Map<String, Product> versionProducts = this.parseVersionProduct(modelEle);
            Arrays.stream(modelEle.getAttribute(XML_TAG_ID).split(",")).forEach(version -> this.products.put((String)version, versionProducts));
        }
    }

    private Map<String, Product> parseVersionProduct(Element version) {
        HashMap<String, Product> versionProducts = new HashMap<String, Product>();
        NodeList nodeList = XmlUtils.searchNodeByExp(version, XPATH_MODEL_EXP);
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (!(node instanceof Element)) continue;
            Product product = new Product();
            Element modelEle = (Element)node;
            Element nameKeyEle = XmlUtils.getChild(modelEle, XML_TAG_MODEL_NAME);
            product.setName(nameKeyEle.getTextContent());
            Element platformIdEle = XmlUtils.getChild(modelEle, XML_TAG_MODEL_PLATFORM_KEY);
            Element uniqueIdEle = XmlUtils.getChild(modelEle, XML_TAG_MODEL_ID_KEY);
            this.parseUniqueIds(product, uniqueIdEle);
            versionProducts.put(platformIdEle.getTextContent(), product);
        }
        return versionProducts;
    }

    private void parseUniqueIds(Product product, Element uniqueIdEle) {
        NodeList devTypeList = XmlUtils.searchNodeByExp(uniqueIdEle, "type");
        for (int i = 0; i < devTypeList.getLength(); ++i) {
            Node node = devTypeList.item(i);
            if (!(node instanceof Element)) continue;
            Element devTypeEle = (Element)node;
            product.addUniqueId(devTypeEle.getAttribute(XML_TAG_ID), devTypeEle.getTextContent());
        }
    }

    public Map<String, Product> getCurrentProducts() {
        return this.products.getOrDefault(Context.INS.getCurrentMappingVersion(), Collections.emptyMap());
    }

    public Map<String, Product> getProductsByVersion(String mappingVersion) {
        return this.products.getOrDefault(mappingVersion, Collections.emptyMap());
    }

    private Set<String> getAllSupportServerUid() {
        HashSet<String> serverProduct = new HashSet<String>();
        INS.getProducts().values().forEach(entry -> entry.values().forEach(product -> product.getDevType2UniqueIds().values().forEach(serverProduct::addAll)));
        return serverProduct;
    }

    public boolean isSupport(String uniqueId) {
        return this.getAllSupportServerUid().stream().anyMatch(support -> support.contains(uniqueId));
    }

    public String getPlatformIdByServerUid(String uniqueId, @Nullable String mappingVersion) {
        Map<String, Map<String, Product>> productMaps = StringUtils.isNULLStr(mappingVersion) ? this.getProducts() : Collections.singletonMap(mappingVersion, this.getProductsByVersion(mappingVersion));
        return productMaps.values().stream().flatMap(map -> map.entrySet().stream()).filter(entry -> this.isProductSupportUid((Product)entry.getValue(), uniqueId)).map(Map.Entry::getKey).findFirst().orElse("");
    }

    private boolean isProductSupportUid(Product product, String uniqueId) {
        return product.getDevType2UniqueIds().values().stream().flatMap(Collection::stream).anyMatch(uid -> Objects.equals(uid, uniqueId.toLowerCase(Locale.ROOT)));
    }

    public List<StepInfo> getStepInfoByScene(String sceneId) {
        return this.getStepInfoList().stream().filter(stepInfo -> stepInfo.needShowStep(sceneId)).collect(Collectors.toList());
    }

    public List<StepInfo> getFitStepInfos() {
        return new ArrayList<StepInfo>(this.fitStepInfoMap.values());
    }

    public Set<String> getFitStepIds() {
        return this.fitStepInfoMap.keySet();
    }

    public List<StepInfo> getBmcStepInfos() {
        return this.bmcStepInfos;
    }

    public List<StepInfo> getSystemStepInfos() {
        return this.systemStepInfos;
    }

    public List<StepInfo> getCubeStepInfos() {
        return this.cubeStepInfos;
    }

    public List<StepInfo> getStepInfoList() {
        return this.stepInfoList;
    }

    public Map<String, StepInfo> getFitStepInfoMap() {
        return this.fitStepInfoMap;
    }

    public Map<String, Map<String, Product>> getProducts() {
        return this.products;
    }

    public List<CardInfo> getModeList() {
        return this.modeList;
    }
}

