/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.distributeddeploy.logic.config;

import com.huawei.ism.tool.distributeddeploy.common.ToolConfig;
import com.huawei.ism.tool.obase.connection.DefaultSshJudge;
import com.huawei.ism.tool.obase.utils.CollectionUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class SshJudge
extends DefaultSshJudge {
    private static final List<String> END_STR = new ArrayList<String>();
    private List<String> customEndStr = new ArrayList<String>();
    public static final SshJudge INS = new SshJudge();

    private SshJudge() {
        this.addExcludeEndJudge("]");
    }

    public void setEndStr(List<String> endStr) {
        if (CollectionUtil.isEmpty(endStr)) {
            return;
        }
        this.removeJudge();
        this.customEndStr.addAll(endStr);
    }

    public void removeJudge() {
        this.customEndStr.clear();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isSshFinish(String cmdResult, String userName) {
        if (super.isSshFinish(cmdResult, userName)) {
            return true;
        }
        String trimmedCmdResult = cmdResult.trim();
        if (END_STR.stream().anyMatch(trimmedCmdResult::endsWith)) return true;
        if (!this.customEndStr.stream().anyMatch(trimmedCmdResult::endsWith)) return false;
        return true;
    }

    static {
        END_STR.addAll(Arrays.asList(ToolConfig.getSshJudge().split(",")));
    }
}

