/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.distributeddeploy.logic.config;

import com.huawei.ism.tool.base.utils.SceneUtils;
import com.huawei.ism.tool.base.utils.XmlUtils;
import com.huawei.ism.tool.distributeddeploy.common.Constants;
import com.huawei.ism.tool.distributeddeploy.logic.config.Platform;
import com.huawei.ism.tool.distributeddeploy.logic.config.PlatformStrategy;
import com.huawei.ism.tool.framework.platform.util.UserOpDataSaveUtil;
import com.huawei.ism.tool.obase.utils.ApplicationContext;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class VersionMappingStrategy {
    private static final Logger LOGGER = LoggerFactory.getLogger(VersionMappingStrategy.class);
    private static final String VERSION_MAPPING_LOCAL = Constants.PYTHON_BUSINESS_PATH_DIR + File.separator + "Version_Mapping.xml";
    private static final String XQL_PRODUCT_EXP = "config/product";
    private static final String PLATFORM_TAG = "platform";
    private static final String ATTRIBUTE_TAG = "attribute";
    private static final String ATTR_NAME_KEY = "name";
    private static final String KEY = "key";
    private static final String ZH_SOURCE = "zhSource";
    private static final String EN_SOURCE = "enSource";
    private static final String VALUE = "value";
    private static final String ZH_URL = "zhUrl";
    private static final String EN_URL = "enUrl";
    private static final String DATE_FORMAT = "yyyy-MM-dd";
    private static final String STRATEGY_UPDATE_TIME_KEY = "updateTime";
    private static final String STRATEGY_MINI_TOOL_VERSION = "minToolVersion";
    private static final String TOOL_VERSION_KEY = "tool.version";
    private static final String[] HPDA_SCENE_ID = new String[]{"HPDADeploy_genesequencing", "HPDADeploy_edueesearch", "HPDADeploy_edueesearch110", "HPDADeploy_edueesearch120", "HPDADeploy_genesequencing110", "RECOVERYDeploy_disasterrecovery"};
    private static final Set<String> CUBE_VERSION = new HashSet<String>(Arrays.asList("FusionCube 1000D", "FusionCube 1000H"));
    private Map<String, Map<String, PlatformStrategy>> strategy = new ConcurrentHashMap<String, Map<String, PlatformStrategy>>();
    private final Map<String, Map<String, String>> sourceMappingFile = new ConcurrentHashMap<String, Map<String, String>>();
    public static VersionMappingStrategy INS = new VersionMappingStrategy();
    private String updateToolTips = "";

    private VersionMappingStrategy() {
        this.init();
    }

    private void init() {
        try {
            Document doc = this.initDoc();
            this.initProductsStrategy(doc);
            this.refreshStrategyInHPDA();
        }
        catch (Exception e) {
            LOGGER.error("init mapping strategy failed", (Throwable)e);
        }
    }

    public Map<String, Map<String, PlatformStrategy>> getStrategy() {
        return this.strategy;
    }

    private Document initDoc() throws FileNotFoundException {
        Document localDoc = XmlUtils.parseDocument(new FileInputStream(VERSION_MAPPING_LOCAL));
        Document remoteDoc = this.initRemoteDoc();
        if (remoteDoc == null) {
            LOGGER.info("Can not find remote strategy or parse error,using local strategy.");
            return localDoc;
        }
        return this.compareVerInfoAndGetDoc(localDoc, remoteDoc);
    }

    private Document compareVerInfoAndGetDoc(Document localDoc, Document remoteDoc) {
        Element localDocRoot = localDoc.getDocumentElement();
        String localDate = localDocRoot.getAttribute(STRATEGY_UPDATE_TIME_KEY);
        Element remoteDocRoot = remoteDoc.getDocumentElement();
        String remoteDate = remoteDocRoot.getAttribute(STRATEGY_UPDATE_TIME_KEY);
        String miniToolVer = remoteDocRoot.getAttribute(STRATEGY_MINI_TOOL_VERSION);
        String currentToolVer = UserOpDataSaveUtil.getToolIniProp(TOOL_VERSION_KEY);
        Calendar localCalendar = Calendar.getInstance();
        Calendar remoteCalendar = Calendar.getInstance();
        try {
            localCalendar.setTime(this.parseUpdateDate(localDate));
            remoteCalendar.setTime(this.parseUpdateDate(remoteDate));
        }
        catch (Exception e) {
            LOGGER.error("Compare version error.", (Throwable)e);
            return localDoc;
        }
        LOGGER.info("Remote mapping strategy update time {} , local strategy update time is {}.", (Object)remoteDate, (Object)localDate);
        if (remoteCalendar.after(localCalendar)) {
            if (currentToolVer.compareTo(miniToolVer) < 0) {
                LOGGER.info("Current tool version : {} is lower than minToolVersion {}.", (Object)currentToolVer, (Object)miniToolVer);
                this.updateToolTips = ResourceUtil.getStringWithParams((String)"deploy.tool.update.tips", (Object[])new Object[]{currentToolVer, miniToolVer});
                return localDoc;
            }
            LOGGER.info("Using remote mapping strategy.");
            return remoteDoc;
        }
        return localDoc;
    }

    private Document initRemoteDoc() {
        String remoteMappingPath = ApplicationContext.getInstance().getWorkPath() + File.separator + "updates" + File.separator + "deployHelper" + File.separator + "Version_Mapping.xml";
        Document docRemote = null;
        try {
            docRemote = XmlUtils.parseDocument(new FileInputStream(new File(remoteMappingPath)));
        }
        catch (FileNotFoundException e) {
            LOGGER.warn("Can not find remote mapping file.");
        }
        catch (Exception e) {
            LOGGER.warn("Remote mapping file parse err.", (Throwable)e);
        }
        return docRemote;
    }

    private Date parseUpdateDate(String date) throws ParseException {
        SimpleDateFormat sdf = new SimpleDateFormat(DATE_FORMAT);
        return sdf.parse(date);
    }

    private void initProductsStrategy(Document doc) {
        NodeList productList = XmlUtils.searchNodeByExp(doc, XQL_PRODUCT_EXP);
        for (int i = 0; i < productList.getLength(); ++i) {
            Node node = productList.item(i);
            if (!(node instanceof Element)) continue;
            this.initProductStrategy((Element)node);
        }
    }

    public void refreshStrategyInHPDA() {
        if (Arrays.stream(HPDA_SCENE_ID).noneMatch(SceneUtils.getCurrentSubScene()::equals)) {
            return;
        }
        String versionListStr = SceneUtils.getParamFormArgList("versionList");
        if (!versionListStr.isEmpty()) {
            LOGGER.info("HPDA scene support version list is: {}", (Object)versionListStr);
            List<String> versionList = Arrays.asList(versionListStr.split(","));
            this.strategy.keySet().stream().filter(version -> !versionList.contains(version)).forEach(this.strategy::remove);
        }
    }

    private void initProductStrategy(Element product) {
        String[] products = product.getAttribute(KEY).split(",");
        Map<String, PlatformStrategy> productStrategy = this.initPlatformStrategy(product);
        Map<String, String> sourceFile = this.initSourceMappingFile(product);
        Arrays.stream(products).forEach(productKey -> this.strategy.put((String)productKey, productStrategy));
        Arrays.stream(products).forEach(productKey -> this.sourceMappingFile.put((String)productKey, sourceFile));
    }

    private Map<String, PlatformStrategy> initPlatformStrategy(Element product) {
        return XmlUtils.getChildren(product, PLATFORM_TAG).stream().map(this::initPlatformAttribute).collect(Collectors.toMap(PlatformStrategy::getPlatformId, PlatformStrategy::getSelf));
    }

    private Map<String, String> initSourceMappingFile(Element product) {
        String enSource = product.getAttribute(EN_SOURCE);
        String zhSource = product.getAttribute(ZH_SOURCE);
        HashMap<String, String> mappingFile = new HashMap<String, String>();
        mappingFile.put("en", enSource);
        mappingFile.put("zh", zhSource);
        return mappingFile;
    }

    private PlatformStrategy initPlatformAttribute(Element platformEle) {
        String id = platformEle.getAttribute(KEY);
        PlatformStrategy platformStrategy = new PlatformStrategy(Platform.findPlatform(id));
        this.appendAttribute(platformEle, platformStrategy);
        return platformStrategy;
    }

    private void appendAttribute(Element platformEle, PlatformStrategy platformStrategy) {
        XmlUtils.getChildren(platformEle, ATTRIBUTE_TAG).forEach(attributeEle -> platformStrategy.addAttribute(attributeEle.getAttribute(ATTR_NAME_KEY), attributeEle.getAttribute(KEY), attributeEle.getAttribute(VALUE), attributeEle.getAttribute(ZH_URL), attributeEle.getAttribute(EN_URL)));
    }

    public String getSourceFile(String version) {
        return this.sourceMappingFile.getOrDefault(version, Collections.emptyMap()).getOrDefault(ApplicationContext.getInstance().getCurrentLanguage().getLanguage(), "");
    }

    public Set<String> getCubeVersion() {
        return new HashSet<String>(CUBE_VERSION);
    }

    public void setStrategy(Map<String, Map<String, PlatformStrategy>> strategy) {
        this.strategy = strategy;
    }

    public String getUpdateToolTips() {
        return this.updateToolTips;
    }
}

