/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.distributeddeploy.logic.importfile;

import com.huawei.ism.tool.distributeddeploy.logic.importfile.data.FileDataParseTask;
import com.huawei.ism.tool.distributeddeploy.logic.importfile.entity.Attribute;
import com.huawei.ism.tool.distributeddeploy.logic.importfile.exception.ImportFileException;
import com.huawei.ism.tool.distributeddeploy.logic.importfile.verify.VerifyTask;
import com.huawei.ism.tool.obase.exception.ToolException;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import java.io.File;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeployFileParseService {
    private static final Logger log = LoggerFactory.getLogger(DeployFileParseService.class);

    public static Map<String, List<Map<String, Attribute>>> doParsing(File deployFile, String strategyFilePath) throws ImportFileException, ToolException {
        try {
            Map fileDatas = (Map)new FileDataParseTask(deployFile, strategyFilePath).run();
            fileDatas = (Map)new VerifyTask(fileDatas).run();
            return fileDatas;
        }
        catch (ImportFileException | ToolException e) {
            throw e;
        }
        catch (Exception e) {
            log.error("parse file exception", (Throwable)e);
            throw new ToolException(ResourceUtil.getString((String)"importFile.parse.exception"), false);
        }
    }

    private DeployFileParseService() {
    }
}

