/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.distributeddeploy.logic.importfile.data;

import com.google.common.collect.Lists;
import com.huawei.ism.tool.base.utils.StreamUtils;
import com.huawei.ism.tool.base.utils.XmlUtils;
import com.huawei.ism.tool.distributeddeploy.common.Context;
import com.huawei.ism.tool.distributeddeploy.fit.common.ObserverManager;
import com.huawei.ism.tool.distributeddeploy.logic.importfile.entity.Attribute;
import com.huawei.ism.tool.distributeddeploy.logic.importfile.entity.TableType;
import com.huawei.ism.tool.distributeddeploy.logic.importfile.impl.Task;
import com.huawei.ism.tool.distributeddeploy.logic.importfile.verify.impl.Verifier;
import com.huawei.ism.tool.distributeddeploy.ui.card.Card;
import com.huawei.ism.tool.obase.exception.ToolException;
import com.huawei.ism.tool.obase.log.ToolLoggerFactory;
import com.huawei.ism.tool.obase.utils.ApplicationContext;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import com.huawei.ism.tool.obase.utils.StringUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.slf4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class FileDataParseTask
extends Task<Map<String, List<Map<String, Attribute>>>> {
    private static final Logger LOGGER = ToolLoggerFactory.getLogger(FileDataParseTask.class);
    private static final String SCENE_SPLIT = ",";
    private static final String TABLE_NAME_SPLIT = "\\|";
    private static final String COMPATIBLE_MSG = " " + ResourceUtil.getString((String)"importFile.data.compatible.key");
    private Workbook workbook;
    private final File deployFile;
    private final String strategyFilePath;
    private static final String LAN_KEY = ApplicationContext.getInstance().getCurrentLanguage().getLanguage();

    public FileDataParseTask(File deployFile, String strategyFilePath) {
        this.deployFile = deployFile;
        this.strategyFilePath = strategyFilePath;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected Map<String, List<Map<String, Attribute>>> doTask() throws ToolException {
        try (FileInputStream fis = new FileInputStream(this.deployFile);){
            this.initWorkbook(fis);
            Map<String, List<Map<String, Attribute>>> map = this.loadDeployFileData();
            return map;
        }
        catch (IOException | IllegalArgumentException e) {
            LOGGER.error("read deploy file failed.", (Throwable)e);
            throw new ToolException(ResourceUtil.getString((String)"importFile.data.readFileFailed"));
        }
    }

    private void initWorkbook(FileInputStream fis) throws IOException {
        if (this.deployFile.getName().endsWith("xls")) {
            this.workbook = new HSSFWorkbook((InputStream)fis);
            return;
        }
        this.workbook = new XSSFWorkbook((InputStream)fis);
    }

    private Map<String, List<Map<String, Attribute>>> loadDeployFileData() throws ToolException {
        Element root = Optional.ofNullable(FileDataParseTask.class.getClassLoader()).map(classLoader -> classLoader.getResourceAsStream(this.strategyFilePath)).map(this::parseDocument).map(Document::getDocumentElement).orElseThrow(() -> new ToolException(ResourceUtil.getString((String)"importFile.data.readStrategyFileFailed")));
        HashMap<String, List<Map<String, Attribute>>> tableDatas = new HashMap<String, List<Map<String, Attribute>>>();
        XmlUtils.getChildren(root, "table").forEach(element -> this.parseTable((Element)element).ifPresent(tableDatas::putAll));
        return tableDatas;
    }

    private Document parseDocument(InputStream stream) {
        Document document = XmlUtils.parseDocument(stream);
        StreamUtils.closeStream(null, stream);
        return document;
    }

    private Optional<Map<String, List<Map<String, Attribute>>>> parseTable(Element tableElement) {
        String sheetName = this.getSheetName(tableElement);
        Sheet sheet = this.workbook.getSheet(sheetName);
        if (Objects.isNull(sheet)) {
            LOGGER.info("current sheet :{}  not found ", (Object)sheetName);
            return Optional.empty();
        }
        LOGGER.info("parse sheet :{}", (Object)sheetName);
        this.writeMergedValue(sheet);
        TableType tableType = TableType.valueOf(tableElement.getAttribute("type").toUpperCase(Locale.ENGLISH));
        int startRow = Integer.parseInt(tableElement.getAttribute("startRow"));
        String tableKey = tableElement.getAttribute("key");
        HashMap<String, List<Map<String, Attribute>>> tableDatas = new HashMap<String, List<Map<String, Attribute>>>();
        switch (tableType) {
            case HORIZONTAL: {
                tableDatas.put(tableKey, this.parseHorizontalTable(tableElement, sheet, startRow));
                break;
            }
            case VERTICAL: {
                if (StringUtils.isNULLStr((String)tableElement.getAttribute("rowInterval"))) {
                    tableDatas.put(tableKey, this.parseVerticalTable(tableElement, sheet, startRow));
                    break;
                }
                int rowInternal = Integer.parseInt(tableElement.getAttribute("rowInterval"));
                tableDatas.put(tableKey, this.parseVerticalTable(tableElement, sheet, startRow, rowInternal));
                break;
            }
            case VERTICAL_HORIZONTAL: {
                String horizontalKeys = tableElement.getAttribute("horizontalKeys");
                String[] tableKeys = horizontalKeys.split(SCENE_SPLIT);
                for (int keyIndex = 0; keyIndex < tableKeys.length; ++keyIndex) {
                    tableDatas.put(tableKeys[keyIndex], this.parseVerticalTable(tableElement, sheet, startRow + keyIndex, tableKeys.length));
                }
                break;
            }
            default: {
                LOGGER.error("Can't identify table type: {}", (Object)tableType);
            }
        }
        return Optional.of(tableDatas);
    }

    private String getSheetName(Element tableElement) {
        String sheetName = tableElement.getAttribute("sheetName");
        Locale currentLanguage = ApplicationContext.getInstance().getCurrentLanguage();
        return this.isChinese(currentLanguage) ? sheetName.split(TABLE_NAME_SPLIT)[0] : sheetName.split(TABLE_NAME_SPLIT)[1];
    }

    private boolean isChinese(Locale currentLanguage) {
        return currentLanguage.getLanguage().equals("zh");
    }

    private void writeMergedValue(Sheet sheet) {
        int sheetMergeCount = sheet.getNumMergedRegions();
        for (int i = 0; i < sheetMergeCount; ++i) {
            CellRangeAddress range = sheet.getMergedRegion(i);
            int firstColumn = range.getFirstColumn();
            int lastColumn = range.getLastColumn();
            int firstRow = range.getFirstRow();
            int lastRow = range.getLastRow();
            this.setCellValueForMergedCell(sheet, firstColumn, lastColumn, firstRow, lastRow);
        }
    }

    private void setCellValueForMergedCell(Sheet sheet, int firstColumn, int lastColumn, int firstRow, int lastRow) {
        String mergedValue = this.getStringCellValue(sheet, firstRow, firstColumn);
        if (StringUtils.isNULLStr((String)mergedValue)) {
            return;
        }
        for (int rowIndex = firstRow; rowIndex <= lastRow; ++rowIndex) {
            for (int colIndex = firstColumn; colIndex <= lastColumn; ++colIndex) {
                Row row = sheet.getRow(rowIndex);
                if (row == null || row.getCell(colIndex) == null) continue;
                Cell cell = row.getCell(colIndex);
                cell.setCellValue(mergedValue);
            }
        }
    }

    private List<Map<String, Attribute>> parseHorizontalTable(Element tableElement, Sheet sheet, int startRow) {
        Optional<Integer> tableRowNum = this.foundTableNameRowNum(sheet, tableElement);
        if (!tableRowNum.isPresent()) {
            return new ArrayList<Map<String, Attribute>>();
        }
        int index = startRow + tableRowNum.get();
        HashMap<String, Attribute> dataMap = new HashMap<String, Attribute>();
        boolean colNum = true;
        for (Element attributeElement : XmlUtils.getChildren(tableElement, "attribute")) {
            String attributeKey = attributeElement.getAttribute("key");
            int relativeRowNum = Integer.parseInt(attributeElement.getAttribute("relativeRowNum"));
            int rowNum = index + relativeRowNum;
            boolean permitEmpty = Boolean.parseBoolean(attributeElement.getAttribute("permitEmpty"));
            String checkRepeat = attributeElement.getAttribute("checkRepeat");
            String value = this.getStringCellValue(sheet, rowNum, 1);
            dataMap.put(attributeKey, new Attribute(new Attribute.Location(sheet.getSheetName(), rowNum + 1, 2), value, this.parseVerifiers(attributeElement), permitEmpty, checkRepeat));
        }
        return Lists.newArrayList((Object[])new Map[]{dataMap});
    }

    private List<Map<String, Attribute>> parseVerticalTable(Element tableElement, Sheet sheet, int startRow) {
        return this.parseVerticalTable(tableElement, sheet, startRow, 1);
    }

    private List<Map<String, Attribute>> parseVerticalTable(Element tableElement, Sheet sheet, int startRow, int rowAddNum) {
        ArrayList<Map<String, Attribute>> datas = new ArrayList<Map<String, Attribute>>();
        Optional<Integer> tableRowNum = this.foundTableNameRowNum(sheet, tableElement);
        if (!tableRowNum.isPresent()) {
            return datas;
        }
        int rowNum = startRow + tableRowNum.get() + 1;
        while (!this.isBlankRow(sheet, rowNum)) {
            HashMap<String, Attribute> dataMap = new HashMap<String, Attribute>();
            for (Element attributeElement : XmlUtils.getChildren(tableElement, "attribute")) {
                String attributeKey = attributeElement.getAttribute("key");
                int colNum = Integer.parseInt(attributeElement.getAttribute("colNum")) - 1;
                String checkRepeat = attributeElement.getAttribute("checkRepeat");
                boolean permitEmpty = Boolean.parseBoolean(attributeElement.getAttribute("permitEmpty"));
                String value = this.getStringCellValue(sheet, rowNum, colNum);
                dataMap.put(attributeKey, new Attribute(new Attribute.Location(sheet.getSheetName(), rowNum + 1, colNum + 1), value, this.parseVerifiers(attributeElement), permitEmpty, checkRepeat));
            }
            datas.add(dataMap);
            rowNum += rowAddNum;
        }
        return datas;
    }

    private List<Verifier> parseVerifiers(Element attributeElement) {
        ArrayList<Verifier> verifiers = new ArrayList<Verifier>();
        for (Element verifierElement : XmlUtils.getChildren(attributeElement, "verify")) {
            String type = verifierElement.getAttribute("type");
            String params = verifierElement.getAttribute("params");
            String pre = verifierElement.getAttribute("pre");
            String supportScenes = verifierElement.getAttribute("supportScenes");
            String linkParam = verifierElement.getAttribute("linkParam");
            try {
                if (!this.involving(supportScenes)) continue;
                verifiers.add(this.parseVerifier(type, params, pre, linkParam));
            }
            catch (Exception e) {
                LOGGER.error("parse Verifier failed", (Throwable)e);
                this.addErrMsg(ResourceUtil.getString((String)"importFile.parse.verifier.failed"));
            }
        }
        return verifiers;
    }

    private Verifier parseVerifier(String type, String params, String pre, String linkParam) throws ClassNotFoundException, InstantiationException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        Class<?> clazz = Class.forName("com.huawei.ism.tool.distributeddeploy.logic.importfile.verify.verifier." + type);
        Verifier verifier = StringUtils.isNULLStr((String)params) ? (Verifier)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]) : (Verifier)clazz.getDeclaredConstructor(String.class).newInstance(params);
        verifier.setPreCondition(pre);
        verifier.setLinkParamsKey(linkParam);
        return verifier;
    }

    private boolean involving(String supportScenes) throws ToolException {
        ArrayList<Card.CardScene> sceneList = new ArrayList<Card.CardScene>();
        if (StringUtils.isNULLStr((String)supportScenes)) {
            sceneList.add(Card.CardScene.MAIN);
        } else {
            sceneList.addAll(this.parseSupportScenes(supportScenes));
        }
        if (ObserverManager.getInstance().isDeployHelperServerScene()) {
            return sceneList.stream().anyMatch(cardScene -> cardScene.getKey().equals(ObserverManager.getInstance().getCurrentScene()));
        }
        return sceneList.contains((Object)Context.INS.getCurrentScene());
    }

    private List<Card.CardScene> parseSupportScenes(String supportScenes) throws ToolException {
        String[] scenes;
        ArrayList<Card.CardScene> sceneList = new ArrayList<Card.CardScene>();
        for (String scene : scenes = supportScenes.split(SCENE_SPLIT)) {
            sceneList.add(this.getCardScene(scene));
        }
        return sceneList;
    }

    private Card.CardScene getCardScene(String supportScenes) throws ToolException {
        Optional<Card.CardScene> cardScene = Card.CardScene.mappingEnumNoDefault(supportScenes);
        if (cardScene.isPresent()) {
            return cardScene.get();
        }
        throw new ToolException(ResourceUtil.getString((String)"importFile.parse.verifier.failed"));
    }

    private Optional<Integer> foundTableNameRowNum(Sheet sheet, Element tableElement) {
        if (!tableElement.hasAttribute(LAN_KEY)) {
            int noTableNameIndex = -1;
            return Optional.of(-1);
        }
        String tableName = tableElement.getAttribute(LAN_KEY);
        List<String> compatibleTableNames = Arrays.asList(tableName.split(TABLE_NAME_SPLIT));
        String notFoundTableName = tableName.replace(TABLE_NAME_SPLIT, COMPATIBLE_MSG);
        int blankRowNum = 0;
        int continueFoundMaxBlankNum = 20;
        int rowNum = 0;
        while (true) {
            if (blankRowNum > 20) {
                LOGGER.info("not found {} table.", (Object)notFoundTableName);
                this.addErrMsg(ResourceUtil.getStringWithParams((String)"importFile.found.table.failed", (Object[])new Object[]{notFoundTableName}));
                return Optional.empty();
            }
            if (this.isBlankRow(sheet, rowNum)) {
                ++blankRowNum;
            } else {
                if (compatibleTableNames.contains(this.getStringCellValue(sheet, rowNum, 0))) {
                    return Optional.of(rowNum);
                }
                blankRowNum = 0;
            }
            ++rowNum;
        }
    }

    private boolean isBlankRow(Sheet sheet, int rowNum) {
        return this.getStringCellValue(sheet, rowNum, 0).isEmpty();
    }

    private String getStringCellValue(Sheet sheet, int rowNum, int colNum) {
        Optional<Cell> cell = Optional.ofNullable(sheet).map(sheetItem -> sheetItem.getRow(rowNum)).map(row -> row.getCell(colNum));
        if (!cell.isPresent()) {
            return "";
        }
        switch (cell.get().getCellType()) {
            case STRING: {
                return cell.map(Cell::getStringCellValue).map(String::trim).orElse("");
            }
            case NUMERIC: {
                if (this.containsNonzeroDecimal(cell.get().getNumericCellValue())) {
                    return cell.map(Cell::getNumericCellValue).map(String::valueOf).orElse("");
                }
                return cell.map(cell1 -> (int)cell1.getNumericCellValue()).map(String::valueOf).orElse("");
            }
            case BOOLEAN: {
                return cell.map(Cell::getBooleanCellValue).map(String::valueOf).orElse("");
            }
            case BLANK: {
                return "";
            }
        }
        this.addErrMsgWithPosition(sheet.getSheetName(), rowNum + 1, colNum + 1, ResourceUtil.getString((String)"importFile.data.dataWrongFormat"));
        return "";
    }

    private boolean containsNonzeroDecimal(Double num) {
        return num % 1.0 != 0.0;
    }
}

