/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.distributeddeploy.logic.importfile.entity;

import com.huawei.ism.tool.distributeddeploy.logic.importfile.entity.NetworkingMode;
import com.huawei.ism.tool.distributeddeploy.logic.importfile.entity.Plane;
import com.huawei.ism.tool.distributeddeploy.logic.importfile.entity.TransportProtocol;
import java.util.EnumMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class NetworkPlan {
    private static final Map<Plane, Integer> MAX_IP_NUM = new EnumMap<Plane, Integer>(Plane.class);
    private TransportProtocol transportProtocol;
    private NetworkingMode networkingMode;
    private boolean multiIp = false;

    public NetworkPlan(TransportProtocol transportProtocol, NetworkingMode networkingMode) {
        this.transportProtocol = transportProtocol;
        this.networkingMode = networkingMode;
    }

    public static Integer getMaxIpNum(Plane plane) {
        return MAX_IP_NUM.getOrDefault((Object)plane, 4);
    }

    public String toString() {
        return String.join((CharSequence)" ", Optional.ofNullable(this.transportProtocol).map(Objects::toString).orElse("NullTransportProtocol"), Optional.ofNullable(this.networkingMode).map(Objects::toString).orElse("NullNetworkingMode"));
    }

    public void setTransportProtocol(TransportProtocol transportProtocol) {
        this.transportProtocol = transportProtocol;
    }

    public void setNetworkingMode(NetworkingMode networkingMode) {
        this.networkingMode = networkingMode;
    }

    public void setMultiIp(boolean multiIp) {
        this.multiIp = multiIp;
    }

    public TransportProtocol getTransportProtocol() {
        return this.transportProtocol;
    }

    public NetworkingMode getNetworkingMode() {
        return this.networkingMode;
    }

    public boolean isMultiIp() {
        return this.multiIp;
    }

    public NetworkPlan() {
    }

    static {
        MAX_IP_NUM.put(Plane.COPY_NET, 2);
    }
}

