/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.distributeddeploy.logic.importfile.entity.osnetwork;

import com.huawei.ism.tool.distributeddeploy.logic.importfile.entity.osnetwork.OsIpAddress;
import com.huawei.ism.tool.distributeddeploy.logic.importfile.entity.osnetwork.base.ConfigStrategy;
import com.huawei.ism.tool.distributeddeploy.logic.importfile.entity.osnetwork.base.PhysicalPort;
import com.huawei.ism.tool.distributeddeploy.logic.importfile.entity.osnetwork.base.Vlan;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class PhysicalToVlanConfigStrategy
extends ConfigStrategy {
    private PhysicalPort physicalPort;
    private Vlan vlan;

    public PhysicalToVlanConfigStrategy(OsIpAddress ipAddress, PhysicalPort physicalPort, Vlan vlan) {
        super(ipAddress);
        this.physicalPort = physicalPort;
        this.vlan = vlan;
    }

    @Override
    public String getStrategyPortName() {
        return this.vlan.getVlanName();
    }

    @Override
    public String toString() {
        return String.join((CharSequence)" ", Optional.ofNullable(this.physicalPort).map(Objects::toString).orElse("NullPhysicalPort"), Optional.ofNullable(this.vlan).map(Objects::toString).orElse("NullVlan"), super.toString());
    }

    @Override
    public Map<String, HashSet<String>> getSlotToPortsRelation() {
        return this.getPhysicalSlotToPortsRelation(this.physicalPort);
    }

    public PhysicalPort getPhysicalPort() {
        return this.physicalPort;
    }

    public Vlan getVlan() {
        return this.vlan;
    }
}

