/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.distributeddeploy.logic.importfile.entity.osnetwork.base;

import com.huawei.ism.tool.distributeddeploy.entity.IpAddress;
import com.huawei.ism.tool.distributeddeploy.logic.importfile.entity.Plane;
import com.huawei.ism.tool.distributeddeploy.logic.importfile.entity.TransportProtocol;
import com.huawei.ism.tool.distributeddeploy.logic.importfile.entity.osnetwork.OsIpAddress;
import com.huawei.ism.tool.distributeddeploy.logic.importfile.entity.osnetwork.base.BondPort;
import com.huawei.ism.tool.distributeddeploy.logic.importfile.entity.osnetwork.base.PhysicalPort;
import com.huawei.ism.tool.distributeddeploy.logic.importfile.entity.osnetwork.route.ConfigStrategyRouteCollection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ConfigStrategy {
    private static final Logger log = LoggerFactory.getLogger(ConfigStrategy.class);
    private TransportProtocol transportProtocol;
    private OsIpAddress ipv4Address;
    private OsIpAddress ipv6Address;
    private OsIpAddress ctrlIpAddress;
    private final ConfigStrategyRouteCollection routeCollection;
    private Plane plane;
    private boolean equivalentToStoragePlane = false;

    public ConfigStrategy(OsIpAddress ipAddress) {
        this.setIpAddress(ipAddress);
        this.routeCollection = new ConfigStrategyRouteCollection();
    }

    public void setPlane(Plane plane) {
        this.plane = plane;
        Stream.of(this.ipv4Address, this.ipv6Address, this.ctrlIpAddress).filter(Objects::nonNull).forEach(address -> address.setPlane(plane));
    }

    public void setOpenDefaultRoute(boolean openDefaultRoute) {
        Stream.of(this.ipv4Address, this.ipv6Address).filter(Objects::nonNull).forEach(address -> address.setOpenDefaultRoute(openDefaultRoute));
    }

    public void setIpAddress(OsIpAddress ipAddress) {
        ipAddress.setPlane(this.plane);
        if (IpAddress.IpPattern.IPV4.equals((Object)ipAddress.getIpPattern())) {
            this.ipv4Address = ipAddress;
        } else if (IpAddress.IpPattern.IPV6.equals((Object)ipAddress.getIpPattern())) {
            this.ipv6Address = ipAddress;
        } else {
            log.warn("Unknown ip address {}", (Object)ipAddress);
        }
    }

    public boolean containsIpv4() {
        return this.ipv4Address != null;
    }

    public boolean containsIpv6() {
        return this.ipv6Address != null;
    }

    public abstract String getStrategyPortName();

    public String toString() {
        return String.join((CharSequence)" ", Optional.ofNullable(this.plane).map(Objects::toString).orElse("NullPlane"), Optional.ofNullable(this.ipv4Address).map(Objects::toString).orElse("NullIpv4Address"), Optional.ofNullable(this.ipv6Address).map(Objects::toString).orElse("NullIpv6Address"), Optional.ofNullable(this.ctrlIpAddress).map(Objects::toString).orElse("NullCtrlIpAddress"), Optional.ofNullable(this.routeCollection).map(Objects::toString).orElse("NullConfigStrategyRoute"));
    }

    public abstract Map<String, HashSet<String>> getSlotToPortsRelation();

    protected Map<String, HashSet<String>> getBondSlotToPortsRelation(BondPort bondPort) {
        Map<String, List<PhysicalPort>> slotToPhysicalPort = bondPort.getPhysicalPorts().stream().collect(Collectors.groupingBy(PhysicalPort::getSlot));
        HashMap<String, HashSet<String>> slotToPorts = new HashMap<String, HashSet<String>>();
        slotToPhysicalPort.keySet().forEach(slot -> this.addToSlotToPorts(slotToPhysicalPort, (Map<String, HashSet<String>>)slotToPorts, (String)slot));
        return slotToPorts;
    }

    private void addToSlotToPorts(Map<String, List<PhysicalPort>> slotToPhysicalPort, Map<String, HashSet<String>> slotToPorts, String slot) {
        List<PhysicalPort> physicalPorts = slotToPhysicalPort.get(slot);
        if (Objects.isNull(slotToPorts.get(slot))) {
            slotToPorts.put(slot, new HashSet());
        }
        slotToPorts.get(slot).addAll(physicalPorts.stream().map(PhysicalPort::getPort).collect(Collectors.toSet()));
    }

    protected Map<String, HashSet<String>> getPhysicalSlotToPortsRelation(PhysicalPort physicalPort) {
        HashMap<String, HashSet<String>> slotToPorts = new HashMap<String, HashSet<String>>();
        HashSet<String> ports = new HashSet<String>();
        ports.add(physicalPort.getPort());
        slotToPorts.put(physicalPort.getSlot(), ports);
        return slotToPorts;
    }

    public void setTransportProtocol(TransportProtocol transportProtocol) {
        this.transportProtocol = transportProtocol;
    }

    public TransportProtocol getTransportProtocol() {
        return this.transportProtocol;
    }

    public OsIpAddress getIpv4Address() {
        return this.ipv4Address;
    }

    public OsIpAddress getIpv6Address() {
        return this.ipv6Address;
    }

    public OsIpAddress getCtrlIpAddress() {
        return this.ctrlIpAddress;
    }

    public void setCtrlIpAddress(OsIpAddress ctrlIpAddress) {
        this.ctrlIpAddress = ctrlIpAddress;
    }

    public ConfigStrategyRouteCollection getRouteCollection() {
        return this.routeCollection;
    }

    public Plane getPlane() {
        return this.plane;
    }

    public boolean isEquivalentToStoragePlane() {
        return this.equivalentToStoragePlane;
    }

    public void setEquivalentToStoragePlane(boolean equivalentToStoragePlane) {
        this.equivalentToStoragePlane = equivalentToStoragePlane;
    }
}

