/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.distributeddeploy.logic.importfile.entity.osnetwork.route;

import com.huawei.ism.tool.distributeddeploy.entity.IpAddress;
import com.huawei.ism.tool.distributeddeploy.logic.importfile.entity.osnetwork.route.IPolicyRoute;
import com.huawei.ism.tool.distributeddeploy.logic.importfile.entity.osnetwork.route.IRoute;
import com.huawei.ism.tool.obase.exception.ToolException;
import com.huawei.ism.tool.obase.net.dhcp.utils.ToolNetUtil;
import java.util.Locale;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractSourceIpPolicyRoute
implements IPolicyRoute {
    private static final Logger log = LoggerFactory.getLogger(AbstractSourceIpPolicyRoute.class);
    @NonNull
    protected String sourceIp;
    @NonNull
    private final IpAddress ipAddress;

    @Override
    public String getConfigRuleInfo(@NonNull IRoute.RouteDynamicAttribute attribute) {
        if (attribute == null) {
            throw new NullPointerException("attribute is marked non-null but is null");
        }
        return "from " + this.sourceIp + " table " + attribute.getPortName();
    }

    @NotNull
    protected String getSameNetworkSegment(IRoute.RouteDynamicAttribute attribute) {
        String subnetAddress = this.calcSubnetAddress();
        if (StringUtils.isBlank((CharSequence)subnetAddress)) {
            return "";
        }
        return String.format(Locale.ENGLISH, "%s dev %s table %s", subnetAddress, attribute.getPortName(), attribute.getRouteTableName());
    }

    private String calcSubnetAddress() {
        if (this.isIpv4Route()) {
            return String.format(Locale.ENGLISH, "%s/%s", ToolNetUtil.calcSubnetAddress((String)this.sourceIp, (String)this.ipAddress.getNetMaskOrPrefix()), this.getPrefix());
        }
        if (this.isIpv6Route()) {
            try {
                return ToolNetUtil.calcIpv6SubnetAddress((String)String.format(Locale.ENGLISH, "%s/%s", this.ipAddress.getIp(), this.ipAddress.getNetMaskOrPrefix()));
            }
            catch (ToolException toolException) {
                log.error("ip format error", (Throwable)toolException);
            }
        } else {
            log.info("not cal subnet for sourceIp :{} , ip :{}", (Object)this.sourceIp, (Object)this.ipAddress.getIp());
        }
        return "";
    }

    protected String getPrefix() {
        if (IpAddress.IpPattern.IPV4.equals((Object)this.ipAddress.getIpPattern())) {
            return String.valueOf(ToolNetUtil.transMaskToPrefixLength((String)this.ipAddress.getNetMaskOrPrefix()));
        }
        return this.ipAddress.getNetMaskOrPrefix();
    }

    private boolean isIpv6Route() {
        return IpAddress.IpPattern.IPV6.equals((Object)this.ipAddress.getIpPattern()) && this.sourceIp.equals(this.ipAddress.getIp());
    }

    private boolean isIpv4Route() {
        return IpAddress.IpPattern.IPV4.equals((Object)this.ipAddress.getIpPattern()) && this.sourceIp.equals(this.ipAddress.getIp());
    }

    public AbstractSourceIpPolicyRoute(@NonNull String sourceIp, @NonNull IpAddress ipAddress) {
        if (sourceIp == null) {
            throw new NullPointerException("sourceIp is marked non-null but is null");
        }
        if (ipAddress == null) {
            throw new NullPointerException("ipAddress is marked non-null but is null");
        }
        this.sourceIp = sourceIp;
        this.ipAddress = ipAddress;
    }
}

