/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.distributeddeploy.logic.importfile.entity.osnetwork.route;

import com.huawei.ism.tool.distributeddeploy.logic.importfile.entity.osnetwork.route.IPolicyRoute;
import com.huawei.ism.tool.distributeddeploy.logic.importfile.entity.osnetwork.route.IRoute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class ConfigStrategyRouteCollection {
    private final List<IRoute> ipv4StaticRoutes = new ArrayList<IRoute>();
    private final List<IRoute> ipv6StaticRoutes = new ArrayList<IRoute>();
    private final List<IPolicyRoute> ipv4PolicyRoutes = new ArrayList<IPolicyRoute>();
    private final List<IPolicyRoute> ipv6PolicyRoutes = new ArrayList<IPolicyRoute>();

    public String getIpv4RouteInfo(String portName, String tableName, String tablePriorityNumber) {
        return Stream.of(this.ipv4StaticRoutes, this.ipv4PolicyRoutes).flatMap(Collection::stream).map(route -> route.getConfigRouteInfo(IRoute.RouteDynamicAttribute.builder().portName(portName).routeTableName(tableName).routeTablePriorityNumber(tablePriorityNumber).build())).collect(Collectors.joining("\n")).trim();
    }

    public String getIpv6RouteInfo(String portName, String tableName, String tablePriorityNumber) {
        return Stream.of(this.ipv6StaticRoutes, this.ipv6PolicyRoutes).flatMap(Collection::stream).map(route -> route.getConfigRouteInfo(IRoute.RouteDynamicAttribute.builder().portName(portName).routeTableName(tableName).routeTablePriorityNumber(tablePriorityNumber).build())).collect(Collectors.joining("\n")).trim();
    }

    public String getIpv4RuleInfo(String portName) {
        return this.ipv4PolicyRoutes.stream().map(route -> route.getConfigRuleInfo(IRoute.RouteDynamicAttribute.builder().portName(portName).build())).collect(Collectors.joining("\n")).trim();
    }

    public String getIpv6RuleInfo(String portName) {
        return this.ipv6PolicyRoutes.stream().map(route -> route.getConfigRuleInfo(IRoute.RouteDynamicAttribute.builder().portName(portName).build())).collect(Collectors.joining("\n")).trim();
    }

    public String getDeviceManagerStaticRouteInfo(String portName) {
        return Stream.of(this.ipv4StaticRoutes, this.ipv6StaticRoutes).flatMap(Collection::stream).map(staticRoute -> staticRoute.getDeviceManagerReadRouteInfo(IRoute.RouteDynamicAttribute.builder().portName(portName).build())).collect(Collectors.joining("\n")).trim();
    }

    public String getDeviceManagerPolicyRouteInfo(String portName, String tableName, String tablePriorityNumber) {
        return Stream.of(this.ipv4PolicyRoutes, this.ipv6PolicyRoutes).flatMap(Collection::stream).map(policyRoute -> policyRoute.getDeviceManagerReadRouteInfo(IRoute.RouteDynamicAttribute.builder().portName(portName).routeTableName(tableName).routeTablePriorityNumber(tablePriorityNumber).build())).collect(Collectors.joining("\n")).trim();
    }

    public boolean containsPolicyRoute() {
        return !this.ipv4PolicyRoutes.isEmpty() || !this.ipv6PolicyRoutes.isEmpty();
    }

    public List<IRoute> getIpv4StaticRoutes() {
        return this.ipv4StaticRoutes;
    }

    public List<IRoute> getIpv6StaticRoutes() {
        return this.ipv6StaticRoutes;
    }

    public List<IPolicyRoute> getIpv4PolicyRoutes() {
        return this.ipv4PolicyRoutes;
    }

    public List<IPolicyRoute> getIpv6PolicyRoutes() {
        return this.ipv6PolicyRoutes;
    }

    public String toString() {
        return "ConfigStrategyRouteCollection(ipv4StaticRoutes=" + this.getIpv4StaticRoutes() + ", ipv6StaticRoutes=" + this.getIpv6StaticRoutes() + ", ipv4PolicyRoutes=" + this.getIpv4PolicyRoutes() + ", ipv6PolicyRoutes=" + this.getIpv6PolicyRoutes() + ")";
    }
}

