/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.distributeddeploy.logic.importfile.entity.osnetwork.route;

import com.huawei.ism.tool.distributeddeploy.entity.IpAddress;
import com.huawei.ism.tool.distributeddeploy.logic.importfile.entity.osnetwork.route.AbstractSourceIpPolicyRoute;
import com.huawei.ism.tool.distributeddeploy.logic.importfile.entity.osnetwork.route.IRoute;
import java.util.Locale;
import lombok.NonNull;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CrossNetworkSegmentSourceIpPolicyRoute
extends AbstractSourceIpPolicyRoute {
    private static final Logger log = LoggerFactory.getLogger(CrossNetworkSegmentSourceIpPolicyRoute.class);
    @NonNull
    private final String gateWay;

    public CrossNetworkSegmentSourceIpPolicyRoute(@NonNull IpAddress ipAddress, @NonNull String sourceIp, @NonNull String gateWay) {
        super(sourceIp, ipAddress);
        if (ipAddress == null) {
            throw new NullPointerException("ipAddress is marked non-null but is null");
        }
        if (sourceIp == null) {
            throw new NullPointerException("sourceIp is marked non-null but is null");
        }
        if (gateWay == null) {
            throw new NullPointerException("gateWay is marked non-null but is null");
        }
        this.gateWay = gateWay;
    }

    @Override
    public String getConfigRouteInfo(@NonNull IRoute.RouteDynamicAttribute attribute) {
        if (attribute == null) {
            throw new NullPointerException("attribute is marked non-null but is null");
        }
        return String.format(Locale.ENGLISH, "%s%n%s", this.getCrossNetworkSegment(attribute), this.getSameNetworkSegment(attribute));
    }

    @NotNull
    private String getCrossNetworkSegment(@NotNull IRoute.RouteDynamicAttribute attribute) {
        return String.format(Locale.ENGLISH, "default via %s dev %s table %s", this.gateWay, attribute.getPortName(), attribute.getRouteTableName());
    }

    @Override
    public String getDeviceManagerReadRouteInfo(@NonNull IRoute.RouteDynamicAttribute attribute) {
        if (attribute == null) {
            throw new NullPointerException("attribute is marked non-null but is null");
        }
        return String.join((CharSequence)" ", attribute.getRouteTablePriorityNumber(), attribute.getRouteTableName(), attribute.getPortName(), this.sourceIp, this.getPrefix(), this.gateWay);
    }

    @NonNull
    public String getGateWay() {
        return this.gateWay;
    }

    public String toString() {
        return "CrossNetworkSegmentSourceIpPolicyRoute(gateWay=" + this.getGateWay() + ")";
    }
}

