/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.distributeddeploy.logic.importfile.entity.osnetwork.route;

import com.huawei.ism.tool.base.utils.StringUtils;
import com.huawei.ism.tool.distributeddeploy.entity.IpAddress;
import com.huawei.ism.tool.distributeddeploy.logic.importfile.entity.osnetwork.route.AbstractSourceIpPolicyRoute;
import com.huawei.ism.tool.distributeddeploy.logic.importfile.entity.osnetwork.route.IRoute;
import java.util.Locale;
import lombok.NonNull;

public class SameNetworkSegmentSourceIpPolicyRoute
extends AbstractSourceIpPolicyRoute {
    public SameNetworkSegmentSourceIpPolicyRoute(@NonNull String sourceIp, IpAddress ipAddress) {
        super(sourceIp, ipAddress);
        if (sourceIp == null) {
            throw new NullPointerException("sourceIp is marked non-null but is null");
        }
    }

    @Override
    public String getConfigRouteInfo(@NonNull IRoute.RouteDynamicAttribute attribute) {
        if (attribute == null) {
            throw new NullPointerException("attribute is marked non-null but is null");
        }
        String sameNetworkSegment = this.getSameNetworkSegment(attribute);
        if (!StringUtils.isNULLStr(sameNetworkSegment)) {
            return sameNetworkSegment;
        }
        String routeInfo = StringUtils.isValidIPV6(this.sourceIp) ? "0::0/0 dev %s table %s" : "0.0.0.0/0 dev %s table %s";
        return String.format(Locale.ENGLISH, routeInfo, attribute.getPortName(), attribute.getRouteTableName());
    }

    @Override
    public String getDeviceManagerReadRouteInfo(@NonNull IRoute.RouteDynamicAttribute attribute) {
        if (attribute == null) {
            throw new NullPointerException("attribute is marked non-null but is null");
        }
        return String.join((CharSequence)" ", attribute.getRouteTablePriorityNumber(), attribute.getRouteTableName(), attribute.getPortName(), this.sourceIp, this.getPrefix());
    }

    public String toString() {
        return "SameNetworkSegmentSourceIpPolicyRoute()";
    }
}

