/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.distributeddeploy.logic.importfile.entity.osnetwork.route;

import com.huawei.ism.tool.distributeddeploy.logic.importfile.entity.osnetwork.route.IRoute;
import java.util.Locale;
import lombok.NonNull;

public class StaticRoute
implements IRoute {
    private final String targetIp;
    private final String prefix;
    private final String gateWay;

    @Override
    public String getConfigRouteInfo(@NonNull IRoute.RouteDynamicAttribute attribute) {
        if (attribute == null) {
            throw new NullPointerException("attribute is marked non-null but is null");
        }
        return String.format(Locale.ENGLISH, "%s/%s via %s", this.targetIp, this.prefix, this.gateWay);
    }

    @Override
    public String getDeviceManagerReadRouteInfo(@NonNull IRoute.RouteDynamicAttribute attribute) {
        if (attribute == null) {
            throw new NullPointerException("attribute is marked non-null but is null");
        }
        return String.join((CharSequence)" ", this.targetIp, this.prefix, this.gateWay, attribute.getPortName());
    }

    public StaticRoute(String targetIp, String prefix, String gateWay) {
        this.targetIp = targetIp;
        this.prefix = prefix;
        this.gateWay = gateWay;
    }

    public String getTargetIp() {
        return this.targetIp;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public String getGateWay() {
        return this.gateWay;
    }

    public String toString() {
        return "StaticRoute(targetIp=" + this.getTargetIp() + ", prefix=" + this.getPrefix() + ", gateWay=" + this.getGateWay() + ")";
    }
}

