/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.distributeddeploy.logic.importfile.impl;

import com.huawei.ism.tool.distributeddeploy.logic.importfile.entity.Attribute;
import com.huawei.ism.tool.distributeddeploy.logic.importfile.exception.ImportFileException;
import com.huawei.ism.tool.distributeddeploy.logic.utils.ExcelUtil;
import com.huawei.ism.tool.obase.exception.ToolException;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import java.util.ArrayList;
import java.util.List;

public abstract class Task<T> {
    private List<ArrayList<Object>> errDatas = new ArrayList<ArrayList<Object>>();

    public T run() throws ImportFileException, ToolException {
        T result = this.doTask();
        this.dealErrPromptMsg();
        return result;
    }

    protected abstract T doTask() throws ToolException;

    protected void addErrMsgWithPosition(Attribute attribute, String errMsg) {
        this.addErrMsgWithPosition(attribute.getSheetName(), attribute.getRowNum(), attribute.getColNum(), errMsg);
    }

    protected void addErrMsgWithPosition(String sheetName, int row, int col, String errMsg) {
        ArrayList<String> data = new ArrayList<String>();
        data.add(ResourceUtil.getStringWithParams((String)"importFile.position", (Object[])new Object[]{sheetName, row, col, ExcelUtil.columnNumToCharacter(col)}));
        data.add(errMsg);
        this.errDatas.add(data);
    }

    protected void addErrMsg(String errMsg) {
        ArrayList<String> data = new ArrayList<String>();
        data.add("NA");
        data.add(errMsg);
        this.errDatas.add(data);
    }

    private void dealErrPromptMsg() throws ImportFileException {
        if (!this.errDatas.isEmpty()) {
            throw new ImportFileException(this.errDatas);
        }
    }

    public boolean haveError() {
        return !this.errDatas.isEmpty();
    }
}

