/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.distributeddeploy.logic.importfile.strategy;

import com.huawei.ism.tool.distributeddeploy.common.ToolConfig;
import com.huawei.ism.tool.distributeddeploy.logic.importfile.entity.Attribute;
import com.huawei.ism.tool.distributeddeploy.logic.importfile.entity.ClusterInfo;
import com.huawei.ism.tool.distributeddeploy.logic.importfile.entity.NetworkPlan;
import com.huawei.ism.tool.distributeddeploy.logic.importfile.entity.NetworkingMode;
import com.huawei.ism.tool.distributeddeploy.logic.importfile.entity.Plane;
import com.huawei.ism.tool.distributeddeploy.logic.importfile.entity.TransportProtocol;
import com.huawei.ism.tool.distributeddeploy.logic.importfile.entity.VlanPlan;
import com.huawei.ism.tool.distributeddeploy.logic.importfile.entity.osnetwork.base.BondPort;
import com.huawei.ism.tool.distributeddeploy.logic.importfile.entity.osnetwork.base.PhysicalPort;
import com.huawei.ism.tool.distributeddeploy.logic.importfile.entity.osnetwork.base.Vlan;
import com.huawei.ism.tool.distributeddeploy.logic.importfile.strategy.StrategyTask;
import com.huawei.ism.tool.obase.log.ToolLoggerFactory;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.slf4j.Logger;

public class ClusterInfoStrategyTask
extends StrategyTask<ClusterInfo> {
    private static final Logger LOGGER = ToolLoggerFactory.getLogger(ClusterInfoStrategyTask.class);
    private static final String YES = "Y";
    private static final int VLAN_NAME_MAX_LEN = 13;
    private Set<String> parsedBondNames;
    private Set<PhysicalPort> parsedPhysicalPort;
    private ClusterInfo clusterInfo;
    private Map<String, Attribute> clusterInfoData;
    private Map<String, Attribute> networkPlanData;
    private List<Map<String, Attribute>> bondPlanData;
    private List<Map<String, Attribute>> vlanPlanData;
    private Set<String> usedVlanName;

    public ClusterInfoStrategyTask(Map<String, Attribute> clusterInfoData, Map<String, Attribute> networkPlanData, List<Map<String, Attribute>> bondPlanData, List<Map<String, Attribute>> vlanPlanData) {
        this.clusterInfoData = clusterInfoData;
        this.networkPlanData = networkPlanData;
        this.bondPlanData = bondPlanData;
        this.vlanPlanData = vlanPlanData;
    }

    @Override
    protected ClusterInfo doTask() {
        this.initData();
        this.parseClusterName();
        this.parseClusterPlan();
        this.parseNetworkPlans();
        this.parseBondPlans();
        this.parseVlanPlans();
        LOGGER.info("clusterInfo: {}", (Object)this.clusterInfo);
        return this.clusterInfo;
    }

    private void initData() {
        this.parsedBondNames = new HashSet<String>();
        this.parsedPhysicalPort = new HashSet<PhysicalPort>();
        this.clusterInfo = new ClusterInfo();
        this.usedVlanName = new HashSet<String>();
    }

    private void parseNetworkPlans() {
        Attribute frontTp = this.networkPlanData.get("frontTransportProtocol");
        Attribute frontMD = this.networkPlanData.get("frontNetworkingMode");
        Attribute frontIsMultiIp = this.networkPlanData.get("frontUseMultiIp");
        Attribute backTp = this.networkPlanData.get("backTransportProtocol");
        Attribute backMD = this.networkPlanData.get("backNetworkingMode");
        Attribute backIsMultiIp = this.networkPlanData.get("backUseMultiIp");
        this.dealFrontBackIsolation();
        NetworkPlan frontNetworkPlan = this.parseNetworkPlan(frontTp, frontMD, frontIsMultiIp);
        this.clusterInfo.addNetworkPlan(Plane.STORAGE_FRONT, frontNetworkPlan);
        if (this.clusterInfo.isFrontBackIsolated()) {
            NetworkPlan backNetworkPlan = this.parseNetworkPlan(backTp, backMD, backIsMultiIp);
            this.clusterInfo.addNetworkPlan(Plane.STORAGE_BACK, backNetworkPlan);
        }
    }

    private void dealFrontBackIsolation() {
        Attribute frontBackIsolated = this.networkPlanData.get("frontBackIsolated");
        this.clusterInfo.setFrontBackIsolated(YES.equals(frontBackIsolated.getValue()));
    }

    private void parseClusterName() {
        this.clusterInfo.setClusterName(this.clusterInfoData.get("clusterName").getValue());
        this.clusterInfo.setClusterIp(this.clusterInfoData.get("clusterIp").getValue());
    }

    private void parseClusterPlan() {
        this.clusterInfo.setFsmOmInExIsolated(YES.equals(this.clusterInfoData.get("omInExIsolated").getValue()));
        this.clusterInfo.setFsmOmStorageShared(YES.equals(this.clusterInfoData.get("omStorageShared").getValue()));
    }

    private NetworkPlan parseNetworkPlan(Attribute transportProtocol, Attribute networkingMode, Attribute isMultiIp) {
        NetworkPlan networkPlan = new NetworkPlan();
        Optional<TransportProtocol> optionalTP = TransportProtocol.mappingEnum(transportProtocol.getValue());
        if (optionalTP.isPresent()) {
            networkPlan.setTransportProtocol(optionalTP.get());
        } else {
            this.addErrMsgWithPosition(transportProtocol, ResourceUtil.getString((String)"importFile.strategy.transportProtocolWrong"));
        }
        Optional<NetworkingMode> optionalNetworkingMode = NetworkingMode.mappingEnum(networkingMode.getValue());
        if (optionalNetworkingMode.isPresent()) {
            networkPlan.setNetworkingMode(optionalNetworkingMode.get());
        } else {
            this.addErrMsgWithPosition(networkingMode, ResourceUtil.getString((String)"importFile.strategy.networkingModeWrong"));
        }
        networkPlan.setMultiIp(YES.equals(isMultiIp.getValue()));
        return networkPlan;
    }

    private void parseBondPlans() {
        for (Map<String, Attribute> data : this.bondPlanData) {
            Attribute bondName = data.get("portName");
            Attribute physicalCard = data.get("physicalCard");
            Attribute bondMode = data.get("bondMode");
            Attribute mtu = data.get("mtu");
            Attribute arp = data.get("arp");
            if (!this.verifyUsedBondName(bondName)) continue;
            this.clusterInfo.addBondPlan(bondName.getValue(), BondPort.builder().bondName(bondName.getValue()).physicalPorts(this.parsePhysicalNetworkCard(physicalCard)).bondPattern(BondPort.BondPattern.valueOf(bondMode.getValue().toUpperCase(Locale.ENGLISH))).mtu(mtu.getValue()).arp(YES.equals(arp.getValue())).build());
        }
    }

    private boolean verifyUsedBondName(Attribute bondName) {
        if (this.parsedBondNames.contains(bondName.getValue())) {
            this.addErrMsgWithPosition(bondName, ResourceUtil.getString((String)"importFile.strategy.bondNameUsed"));
            return false;
        }
        this.parsedBondNames.add(bondName.getValue());
        return true;
    }

    private List<PhysicalPort> parsePhysicalNetworkCard(Attribute physicalCard) {
        return Arrays.stream(physicalCard.getValue().split(",")).map(port -> this.parsePhysicalPort(physicalCard, (String)port)).collect(Collectors.toList());
    }

    private void parseVlanPlans() {
        HashMap<String, VlanPlan> vlanPlans = new HashMap<String, VlanPlan>();
        this.clusterInfo.setVlanPlans(vlanPlans);
        for (Map<String, Attribute> data : this.vlanPlanData) {
            Attribute vlanName = data.get("vlanName");
            Attribute vlanId = data.get("vlanId");
            Attribute portType = data.get("portType");
            Attribute portName = data.get("portName");
            this.verifyVlanName(vlanName, vlanId);
            Vlan vlan = new Vlan(vlanName.getValue(), vlanId.getValue());
            if (NetworkingMode.PHYSICAL_PORT.getModeName().equals(portType.getValue())) {
                PhysicalPort physicalPort = this.parsePhysicalPort(portName, portName.getValue());
                vlanPlans.put(vlanName.getValue(), new VlanPlan<PhysicalPort>(vlan, physicalPort));
                continue;
            }
            if (NetworkingMode.BOND_PORT.getModeName().equals(portType.getValue())) {
                vlanPlans.put(vlanName.getValue(), new VlanPlan<BondPort>(vlan, this.foundBondPortFromPortName(portName)));
                continue;
            }
            this.addErrMsgWithPosition(portType, ResourceUtil.getString((String)"importFile.strategy.portTypeWrong"));
        }
    }

    private void verifyVlanName(Attribute vlanName, Attribute vlanId) {
        Pattern vlanNamePattern = Pattern.compile(ToolConfig.getVlanNameVerifyReg() + vlanId.getValue() + "$");
        if (!vlanNamePattern.matcher(vlanName.getValue()).find() || vlanName.getValue().length() > ToolConfig.getVlanNameMaxLen()) {
            this.addErrMsgWithPosition(vlanName, ResourceUtil.getString((String)"importFile.strategy.vlanNameWrong"));
            return;
        }
        if (this.usedVlanName.contains(vlanName.getValue())) {
            this.addErrMsgWithPosition(vlanName, ResourceUtil.getString((String)"importFile.strategy.vlanNameUsed"));
        }
        this.usedVlanName.add(vlanName.getValue());
    }

    private BondPort foundBondPortFromPortName(Attribute portName) {
        if (this.clusterInfo.containsBondPlan(portName.getValue())) {
            return this.clusterInfo.getBondPlan(portName.getValue());
        }
        this.addErrMsgWithPosition(portName, ResourceUtil.getString((String)"importFile.strategy.bondPortNoPlan"));
        return new BondPort();
    }
}

