/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.distributeddeploy.logic.importfile.strategy;

import com.huawei.ism.tool.distributeddeploy.common.Context;
import com.huawei.ism.tool.distributeddeploy.common.ToolConfig;
import com.huawei.ism.tool.distributeddeploy.entity.DeployNode;
import com.huawei.ism.tool.distributeddeploy.entity.IpAddress;
import com.huawei.ism.tool.distributeddeploy.fit.util.ParseLldUtil;
import com.huawei.ism.tool.distributeddeploy.logic.importfile.entity.Attribute;
import com.huawei.ism.tool.distributeddeploy.logic.importfile.strategy.StrategyTask;
import com.huawei.ism.tool.distributeddeploy.logic.importfile.verify.verifier.NonEmptyVerifier;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import com.huawei.ism.tool.obase.utils.StringUtils;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class DevsStrategyTask
extends StrategyTask<List<DeployNode>> {
    private Set<String> deIps;
    private List<Map<String, Attribute>> devDatas;
    private Set<String> devSns;
    private Set<String> devNodeNames;

    public DevsStrategyTask(List<Map<String, Attribute>> devDatas) {
        this.devDatas = devDatas;
    }

    @Override
    protected List<DeployNode> doTask() {
        this.devSns = new HashSet<String>();
        this.devNodeNames = new HashSet<String>();
        this.deIps = new HashSet<String>();
        this.preCheck(this.devDatas);
        return this.devDatas.stream().map(this::parseDev).peek(this::updateNowBmcIp).collect(Collectors.toList());
    }

    private void updateNowBmcIp(DeployNode deployNode) {
        deployNode.setNowBmcIp(ToolConfig.getBmcDefaultIpByType(deployNode.getDevType(), deployNode.getSlotId()));
    }

    protected void preCheck(List<Map<String, Attribute>> devData) {
    }

    protected DeployNode parseDev(Map<String, Attribute> nodeData) {
        DeployNode deployDevNode = new DeployNode(Context.INS.getDeployTaskInitService());
        deployDevNode.setDevType(nodeData.get("devType").getValue());
        deployDevNode.setSn(this.parseSn(nodeData));
        Attribute nodeName = nodeData.get("nodeName");
        this.recordNodeName(nodeName);
        deployDevNode.setNodeName(nodeName.getValue());
        deployDevNode.setUserInfo(nodeData);
        deployDevNode.setIpAddress(this.parseDevIpAddress(nodeData));
        ParseLldUtil.parseAppendFiles(deployDevNode, nodeData);
        return deployDevNode;
    }

    protected String parseSn(Map<String, Attribute> nodeData) {
        Attribute snAttribute = nodeData.get("sn");
        this.recordSn(snAttribute);
        return snAttribute.getValue();
    }

    protected IpAddress parseDevIpAddress(Map<String, Attribute> nodeData) {
        Attribute bmcIp = nodeData.get("bmcIp");
        this.checkHaveIpPattern(nodeData.get("bmcIpPattern"));
        this.recordIp(bmcIp);
        return this.createIpAddress(nodeData.get("bmcIpPattern"), bmcIp, nodeData.get("bmcNetMaskOrPrefix"), nodeData.get("bmcGateway"));
    }

    protected IpAddress parseDevIpAddressDS(Map<String, Attribute> nodeData) {
        Attribute bmcIp = nodeData.get("bmcIpDS");
        this.checkHaveIpPattern(nodeData.get("bmcIpPatternDS"));
        this.recordIp(bmcIp);
        return this.createIpAddress(nodeData.get("bmcIpPatternDS"), bmcIp, nodeData.get("bmcNetMaskOrPrefixDS"), nodeData.get("bmcGatewayDS"));
    }

    protected void recordSn(Attribute sn) {
        if (!StringUtils.isNULLStr((String)sn.getValue())) {
            if (this.devSns.contains(sn.getValue())) {
                this.addErrMsgWithPosition(sn, ResourceUtil.getString((String)"importFile.strategy.snUsed"));
            } else {
                this.devSns.add(sn.getValue());
            }
        }
    }

    protected void recordIp(Attribute ip) {
        if (this.deIps.contains(ip.getValue())) {
            this.addErrMsgWithPosition(ip, ResourceUtil.getString((String)"importFile.strategy.ipUsed"));
        } else {
            this.deIps.add(ip.getValue());
        }
    }

    protected void recordNodeName(Attribute nodeName) {
        if (!StringUtils.isNULLStr((String)nodeName.getValue())) {
            if (this.devNodeNames.contains(nodeName.getValue())) {
                this.addErrMsgWithPosition(nodeName, ResourceUtil.getString((String)"importFile.strategy.nodeNameUsed"));
            } else {
                this.devNodeNames.add(nodeName.getValue());
            }
        }
    }

    public void verifyNewPasswordNotEmptyInOsInstall(List<Map<String, Attribute>> devData) {
        NonEmptyVerifier nonEmptyVerifier = new NonEmptyVerifier();
        devData.forEach(dataMap -> {
            Attribute attributeOs = (Attribute)dataMap.get("osUserNewPassword");
            Attribute attributeRoot = (Attribute)dataMap.get("rootUserNewPassword");
            if (attributeOs != null && !nonEmptyVerifier.verify(attributeOs.getValue())) {
                this.addErrMsgWithPosition(attributeOs, nonEmptyVerifier.show());
            }
            if (attributeRoot != null && !nonEmptyVerifier.verify(attributeRoot.getValue())) {
                this.addErrMsgWithPosition(attributeRoot, nonEmptyVerifier.show());
            }
        });
    }
}

