/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.distributeddeploy.logic.importfile.strategy;

import com.huawei.ism.tool.distributeddeploy.entity.DeployNode;
import com.huawei.ism.tool.distributeddeploy.entity.User;
import com.huawei.ism.tool.distributeddeploy.fit.util.ParseLldUtil;
import com.huawei.ism.tool.distributeddeploy.logic.importfile.entity.Attribute;
import com.huawei.ism.tool.distributeddeploy.logic.importfile.strategy.FullDeploySceneDevsStrategyTask;
import com.huawei.ism.tool.distributeddeploy.logic.task.init.impl.DirectPlaneDeployTaskInitService;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class DirectPlaneNodesStrategyTask
extends FullDeploySceneDevsStrategyTask {
    private List<Map<String, Attribute>> dsInfo;

    public DirectPlaneNodesStrategyTask(List<Map<String, Attribute>> devDatas, List<Map<String, Attribute>> dsData) {
        super(devDatas);
        Set devSn = devDatas.stream().map(ParseLldUtil::buildDataClusterIndex).collect(Collectors.toSet());
        HashSet dsIndex = new HashSet();
        dsData.forEach(data -> this.verifyDsInfo(devSn, (Map<String, Attribute>)data, dsIndex));
        this.dsInfo = dsData;
    }

    @Override
    protected DeployNode parseDev(Map<String, Attribute> nodeData) {
        nodeData.put("devType", new Attribute(new Attribute.Location("", 0, 0), "Data Cluster Module"));
        DeployNode deployDevNode = new DeployNode(new DirectPlaneDeployTaskInitService());
        deployDevNode.setDevType(nodeData.get("devType").getValue());
        deployDevNode.setSn(this.parseSn(nodeData));
        deployDevNode.setBmcUser(new User(nodeData.get("bmcUserName").getValue(), nodeData.get("bmcUserOriginPassword").getValue(), nodeData.get("bmcUserNewPassword").getValue()));
        deployDevNode.setIpAddress(this.parseDevIpAddress(nodeData));
        this.fillDsInfo(nodeData);
        if (nodeData.containsKey("bmcIpPatternDS") && !this.verifyDsIpPatternRepeated(nodeData)) {
            deployDevNode.setIpAddressDS(this.parseDevIpAddressDS(nodeData));
        }
        deployDevNode.setSlotId(nodeData.get("slotId").getValue());
        return deployDevNode;
    }

    private void verifyDsInfo(Set<String> devSn, Map<String, Attribute> oneDsRow, Set<String> dsIndex) {
        String sn = ParseLldUtil.buildDataClusterIndex(oneDsRow);
        if (!devSn.contains(sn)) {
            this.addErrMsgWithPosition(oneDsRow.get("sn"), ResourceUtil.getString((String)"importFile.verify.DS.dataCluster.index.not.match"));
        }
        if (dsIndex.contains(sn)) {
            this.addErrMsgWithPosition(oneDsRow.get("sn"), ResourceUtil.getString((String)"importFile.strategy.snUsed"));
        }
        dsIndex.add(sn);
    }

    private void fillDsInfo(Map<String, Attribute> nodeData) {
        if (this.dsInfo.isEmpty()) {
            return;
        }
        ParseLldUtil.integrateDataClusterNode(nodeData, this.dsInfo);
    }
}

