/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.distributeddeploy.logic.importfile.strategy;

import com.huawei.ism.tool.distributeddeploy.common.Context;
import com.huawei.ism.tool.distributeddeploy.common.ToolConfig;
import com.huawei.ism.tool.distributeddeploy.entity.DeployNode;
import com.huawei.ism.tool.distributeddeploy.fit.util.ParseLldUtil;
import com.huawei.ism.tool.distributeddeploy.logic.importfile.entity.Attribute;
import com.huawei.ism.tool.distributeddeploy.logic.importfile.strategy.DevsStrategyTask;
import com.huawei.ism.tool.obase.utils.CollectionUtil;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public class FullDeploySceneDevsStrategyTask
extends DevsStrategyTask {
    public FullDeploySceneDevsStrategyTask(List<Map<String, Attribute>> devDatas) {
        super(devDatas);
    }

    public FullDeploySceneDevsStrategyTask(List<Map<String, Attribute>> devDatas, List<Map<String, Attribute>> dsData) {
        super(devDatas);
        if (CollectionUtil.isEmpty(dsData)) {
            return;
        }
        Set bmcIps = devDatas.stream().map(one -> ((Attribute)one.get("bmcIp")).getValue()).collect(Collectors.toSet());
        HashSet dsIndex = new HashSet();
        dsData.forEach(data -> this.verifyDsInfo(bmcIps, (Map<String, Attribute>)data, dsIndex));
    }

    @Override
    protected void preCheck(List<Map<String, Attribute>> devData) {
        if (CollectionUtil.isEmpty(devData)) {
            return;
        }
        this.checkPatternConsistency(devData, "bmcIpPattern");
        this.checkPatternConsistency(devData, "bmcIpPatternDS");
    }

    @Override
    protected String parseSn(Map<String, Attribute> nodeData) {
        Attribute snAttribute = nodeData.get("sn");
        Attribute slotIdAttribute = nodeData.get("slotId");
        Attribute devTypeAttribute = nodeData.get("devType");
        if (this.needCombineSnWithSlot(devTypeAttribute, snAttribute, slotIdAttribute)) {
            snAttribute.setValue(ParseLldUtil.buildDataClusterIndex(nodeData));
        }
        this.recordSn(snAttribute);
        return snAttribute.getValue();
    }

    @Override
    protected DeployNode parseDev(Map<String, Attribute> nodeData) {
        DeployNode deployDevNode = new DeployNode(Context.INS.getDeployTaskInitService());
        deployDevNode.setDevType(nodeData.get("devType").getValue());
        deployDevNode.setSn(this.parseSn(nodeData));
        Attribute nodeName = nodeData.get("nodeName");
        this.recordNodeName(nodeName);
        deployDevNode.setNodeName(nodeName.getValue());
        deployDevNode.setUserInfo(nodeData);
        deployDevNode.setIpAddress(this.parseDevIpAddress(nodeData));
        if (nodeData.containsKey("bmcIpPatternDS") && !this.verifyDsIpPatternRepeated(nodeData)) {
            deployDevNode.setIpAddressDS(this.parseDevIpAddressDS(nodeData));
        }
        ParseLldUtil.parseAppendFiles(deployDevNode, nodeData);
        return deployDevNode;
    }

    private boolean needCombineSnWithSlot(Attribute devType, Attribute sn, Attribute slotId) {
        if (!ToolConfig.isNeedCombineSnWithSlot(devType.getValue())) {
            return false;
        }
        Optional<Set> slotIdWhiteListsOptional = ToolConfig.getDefaultIpMap().entrySet().stream().filter(entry -> devType.getValue().contains((CharSequence)entry.getKey())).map(Map.Entry::getValue).filter(ipMap -> Boolean.parseBoolean(ipMap.getOrDefault("slot", "true"))).map(Map::keySet).findFirst();
        if (slotIdWhiteListsOptional.isPresent() && !sn.getValue().isEmpty()) {
            Set slotIdWhiteLists = slotIdWhiteListsOptional.get();
            if (!slotIdWhiteLists.contains(slotId.getValue())) {
                this.addErrMsgWithPosition(slotId, ResourceUtil.getStringWithParams((String)"importFile.strategy.ocean.wrong.slotId", (Object[])new Object[]{devType.getValue(), slotIdWhiteLists.toString()}));
            }
            return true;
        }
        return false;
    }

    private void verifyDsInfo(Set<String> bmcIps, Map<String, Attribute> oneDsRow, Set<String> dsIndex) {
        Attribute bmcIp = oneDsRow.get("bmcIp");
        if (!bmcIps.contains(bmcIp.getValue())) {
            this.addErrMsgWithPosition(bmcIp, ResourceUtil.getString((String)"importFile.strategy.noVerifyBmcIp"));
        }
        if (dsIndex.contains(bmcIp.getValue())) {
            this.addErrMsgWithPosition(bmcIp, ResourceUtil.getString((String)"importFile.strategy.ipUsed"));
        }
        dsIndex.add(bmcIp.getValue());
    }
}

