/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.distributeddeploy.logic.importfile.strategy;

import com.huawei.ism.tool.distributeddeploy.common.Context;
import com.huawei.ism.tool.distributeddeploy.common.ToolConfig;
import com.huawei.ism.tool.distributeddeploy.entity.DeployNode;
import com.huawei.ism.tool.distributeddeploy.fit.common.ObserverManager;
import com.huawei.ism.tool.distributeddeploy.fit.util.ParseLldUtil;
import com.huawei.ism.tool.distributeddeploy.logic.importfile.entity.Attribute;
import com.huawei.ism.tool.distributeddeploy.logic.importfile.strategy.DevsStrategyTask;
import com.huawei.ism.tool.distributeddeploy.ui.card.Card;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import java.util.List;
import java.util.Map;

public class MatchCheckDeploySceneDevsStrategyTask
extends DevsStrategyTask {
    public MatchCheckDeploySceneDevsStrategyTask(List<Map<String, Attribute>> devDatas) {
        super(devDatas);
    }

    @Override
    protected void preCheck(List<Map<String, Attribute>> devData) {
        if (!"os_installation".equals(ObserverManager.getInstance().getCurrentScene())) {
            return;
        }
        this.verifyNewPasswordNotEmptyInOsInstall(devData);
    }

    @Override
    protected DeployNode parseDev(Map<String, Attribute> nodeData) {
        Attribute snAttribute;
        DeployNode deployDevNode = new DeployNode(Context.INS.getDeployTaskInitService(), Card.CardScene.MATCH_CHECK);
        Attribute devTypeAttribute = nodeData.get("devType");
        deployDevNode.setDevType(devTypeAttribute.getValue());
        if (!ObserverManager.getInstance().isDeployHelperServerScene() && ToolConfig.getDefaultIpMap().keySet().stream().anyMatch(type -> devTypeAttribute.getValue().contains((CharSequence)type))) {
            this.addErrMsgWithPosition(devTypeAttribute, ResourceUtil.getString((String)"ipmortFile.streatey.nosupport.devType"));
        }
        if ((snAttribute = nodeData.get("sn")) != null) {
            deployDevNode.setSn(snAttribute.getValue());
        }
        deployDevNode.setNodeName(nodeData.get("nodeName").getValue());
        deployDevNode.setUserInfo(nodeData);
        deployDevNode.setOsIp(nodeData.get("omIp").getValue());
        deployDevNode.setIpAddress(this.parseDevIpAddress(nodeData));
        ParseLldUtil.parseAppendFiles(deployDevNode, nodeData);
        return deployDevNode;
    }
}

