/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.distributeddeploy.logic.importfile.strategy;

import com.huawei.ism.tool.base.utils.StringUtils;
import com.huawei.ism.tool.distributeddeploy.common.Context;
import com.huawei.ism.tool.distributeddeploy.entity.IpAddress;
import com.huawei.ism.tool.distributeddeploy.fit.util.ParseLldUtil;
import com.huawei.ism.tool.distributeddeploy.logic.importfile.entity.Attribute;
import com.huawei.ism.tool.distributeddeploy.logic.importfile.entity.ClusterInfo;
import com.huawei.ism.tool.distributeddeploy.logic.importfile.entity.NetworkPlan;
import com.huawei.ism.tool.distributeddeploy.logic.importfile.entity.Plane;
import com.huawei.ism.tool.distributeddeploy.logic.importfile.entity.TransportProtocol;
import com.huawei.ism.tool.distributeddeploy.logic.importfile.entity.VlanPlan;
import com.huawei.ism.tool.distributeddeploy.logic.importfile.entity.osnetwork.BondConfigStrategy;
import com.huawei.ism.tool.distributeddeploy.logic.importfile.entity.osnetwork.BondToVlanConfigStrategy;
import com.huawei.ism.tool.distributeddeploy.logic.importfile.entity.osnetwork.OsIpAddress;
import com.huawei.ism.tool.distributeddeploy.logic.importfile.entity.osnetwork.PhysicalConfigStrategy;
import com.huawei.ism.tool.distributeddeploy.logic.importfile.entity.osnetwork.PhysicalToVlanConfigStrategy;
import com.huawei.ism.tool.distributeddeploy.logic.importfile.entity.osnetwork.base.BondPort;
import com.huawei.ism.tool.distributeddeploy.logic.importfile.entity.osnetwork.base.ConfigStrategy;
import com.huawei.ism.tool.distributeddeploy.logic.importfile.entity.osnetwork.base.PhysicalPort;
import com.huawei.ism.tool.distributeddeploy.logic.importfile.entity.osnetwork.base.Vlan;
import com.huawei.ism.tool.distributeddeploy.logic.importfile.strategy.StrategyTask;
import com.huawei.ism.tool.distributeddeploy.logic.importfile.verify.verifier.IpPatternVerifier;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public class OsNetworkStrategyTask
extends StrategyTask<Map<String, List<ConfigStrategy>>> {
    private final ClusterInfo clusterInfo;
    private final Set<String> bmcIps;
    private final Map<String, List<Map<String, Attribute>>> fileDatas;
    private Map<String, List<ConfigStrategy>> ip2ConfigStrategies;
    private String nowParsingBmcIp;
    private Map<String, Set<String>> ip2UsedVlanNames;
    private Map<String, Set<String>> ip2PortUsedBondNames;
    private Map<String, Set<String>> ip2VlanUsedBondNames;
    private Map<String, Set<PhysicalPort>> ip2PortUsedPhysicalPorts;
    private Map<String, Set<PhysicalPort>> ip2VlanUsedPhysicalPorts;
    private Map<String, Map<String, ConfigStrategy>> strategyPortName2Strategy;
    private Map<String, Map<Plane, Set<StrategyInfo>>> plane2StrategyInfo;
    private Set<String> usedNetworkIps;

    public OsNetworkStrategyTask(Map<String, List<Map<String, Attribute>>> fileDatas, ClusterInfo clusterInfo, Set<String> bmcIps) {
        this.clusterInfo = clusterInfo;
        this.bmcIps = bmcIps;
        this.mergeHCSODSInfo(fileDatas);
        this.fileDatas = fileDatas;
    }

    private void mergeHCSODSInfo(Map<String, List<Map<String, Attribute>>> fileDatas) {
        List<Map<String, Attribute>> hcso = fileDatas.getOrDefault("hcsoExternalOm", Collections.emptyList());
        List<Map<String, Attribute>> hcsoDS = fileDatas.getOrDefault("hcsoExternalOmDS", Collections.emptyList());
        if (hcso.isEmpty() || hcsoDS.isEmpty()) {
            return;
        }
        String hcsoIP = MessageFormat.format("{0}IpPattern", "om");
        String hcsoDSIP = MessageFormat.format("{0}IpPatternDS", "om");
        this.checkPatternConsistency(hcso, hcsoIP);
        this.checkPatternConsistency(hcsoDS, hcsoDSIP);
        Map<String, Map> masterHCSOInfoMap = hcso.stream().collect(Collectors.toMap(node -> ((Attribute)node.get("bmcIp")).getValue(), node -> node));
        HashSet<String> dSIpSet = new HashSet<String>();
        for (Map<String, Attribute> oneRow : hcsoDS) {
            String ibmcIp = oneRow.get("bmcIp").getValue();
            if (!masterHCSOInfoMap.containsKey(ibmcIp)) {
                this.addErrMsgWithPosition(oneRow.get("bmcIp"), ResourceUtil.getString((String)"importFile.strategy.noVerifyBmcIp"));
                continue;
            }
            if (dSIpSet.contains(ibmcIp)) {
                this.addErrMsgWithPosition(oneRow.get("bmcIp"), ResourceUtil.getString((String)"importFile.strategy.ipUsed"));
                continue;
            }
            Map oneHCSOInfo = masterHCSOInfoMap.get(ibmcIp);
            if (((Attribute)oneHCSOInfo.get(hcsoIP)).getValue().equals(oneRow.get(hcsoDSIP).getValue())) {
                this.addErrMsgWithPosition(oneRow.get("bmcIp"), ResourceUtil.getString((String)"importFile.verify.DS.omIp.pattern.repeated"));
                continue;
            }
            oneRow.forEach(oneHCSOInfo::putIfAbsent);
            dSIpSet.add(ibmcIp);
        }
    }

    @Override
    protected Map<String, List<ConfigStrategy>> doTask() {
        this.initData();
        this.parseOmNetwork();
        this.parseStorageNetwork();
        this.parseBusinessNetwork();
        this.setConfigStrategyDefaultRoute(this.ip2ConfigStrategies);
        this.setNetWorkPlaneWhenOmStorageIpShared(this.ip2ConfigStrategies);
        return this.ip2ConfigStrategies;
    }

    private void setNetWorkPlaneWhenOmStorageIpShared(Map<String, List<ConfigStrategy>> ip2ConfigStrategies) {
        if (!this.clusterInfo.isFsmOmInExIsolated()) {
            return;
        }
        ip2ConfigStrategies.forEach((bmcIp, configStrategies) -> configStrategies.stream().filter(strategy -> Plane.OM_INTERNAL.equals((Object)strategy.getPlane())).findAny().ifPresent(omStrategy -> this.getNetWorkPlaneByClusterInfo((ConfigStrategy)omStrategy, (String)bmcIp).ifPresent(transportProtocol -> this.updateIpSharedSceneOmStrategy((TransportProtocol)((Object)((Object)((Object)transportProtocol))), (ConfigStrategy)omStrategy))));
    }

    private Optional<TransportProtocol> getNetWorkPlaneByClusterInfo(ConfigStrategy omStrategy, String bmcIp) {
        StrategyInfo infoIpv4 = new StrategyInfo(omStrategy.getStrategyPortName(), omStrategy.getIpv4Address());
        StrategyInfo infoIpv6 = new StrategyInfo(omStrategy.getStrategyPortName(), omStrategy.getIpv6Address());
        Set<StrategyInfo> storageFrontInfo = this.plane2StrategyInfo.get(bmcIp).get((Object)Plane.STORAGE_FRONT);
        if (storageFrontInfo != null && (storageFrontInfo.contains(infoIpv4) || storageFrontInfo.contains(infoIpv6))) {
            return Optional.ofNullable(this.clusterInfo.getNetworkPlans().get((Object)Plane.STORAGE_FRONT).getTransportProtocol());
        }
        Set<StrategyInfo> storageBackInfo = this.plane2StrategyInfo.get(bmcIp).get((Object)Plane.STORAGE_BACK);
        if (storageBackInfo != null && (storageBackInfo.contains(infoIpv4) || storageBackInfo.contains(infoIpv6))) {
            return Optional.ofNullable(this.clusterInfo.getNetworkPlans().get((Object)Plane.STORAGE_BACK).getTransportProtocol());
        }
        return Optional.empty();
    }

    private void updateIpSharedSceneOmStrategy(TransportProtocol transportProtocol, ConfigStrategy omStrategy) {
        if (omStrategy instanceof PhysicalToVlanConfigStrategy) {
            omStrategy.setEquivalentToStoragePlane(true);
            omStrategy.setTransportProtocol(transportProtocol);
        }
        Optional.ofNullable(omStrategy.getIpv4Address()).ifPresent(ip -> ip.setGateway(null));
        Optional.ofNullable(omStrategy.getIpv6Address()).ifPresent(ip -> ip.setGateway(null));
    }

    protected void setConfigStrategyDefaultRoute(Map<String, List<ConfigStrategy>> ip2ConfigStrategies) {
        ip2ConfigStrategies.values().forEach(configStrategies -> {
            boolean hadExternalOm = configStrategies.stream().anyMatch(strategy -> Plane.OM_EXTERNAL.equals((Object)strategy.getPlane()));
            if (hadExternalOm) {
                configStrategies.stream().filter(strategy -> Plane.OM_EXTERNAL.equals((Object)strategy.getPlane())).forEach(strategy -> strategy.setOpenDefaultRoute(true));
                configStrategies.stream().filter(strategy -> Plane.OM_INTERNAL.equals((Object)strategy.getPlane())).filter(ConfigStrategy::containsIpv6).forEach(strategy -> strategy.getIpv6Address().setGateway(null));
            } else {
                configStrategies.stream().filter(strategy -> Plane.OM_INTERNAL.equals((Object)strategy.getPlane())).forEach(strategy -> strategy.setOpenDefaultRoute(true));
            }
        });
    }

    private void initData() {
        this.ip2ConfigStrategies = new HashMap<String, List<ConfigStrategy>>();
        this.ip2UsedVlanNames = new HashMap<String, Set<String>>();
        this.ip2PortUsedBondNames = new HashMap<String, Set<String>>();
        this.ip2VlanUsedBondNames = new HashMap<String, Set<String>>();
        this.ip2PortUsedPhysicalPorts = new HashMap<String, Set<PhysicalPort>>();
        this.ip2VlanUsedPhysicalPorts = new HashMap<String, Set<PhysicalPort>>();
        this.strategyPortName2Strategy = new HashMap<String, Map<String, ConfigStrategy>>();
        this.plane2StrategyInfo = new HashMap<String, Map<Plane, Set<StrategyInfo>>>();
        this.usedNetworkIps = new HashSet<String>();
    }

    private void parseStorageNetwork() {
        this.parseStorageNetwork(Plane.STORAGE_FRONT, "front", "storageFrontMultiIp");
        if (this.clusterInfo.isFrontBackIsolated()) {
            this.parseStorageNetwork(Plane.STORAGE_BACK, "back", "storageBackMultiIp");
        }
    }

    private void parseBusinessNetwork() {
        this.parseMultiIpNetwork(Plane.ISCSI, this.fileDatas.getOrDefault("iscsiBusiness", Collections.emptyList()));
        this.parseMultiIpNetwork(Plane.OBJECT, this.fileDatas.getOrDefault("objectBusiness", Collections.emptyList()));
        this.parseMultiIpNetwork(Plane.COPY_NET, this.fileDatas.getOrDefault("replicationNetWork", Collections.emptyList()));
    }

    private void parseOmNetwork() {
        if (!Context.INS.isExpansionScene()) {
            this.parseFsmOmNetwork();
        }
        this.parseSingleIpNetwork(Plane.OM_INTERNAL, ParseLldUtil.integrateNodes(this.fileDatas), "om");
        this.parseSingleIpNetwork(Plane.OM_EXTERNAL, this.fileDatas.getOrDefault("hcsoExternalOm", Collections.emptyList()), "om");
    }

    private void parseFsmOmNetwork() {
        List<Map<String, Attribute>> omNodeInfo = this.fileDatas.get("omNodeInfo");
        this.verifyFsmOmNetworkDSInfo(omNodeInfo);
        if (this.clusterInfo.isFsmOmInExIsolated()) {
            this.parseSingleIpNetwork(Plane.OM_EXTERNAL, omNodeInfo, "om");
        } else {
            HashSet ips = new HashSet();
            omNodeInfo.forEach(data -> this.verifyBmcIp((Attribute)data.get("bmcIp"), ips));
        }
    }

    private void verifyFsmOmNetworkDSInfo(List<Map<String, Attribute>> omNodeInfo) {
        omNodeInfo.forEach(oneRow -> {
            Attribute omIpPatternDS = (Attribute)oneRow.get(MessageFormat.format("{0}IpPatternDS", "om"));
            Attribute omIpDS = (Attribute)oneRow.get(MessageFormat.format("{0}IpDS", "om"));
            if (StringUtils.isNULLStr(omIpPatternDS.getValue()) && !StringUtils.isNULLStr(omIpDS.getValue())) {
                this.addErrMsgWithPosition(omIpPatternDS, new IpPatternVerifier().show());
                omIpPatternDS.setValue(String.valueOf((Object)IpAddress.IpPattern.IPV6));
            }
        });
    }

    private void parseStorageNetwork(Plane plane, String singleIpKey, String multiIpKey) {
        if (this.clusterInfo.getNetworkPlans().get((Object)plane).isMultiIp()) {
            if (!this.fileDatas.containsKey(multiIpKey)) {
                this.addErrMsg(ResourceUtil.getStringWithParams((String)"importFile.strategy.notfound.multiIp", (Object[])new Object[]{plane.getChartName()}));
                return;
            }
            this.parseMultiIpNetwork(plane, this.filterFsmNodeIfFsmOmStorageNoShared(this.fileDatas.get(multiIpKey)));
        } else {
            this.parseSingleIpNetwork(plane, this.filterFsmNodeIfFsmOmStorageNoShared(ParseLldUtil.integrateNodes(this.fileDatas)), singleIpKey);
        }
    }

    protected List<Map<String, Attribute>> filterFsmNodeIfFsmOmStorageNoShared(List<Map<String, Attribute>> datas) {
        if (!this.clusterInfo.isFsmOmStorageShared() && !this.clusterInfo.isFsmOmInExIsolated()) {
            Set fsmBmcIps = this.fileDatas.get("omNodeInfo").stream().map(data -> (Attribute)data.get("bmcIp")).map(Attribute::getValue).collect(Collectors.toSet());
            return datas.stream().filter(data -> !fsmBmcIps.contains(((Attribute)data.get("bmcIp")).getValue())).collect(Collectors.toList());
        }
        return datas;
    }

    private void parseSingleIpNetwork(Plane plane, List<Map<String, Attribute>> datas, String planeDataKey) {
        HashSet<String> ips = new HashSet<String>();
        for (Map<String, Attribute> data : datas) {
            Attribute bmcIp = data.get("bmcIp");
            if (!this.verifyBmcIp(bmcIp, ips)) continue;
            this.initNowParsingInfo(bmcIp.getValue());
            Attribute portName = data.get(MessageFormat.format("{0}PortName", planeDataKey));
            Attribute ipPattern = data.get(MessageFormat.format("{0}IpPattern", planeDataKey));
            Attribute ip = data.get(MessageFormat.format("{0}Ip", planeDataKey));
            Attribute netMaskOrPrefix = data.get(MessageFormat.format("{0}NetMaskOrPrefix", planeDataKey));
            if (plane.isOmPlane()) {
                Attribute gateway = data.get(MessageFormat.format("{0}Gateway", planeDataKey));
                this.judgeUsed2ParseStrategy(plane, portName, this.createIpAddress(ipPattern, ip, netMaskOrPrefix, gateway), ip).ifPresent(strategy -> this.addNetworkStrategy(bmcIp.getValue(), (ConfigStrategy)strategy));
                if (!data.containsKey("omIpPatternDS") || this.verifyDsIpPatternRepeated(ipPattern, data.get("omIpPatternDS"))) continue;
                Attribute ipPatternDS = data.get("omIpPatternDS");
                Attribute ipDS = data.get("omIpDS");
                Attribute netMaskOrPrefixDS = data.get("omNetMaskOrPrefixDS");
                Attribute gatewayDS = data.get("omGatewayDS");
                this.judgeUsed2ParseStrategy(plane, portName, this.createIpAddress(ipPatternDS, ipDS, netMaskOrPrefixDS, gatewayDS), ipDS).ifPresent(strategy -> this.addNetworkStrategy(bmcIp.getValue(), (ConfigStrategy)strategy));
                continue;
            }
            if (StringUtils.isNULLStr(portName.getValue()) || StringUtils.isNULLStr(ipPattern.getValue())) continue;
            this.judgeUsed2ParseStrategy(plane, portName, this.createIpAddress(ipPattern, ip, netMaskOrPrefix), ip).ifPresent(strategy -> this.addNetworkStrategy(bmcIp.getValue(), (ConfigStrategy)strategy));
        }
    }

    private void parseMultiIpNetwork(Plane plane, List<Map<String, Attribute>> datas) {
        HashSet<String> ips = new HashSet<String>();
        for (Map<String, Attribute> data : datas) {
            Attribute portName;
            ArrayList<ConfigStrategy> configStrategies = new ArrayList<ConfigStrategy>();
            Attribute bmcIp = data.get("bmcIp");
            if (!this.verifyBmcIp(bmcIp, ips)) continue;
            this.initNowParsingInfo(bmcIp.getValue());
            int ipNum = 0;
            while (++ipNum <= NetworkPlan.getMaxIpNum(plane) && !StringUtils.isNULLStr((portName = data.get(MessageFormat.format("ip{0}PortName", ipNum))).getValue())) {
                this.parseOneIpNetWork(data, plane, ipNum).ifPresent(configStrategies::add);
            }
            this.addNetworkStrategy(bmcIp.getValue(), configStrategies);
        }
    }

    private Optional<ConfigStrategy> parseOneIpNetWork(Map<String, Attribute> data, Plane plane, int parseIpNum) {
        Attribute portName = data.get(MessageFormat.format("ip{0}PortName", parseIpNum));
        Attribute ipPattern = data.get(MessageFormat.format("ip{0}IpPattern", parseIpNum));
        Attribute ip = data.get(MessageFormat.format("ip{0}Ip", parseIpNum));
        Attribute netMaskOrPrefix = data.get(MessageFormat.format("ip{0}NetMaskOrPrefix", parseIpNum));
        Optional<ConfigStrategy> configStrategyOptional = this.judgeUsed2ParseStrategy(plane, portName, this.createIpAddress(ipPattern, ip, netMaskOrPrefix), ip);
        if (this.isCtrlIpBelongToStrategy(plane, parseIpNum)) {
            if (configStrategyOptional.isPresent()) {
                this.parseCtrlIpAddress(ipPattern, data).ifPresent(ipAddress -> ((ConfigStrategy)configStrategyOptional.get()).setCtrlIpAddress((OsIpAddress)ipAddress));
            } else {
                StrategyInfo info = new StrategyInfo(portName.getValue(), this.createIpAddress(ipPattern, ip, netMaskOrPrefix));
                if (this.isOtherPlaneUsedConfigStrategy(plane, info)) {
                    this.parseCtrlIpAddress(ipPattern, data).ifPresent(ctrlIp -> this.strategyPortName2Strategy.get(this.nowParsingBmcIp).get(portName.getValue()).setCtrlIpAddress((OsIpAddress)ctrlIp));
                }
            }
        }
        return configStrategyOptional;
    }

    private boolean isCtrlIpBelongToStrategy(Plane plane, int parseIpNum) {
        boolean ctrlIpBelongToIpNum = true;
        return Plane.STORAGE_FRONT.equals((Object)plane) && parseIpNum == 1;
    }

    private Optional<OsIpAddress> parseCtrlIpAddress(Attribute ipPattern, Map<String, Attribute> data) {
        Attribute ctrlIp = data.get(MessageFormat.format("{0}Ip", "ctrl"));
        Attribute ctrlNetMaskOrPrefix = data.get(MessageFormat.format("{0}NetMaskOrPrefix", "ctrl"));
        Attribute ctrlGateWay = data.get(MessageFormat.format("{0}Gateway", "ctrl"));
        if (StringUtils.isNULLStr(ctrlIp.getValue())) {
            return Optional.empty();
        }
        this.verifyUsedIp(ctrlIp);
        return Optional.of(this.createIpAddress(ipPattern, ctrlIp, ctrlNetMaskOrPrefix, ctrlGateWay));
    }

    private Optional<ConfigStrategy> judgeUsed2ParseStrategy(Plane plane, Attribute portName, OsIpAddress ipAddress, Attribute ip) {
        ConfigStrategy usedStrategy;
        StrategyInfo info = new StrategyInfo(portName.getValue(), ipAddress);
        if (this.isOtherPlaneUsedConfigStrategy(plane, info)) {
            this.addStrategyInfoToUsed(plane, info);
            return Optional.empty();
        }
        this.addStrategyInfoToUsed(plane, info);
        if (this.isUsedConfigStrategyPortInfo(portName.getValue()) && this.needUpdateIpAddress(usedStrategy = this.strategyPortName2Strategy.get(this.nowParsingBmcIp).get(portName.getValue()), ipAddress)) {
            usedStrategy.setIpAddress(ipAddress);
            return Optional.empty();
        }
        this.verifyUsedIp(ip);
        Optional<ConfigStrategy> strategy = this.parseNetworkStrategy(portName, ipAddress);
        strategy.ifPresent(strategyInfo -> {
            this.addStrategyPortInfoToUsed(portName.getValue(), (ConfigStrategy)strategyInfo);
            strategyInfo.setPlane(plane);
            Optional.ofNullable(this.clusterInfo.getNetworkPlans()).map(value -> (NetworkPlan)value.get((Object)plane)).map(NetworkPlan::getTransportProtocol).ifPresent(strategyInfo::setTransportProtocol);
        });
        return strategy;
    }

    private Optional<ConfigStrategy> parseNetworkStrategy(Attribute portName, OsIpAddress ipAddress) {
        if (this.clusterInfo.getVlanPlans().containsKey(portName.getValue())) {
            return this.parseDivideVlanStrategy(portName, ipAddress);
        }
        if (this.clusterInfo.containsBondPlan(portName.getValue())) {
            BondPort bondPort = this.clusterInfo.getBondPlan(portName.getValue());
            this.dealUsedBondStrategy(portName, bondPort);
            return Optional.of(new BondConfigStrategy(ipAddress, bondPort));
        }
        if (this.isValidPhysicalPort(portName.getValue())) {
            PhysicalPort physicalPort = this.parsePhysicalPort(portName, portName.getValue());
            this.dealUsedPhysicalStrategy(portName, physicalPort);
            return Optional.of(new PhysicalConfigStrategy(ipAddress, physicalPort));
        }
        this.addErrMsgWithPosition(portName, ResourceUtil.getString((String)"importFile.strategy.portNameWrong"));
        return Optional.empty();
    }

    private Optional<ConfigStrategy> parseDivideVlanStrategy(Attribute portName, OsIpAddress ipAddress) {
        if (this.isUsedVlanName(portName)) {
            return Optional.empty();
        }
        VlanPlan vlanPlan = this.clusterInfo.getVlanPlans().get(portName.getValue());
        Vlan vlan = vlanPlan.getVlan();
        if (vlanPlan.getPort() instanceof BondPort) {
            BondPort bondPort = (BondPort)vlanPlan.getPort();
            this.dealUesdVlan2BondStrategy(portName, bondPort);
            return Optional.of(new BondToVlanConfigStrategy(ipAddress, bondPort, vlan));
        }
        if (vlanPlan.getPort() instanceof PhysicalPort) {
            PhysicalPort physicalPort = (PhysicalPort)vlanPlan.getPort();
            this.dealUsedVlan2PhysicalStrategy(portName, physicalPort);
            return Optional.of(new PhysicalToVlanConfigStrategy(ipAddress, physicalPort, vlan));
        }
        this.addErrMsgWithPosition(portName, ResourceUtil.getString((String)"importFile.strategy.vlanNameToVlanWrong"));
        return Optional.empty();
    }

    private boolean verifyBmcIp(Attribute bmcIp, Set<String> ips) {
        if (!this.bmcIps.contains(bmcIp.getValue())) {
            this.addErrMsgWithPosition(bmcIp, ResourceUtil.getString((String)"importFile.strategy.noVerifyBmcIp"));
            return false;
        }
        if (ips.contains(bmcIp.getValue())) {
            this.addErrMsgWithPosition(bmcIp, ResourceUtil.getString((String)"importFile.strategy.ipUsed"));
            return false;
        }
        ips.add(bmcIp.getValue());
        return true;
    }

    private boolean isUsedVlanName(Attribute vlanName) {
        if (this.ip2UsedVlanNames.get(this.nowParsingBmcIp).contains(vlanName.getValue())) {
            this.addErrMsgWithPosition(vlanName, ResourceUtil.getString((String)"importFile.strategy.devUsedVlan"));
            return true;
        }
        this.ip2UsedVlanNames.get(this.nowParsingBmcIp).add(vlanName.getValue());
        return false;
    }

    private void dealUesdVlan2BondStrategy(Attribute vlanName, BondPort bondPort) {
        if (this.isPortStrategyUsedBond(bondPort)) {
            this.addErrMsgWithPosition(vlanName, ResourceUtil.getString((String)"importFile.strategy.vlanBondUsed"));
        } else {
            this.addBondToVlanStrategyUsed(bondPort);
            bondPort.getPhysicalPorts().stream().filter(this::isPortStrategyUsedPhysicalPort).forEach(port -> this.addErrMsgWithPosition(vlanName, ResourceUtil.getStringWithParams((String)"importFile.strategy.vlanBondPhysicalUsed", (Object[])new Object[]{port.getPhysicalInfo()})));
            bondPort.getPhysicalPorts().forEach(this::addPhysicalPortToVlanStrategyUsed);
        }
    }

    private void dealUsedVlan2PhysicalStrategy(Attribute vlanName, PhysicalPort physicalPort) {
        if (this.isPortStrategyUsedPhysicalPort(physicalPort)) {
            this.addErrMsgWithPosition(vlanName, ResourceUtil.getStringWithParams((String)"importFile.strategy.vlanPhysicalUsed", (Object[])new Object[]{physicalPort.getPhysicalInfo()}));
        }
        this.addPhysicalPortToVlanStrategyUsed(physicalPort);
    }

    private void dealUsedBondStrategy(Attribute portName, BondPort bondPort) {
        if (this.isUsedBondPort(bondPort)) {
            this.addErrMsgWithPosition(portName, ResourceUtil.getString((String)"importFile.strategy.bondUsed"));
        } else {
            this.addBondToPortStrategyUsed(bondPort);
            bondPort.getPhysicalPorts().stream().filter(this::isUsedPhysicalPort).forEach(port -> this.addErrMsgWithPosition(portName, ResourceUtil.getStringWithParams((String)"importFile.strategy.bondPhysicalUsed", (Object[])new Object[]{port.getPhysicalInfo()})));
            bondPort.getPhysicalPorts().forEach(this::addPhysicalPortToPortStrategyUsed);
        }
    }

    private void dealUsedPhysicalStrategy(Attribute portName, PhysicalPort physicalPort) {
        if (this.isUsedPhysicalPort(physicalPort)) {
            this.addErrMsgWithPosition(portName, ResourceUtil.getStringWithParams((String)"importFile.strategy.physicalUsed", (Object[])new Object[]{physicalPort.getPhysicalInfo()}));
        }
        this.addPhysicalPortToPortStrategyUsed(physicalPort);
    }

    private boolean isUsedBondPort(BondPort bondPort) {
        return this.isPortStrategyUsedBond(bondPort) || this.isVlanStrategyUsedBond(bondPort);
    }

    private boolean isUsedPhysicalPort(PhysicalPort physicalPort) {
        return this.isPortStrategyUsedPhysicalPort(physicalPort) || this.isVlanStrategyUsedPhysicalPort(physicalPort);
    }

    private void addNetworkStrategy(String bmcIp, List<ConfigStrategy> configStrategies) {
        this.ip2ConfigStrategies.computeIfAbsent(bmcIp, key -> new ArrayList()).addAll(configStrategies);
    }

    private void addNetworkStrategy(String bmcIp, ConfigStrategy configStrategy) {
        this.ip2ConfigStrategies.computeIfAbsent(bmcIp, key -> new ArrayList()).add(configStrategy);
    }

    private boolean isPortStrategyUsedBond(BondPort bondPort) {
        return this.ip2PortUsedBondNames.get(this.nowParsingBmcIp).contains(bondPort.getBondName());
    }

    private void addBondToPortStrategyUsed(BondPort bondPort) {
        this.ip2PortUsedBondNames.get(this.nowParsingBmcIp).add(bondPort.getBondName());
    }

    private boolean isVlanStrategyUsedBond(BondPort bondPort) {
        return this.ip2VlanUsedBondNames.get(this.nowParsingBmcIp).contains(bondPort.getBondName());
    }

    private void addBondToVlanStrategyUsed(BondPort bondPort) {
        this.ip2VlanUsedBondNames.get(this.nowParsingBmcIp).add(bondPort.getBondName());
    }

    private boolean isPortStrategyUsedPhysicalPort(PhysicalPort physicalPort) {
        return this.ip2PortUsedPhysicalPorts.get(this.nowParsingBmcIp).contains(physicalPort);
    }

    private void addPhysicalPortToPortStrategyUsed(PhysicalPort physicalPort) {
        this.ip2PortUsedPhysicalPorts.get(this.nowParsingBmcIp).add(physicalPort);
    }

    private boolean isVlanStrategyUsedPhysicalPort(PhysicalPort physicalPort) {
        return this.ip2VlanUsedPhysicalPorts.get(this.nowParsingBmcIp).contains(physicalPort);
    }

    private void addPhysicalPortToVlanStrategyUsed(PhysicalPort physicalPort) {
        this.ip2VlanUsedPhysicalPorts.get(this.nowParsingBmcIp).add(physicalPort);
    }

    private void initNowParsingInfo(String bmcIp) {
        this.nowParsingBmcIp = bmcIp;
        this.ip2UsedVlanNames.computeIfAbsent(bmcIp, key -> new HashSet());
        this.ip2PortUsedBondNames.computeIfAbsent(bmcIp, key -> new HashSet());
        this.ip2VlanUsedBondNames.computeIfAbsent(bmcIp, key -> new HashSet());
        this.ip2PortUsedPhysicalPorts.computeIfAbsent(bmcIp, key -> new HashSet());
        this.ip2VlanUsedPhysicalPorts.computeIfAbsent(bmcIp, key -> new HashSet());
    }

    private boolean isUsedConfigStrategyPortInfo(String portName) {
        return this.strategyPortName2Strategy.containsKey(this.nowParsingBmcIp) && this.strategyPortName2Strategy.get(this.nowParsingBmcIp).containsKey(portName);
    }

    private void addStrategyPortInfoToUsed(String portName, ConfigStrategy strategy) {
        this.strategyPortName2Strategy.computeIfAbsent(this.nowParsingBmcIp, key -> new HashMap()).put(portName, strategy);
    }

    private boolean isOtherPlaneUsedConfigStrategy(Plane plane, StrategyInfo info) {
        return this.plane2StrategyInfo.containsKey(this.nowParsingBmcIp) && this.plane2StrategyInfo.get(this.nowParsingBmcIp).entrySet().stream().filter(entry -> !plane.equals(entry.getKey())).map(Map.Entry::getValue).anyMatch(set -> set.contains(info));
    }

    private void addStrategyInfoToUsed(Plane plane, StrategyInfo info) {
        this.plane2StrategyInfo.computeIfAbsent(this.nowParsingBmcIp, key -> new EnumMap(Plane.class)).computeIfAbsent(plane, key -> new HashSet()).add(info);
    }

    private boolean needUpdateIpAddress(ConfigStrategy strategy, OsIpAddress ipAddress) {
        if (strategy.containsIpv4() && strategy.containsIpv6()) {
            return false;
        }
        return strategy.containsIpv4() && IpAddress.IpPattern.IPV6.equals((Object)ipAddress.getIpPattern()) || strategy.containsIpv6() && IpAddress.IpPattern.IPV4.equals((Object)ipAddress.getIpPattern());
    }

    private void verifyUsedIp(Attribute ip) {
        if (!StringUtils.isNULLStr(ip.getValue())) {
            if (this.usedNetworkIps.contains(ip.getValue()) || this.bmcIps.contains(ip.getValue())) {
                this.addErrMsgWithPosition(ip, ResourceUtil.getString((String)"importFile.strategy.ipUsed"));
            }
            this.usedNetworkIps.add(ip.getValue());
        }
    }

    private class StrategyInfo {
        private String portName;
        private OsIpAddress ipAddress;

        public StrategyInfo(String portName, OsIpAddress ipAddress) {
            this.portName = portName;
            this.ipAddress = ipAddress;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof StrategyInfo)) {
                return false;
            }
            StrategyInfo other = (StrategyInfo)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$portName = this.portName;
            String other$portName = other.portName;
            if (this$portName == null ? other$portName != null : !this$portName.equals(other$portName)) {
                return false;
            }
            OsIpAddress this$ipAddress = this.ipAddress;
            OsIpAddress other$ipAddress = other.ipAddress;
            return !(this$ipAddress == null ? other$ipAddress != null : !((Object)this$ipAddress).equals(other$ipAddress));
        }

        protected boolean canEqual(Object other) {
            return other instanceof StrategyInfo;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $portName = this.portName;
            result = result * 59 + ($portName == null ? 43 : $portName.hashCode());
            OsIpAddress $ipAddress = this.ipAddress;
            result = result * 59 + ($ipAddress == null ? 43 : ((Object)$ipAddress).hashCode());
            return result;
        }
    }
}

