/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.distributeddeploy.logic.importfile.strategy;

import com.huawei.ism.tool.base.utils.StringUtils;
import com.huawei.ism.tool.distributeddeploy.entity.IpAddress;
import com.huawei.ism.tool.distributeddeploy.logic.importfile.entity.Attribute;
import com.huawei.ism.tool.distributeddeploy.logic.importfile.entity.osnetwork.base.ConfigStrategy;
import com.huawei.ism.tool.distributeddeploy.logic.importfile.entity.osnetwork.route.CrossNetworkSegmentSourceIpPolicyRoute;
import com.huawei.ism.tool.distributeddeploy.logic.importfile.entity.osnetwork.route.IPolicyRoute;
import com.huawei.ism.tool.distributeddeploy.logic.importfile.entity.osnetwork.route.SameNetworkSegmentSourceIpPolicyRoute;
import com.huawei.ism.tool.distributeddeploy.logic.importfile.strategy.RouteStrategyTask;
import java.util.List;
import java.util.Map;

public class PolicyRouteStrategyTask
extends RouteStrategyTask {
    public PolicyRouteStrategyTask(List<Map<String, Attribute>> routeDatas, Map<String, List<ConfigStrategy>> ip2ConfigStrategies) {
        super(routeDatas, ip2ConfigStrategies);
    }

    @Override
    protected void addIpv4RouteInfo(ConfigStrategy routeConfigStrategy, Map<String, Attribute> routeData) {
        routeConfigStrategy.getRouteCollection().getIpv4PolicyRoutes().add(this.createSourceIpPolicyRoute(routeConfigStrategy.getIpv4Address(), routeData));
    }

    @Override
    protected void addIpv6RouteInfo(ConfigStrategy routeConfigStrategy, Map<String, Attribute> routeData) {
        routeConfigStrategy.getRouteCollection().getIpv6PolicyRoutes().add(this.createSourceIpPolicyRoute(routeConfigStrategy.getIpv6Address(), routeData));
    }

    private IPolicyRoute createSourceIpPolicyRoute(IpAddress ipAddress, Map<String, Attribute> routeData) {
        Attribute routeGateway = routeData.get("gateWay");
        if (StringUtils.isNULLStr(routeGateway.getValue())) {
            return new SameNetworkSegmentSourceIpPolicyRoute(routeData.get("ip").getValue(), ipAddress);
        }
        return new CrossNetworkSegmentSourceIpPolicyRoute(ipAddress, routeData.get("ip").getValue(), routeGateway.getValue());
    }
}

