/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.distributeddeploy.logic.importfile.strategy;

import com.huawei.ism.tool.distributeddeploy.entity.IpAddress;
import com.huawei.ism.tool.distributeddeploy.logic.importfile.entity.Attribute;
import com.huawei.ism.tool.distributeddeploy.logic.importfile.entity.osnetwork.base.ConfigStrategy;
import com.huawei.ism.tool.distributeddeploy.logic.importfile.strategy.StrategyTask;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;

public abstract class RouteStrategyTask
extends StrategyTask<Map<String, List<ConfigStrategy>>> {
    private final Map<String, List<ConfigStrategy>> ip2ConfigStrategies;
    private List<Map<String, Attribute>> routeDatas;

    public RouteStrategyTask(List<Map<String, Attribute>> routeDatas, Map<String, List<ConfigStrategy>> ip2ConfigStrategies) {
        this.routeDatas = routeDatas;
        this.ip2ConfigStrategies = ip2ConfigStrategies;
    }

    @Override
    protected Map<String, List<ConfigStrategy>> doTask() {
        this.parseStaticRoute();
        return this.ip2ConfigStrategies;
    }

    private void parseStaticRoute() {
        this.routeDatas.forEach(routeData -> {
            Attribute bmcIp = (Attribute)routeData.get("bmcIp");
            if (this.ip2ConfigStrategies.containsKey(bmcIp.getValue())) {
                this.parseConfigStaticRoute(bmcIp.getValue(), (Map<String, Attribute>)routeData);
            } else {
                this.addErrMsgWithPosition(bmcIp, ResourceUtil.getString((String)"importFile.verify.route.invalid.bmcip"));
            }
        });
    }

    private void parseConfigStaticRoute(String bmcIp, Map<String, Attribute> routeData) {
        Attribute portName = routeData.get("portName");
        Attribute routeIpPattern = routeData.get("ipPattern");
        Optional<ConfigStrategy> routeConfigStrategyOp = this.ip2ConfigStrategies.get(bmcIp).stream().filter(configStrategy -> portName.getValue().equals(configStrategy.getStrategyPortName())).findAny();
        if (!routeConfigStrategyOp.isPresent()) {
            this.addErrMsgWithPosition(portName, ResourceUtil.getString((String)"importFile.verify.route.invalid.port"));
            return;
        }
        IpAddress.IpPattern ipPattern = IpAddress.IpPattern.valueOf(routeIpPattern.getValue().toUpperCase(Locale.ENGLISH));
        ConfigStrategy routeConfigStrategy = routeConfigStrategyOp.get();
        if (IpAddress.IpPattern.IPV4.equals((Object)ipPattern)) {
            if (routeConfigStrategy.containsIpv4()) {
                this.addIpv4RouteInfo(routeConfigStrategy, routeData);
            } else {
                this.addErrMsgWithPosition(portName, ResourceUtil.getString((String)"importFile.strategy.route.non.ipv4"));
            }
        } else if (routeConfigStrategy.containsIpv6()) {
            this.addIpv6RouteInfo(routeConfigStrategy, routeData);
        } else {
            this.addErrMsgWithPosition(portName, ResourceUtil.getString((String)"importFile.strategy.route.non.ipv6"));
        }
    }

    protected abstract void addIpv4RouteInfo(ConfigStrategy var1, Map<String, Attribute> var2);

    protected abstract void addIpv6RouteInfo(ConfigStrategy var1, Map<String, Attribute> var2);
}

