/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.distributeddeploy.logic.importfile.strategy;

import com.huawei.ism.tool.distributeddeploy.logic.importfile.entity.Attribute;
import com.huawei.ism.tool.distributeddeploy.logic.importfile.entity.osnetwork.base.ConfigStrategy;
import com.huawei.ism.tool.distributeddeploy.logic.importfile.entity.osnetwork.route.IRoute;
import com.huawei.ism.tool.distributeddeploy.logic.importfile.entity.osnetwork.route.StaticRoute;
import com.huawei.ism.tool.distributeddeploy.logic.importfile.strategy.RouteStrategyTask;
import com.huawei.ism.tool.obase.net.dhcp.utils.ToolNetUtil;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class StaticRouteStrategyTask
extends RouteStrategyTask {
    public StaticRouteStrategyTask(List<Map<String, Attribute>> routeDatas, Map<String, List<ConfigStrategy>> ip2ConfigStrategies) {
        super(routeDatas, ip2ConfigStrategies);
    }

    @Override
    protected void addIpv4RouteInfo(ConfigStrategy routeConfigStrategy, Map<String, Attribute> routeData) {
        routeConfigStrategy.getRouteCollection().getIpv4StaticRoutes().add(this.createStaticRoute(routeData));
    }

    @Override
    protected void addIpv6RouteInfo(ConfigStrategy routeConfigStrategy, Map<String, Attribute> routeData) {
        routeConfigStrategy.getRouteCollection().getIpv6StaticRoutes().add(this.createStaticRoute(routeData));
    }

    private IRoute createStaticRoute(Map<String, Attribute> routeData) {
        Attribute ip = routeData.get("ip");
        Attribute routePrefix = routeData.get("netMaskOrPrefix");
        String prefixValue = Optional.of(routePrefix).map(Attribute::getValue).filter(prefix -> prefix.contains(".")).map(ToolNetUtil::transMaskToPrefixLength).map(String::valueOf).orElse(routePrefix.getValue());
        Attribute routeGateway = routeData.get("gateWay");
        return new StaticRoute(ip.getValue(), prefixValue, routeGateway.getValue());
    }
}

