/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.distributeddeploy.logic.importfile.strategy;

import com.huawei.ism.tool.distributeddeploy.entity.IpAddress;
import com.huawei.ism.tool.distributeddeploy.logic.importfile.entity.Attribute;
import com.huawei.ism.tool.distributeddeploy.logic.importfile.entity.osnetwork.OsIpAddress;
import com.huawei.ism.tool.distributeddeploy.logic.importfile.entity.osnetwork.base.PhysicalPort;
import com.huawei.ism.tool.distributeddeploy.logic.importfile.impl.Task;
import com.huawei.ism.tool.distributeddeploy.logic.importfile.verify.verifier.IpPatternVerifier;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import com.huawei.ism.tool.obase.utils.StringUtils;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;

abstract class StrategyTask<T>
extends Task<T> {
    StrategyTask() {
    }

    boolean verifyEmptyValue(Attribute attribute, String errMsg) {
        if (StringUtils.isNULLStr((String)attribute.getValue())) {
            this.addErrMsgWithPosition(attribute, errMsg);
            return true;
        }
        return false;
    }

    PhysicalPort parsePhysicalPort(Attribute physicalCard, String physicalPortInfo) {
        if (!this.isValidPhysicalPort(physicalPortInfo)) {
            this.addErrMsgWithPosition(physicalCard, ResourceUtil.getString((String)"importFile.strategy.physicalWrong"));
            return new PhysicalPort();
        }
        if (physicalPortInfo.contains("/")) {
            String[] physicalPortInfos = physicalPortInfo.split("/");
            return new PhysicalPort(physicalPortInfos[0], physicalPortInfos[1]);
        }
        return new PhysicalPort("", physicalPortInfo);
    }

    boolean isValidPhysicalPort(String physicalPortInfo) {
        return physicalPortInfo.matches(".+/([pP])ort[1-9][0-9]*") || physicalPortInfo.matches("[Pp]ort[0-9]");
    }

    OsIpAddress createIpAddress(Attribute ipPattern, Attribute ip, Attribute netMaskOrPrefix, Attribute gateway) {
        this.checkHaveIpPattern(ipPattern);
        IpAddress.IpPattern pattern = IpAddress.IpPattern.valueOf(ipPattern.getValue().toUpperCase(Locale.ENGLISH));
        OsIpAddress ipAddress = new OsIpAddress();
        if (IpAddress.IpPattern.IPV4.equals((Object)pattern)) {
            ipAddress.setIpv4Address(ip.getValue(), netMaskOrPrefix.getValue(), gateway.getValue());
        } else {
            ipAddress.setIpv6Address(ip.getValue(), netMaskOrPrefix.getValue(), gateway.getValue());
        }
        return ipAddress;
    }

    OsIpAddress createIpAddress(Attribute ipPattern, Attribute ip, Attribute netMaskOrPrefix) {
        this.checkHaveIpPattern(ipPattern);
        IpAddress.IpPattern pattern = IpAddress.IpPattern.valueOf(ipPattern.getValue().toUpperCase(Locale.ENGLISH));
        OsIpAddress ipAddress = new OsIpAddress();
        if (IpAddress.IpPattern.IPV4.equals((Object)pattern)) {
            ipAddress.setIpv4Address(ip.getValue(), netMaskOrPrefix.getValue());
        } else {
            ipAddress.setIpv6Address(ip.getValue(), netMaskOrPrefix.getValue());
        }
        return ipAddress;
    }

    protected void checkHaveIpPattern(Attribute ipPattern) {
        if (StringUtils.isNULLStr((String)ipPattern.getValue())) {
            this.addErrMsgWithPosition(ipPattern, new IpPatternVerifier().show());
            ipPattern.setValue(String.valueOf((Object)IpAddress.IpPattern.IPV4));
        }
    }

    protected boolean verifyDsIpPatternRepeated(Map<String, Attribute> nodeData) {
        if (StringUtils.isNULLStr((String)nodeData.get("bmcIpDS").getValue())) {
            return true;
        }
        return this.verifyDsIpPatternRepeated(nodeData.get("bmcIpPattern"), nodeData.get("bmcIpPatternDS"));
    }

    protected boolean verifyDsIpPatternRepeated(Attribute ipPatternMaster, Attribute ipPatternDS) {
        if (StringUtils.isNULLStr((String)ipPatternDS.getValue())) {
            return true;
        }
        boolean result = ipPatternDS.getValue().equals(ipPatternMaster.getValue());
        if (result) {
            this.addErrMsgWithPosition(ipPatternDS, ResourceUtil.getString((String)"importFile.verify.DS.ip.pattern.repeated"));
        }
        return result;
    }

    protected void checkPatternConsistency(List<Map<String, Attribute>> devData, String key) {
        long size = devData.stream().map(one -> (Attribute)one.get(key)).filter(Objects::nonNull).map(Attribute::getValue).distinct().count();
        if (size > 1L) {
            String sheetName = devData.stream().map(one -> (Attribute)one.get(key)).filter(Objects::nonNull).findFirst().map(Attribute::getSheetName).orElse("");
            this.addErrMsg(ResourceUtil.getStringWithParams((String)"importFile.verify.DS.ip.pattern.equals.inOneSheet", (Object[])new Object[]{sheetName}));
        }
    }
}

