/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.distributeddeploy.logic.importfile.strategy;

import com.huawei.ism.tool.distributeddeploy.common.Context;
import com.huawei.ism.tool.distributeddeploy.entity.DeployNode;
import com.huawei.ism.tool.distributeddeploy.entity.IpAddress;
import com.huawei.ism.tool.distributeddeploy.entity.User;
import com.huawei.ism.tool.distributeddeploy.logic.importfile.entity.Attribute;
import com.huawei.ism.tool.distributeddeploy.logic.importfile.strategy.DevsStrategyTask;
import com.huawei.ism.tool.distributeddeploy.ui.card.Card;
import java.util.List;
import java.util.Map;

public class SystemInstallStrategyTask
extends DevsStrategyTask {
    public SystemInstallStrategyTask(List<Map<String, Attribute>> devDatas) {
        super(devDatas);
    }

    @Override
    protected void preCheck(List<Map<String, Attribute>> devData) {
        this.verifyNewPasswordNotEmptyInOsInstall(devData);
    }

    @Override
    protected DeployNode parseDev(Map<String, Attribute> nodeData) {
        DeployNode deployDevNode = new DeployNode(Context.INS.getDeployTaskInitService(), Card.CardScene.SYSTEM_INSTALLATION);
        Attribute devTypeAttribute = nodeData.get("devType");
        deployDevNode.setDevType(devTypeAttribute.getValue());
        deployDevNode.setNodeName(nodeData.get("nodeName").getValue());
        deployDevNode.setIpAddress(this.parseDevIpAddress(nodeData));
        deployDevNode.setSn(nodeData.get("sn").getValue());
        this.setUserInfo(nodeData, deployDevNode);
        deployDevNode.setCabinetId("--");
        deployDevNode.setSubrackId("--");
        deployDevNode.setFrontIp("--");
        deployDevNode.setBackIp("--");
        return deployDevNode;
    }

    void setUserInfo(Map<String, Attribute> nodeData, DeployNode deployDevNode) {
        deployDevNode.setOsRootUser(new User("root", nodeData.get("rootUserOriginPassword").getValue(), nodeData.get("rootUserNewPassword").getValue()));
        deployDevNode.setBmcUser(new User(nodeData.get("bmcUserName").getValue(), nodeData.get("bmcUserOriginPassword").getValue(), ""));
        deployDevNode.setOsUser(new User(nodeData.get("osUserName").getValue(), nodeData.get("osUserOriginPassword").getValue(), nodeData.get("osUserNewPassword").getValue()));
    }

    @Override
    protected IpAddress parseDevIpAddress(Map<String, Attribute> nodeData) {
        Attribute bmcIp = nodeData.get("bmcIp");
        this.recordIp(bmcIp);
        return this.createIpAddress(nodeData.get("bmcIpPattern"), bmcIp, new Attribute(null, ""), new Attribute(null, ""));
    }
}

