/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.distributeddeploy.logic.importfile.verify;

import com.huawei.ism.tool.base.utils.StringUtils;
import com.huawei.ism.tool.distributeddeploy.logic.importfile.entity.Attribute;
import com.huawei.ism.tool.distributeddeploy.logic.importfile.impl.Task;
import com.huawei.ism.tool.distributeddeploy.logic.importfile.verify.impl.Verifier;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class VerifyTask
extends Task<Map<String, List<Map<String, Attribute>>>> {
    private final Map<String, List<Map<String, Attribute>>> tableDatas;
    private final Map<String, Set<String>> repeatDatas;

    public VerifyTask(Map<String, List<Map<String, Attribute>>> tableDatas) {
        this.tableDatas = tableDatas;
        this.repeatDatas = new HashMap<String, Set<String>>();
    }

    @Override
    protected Map<String, List<Map<String, Attribute>>> doTask() {
        this.tableDatas.values().forEach(tableData -> tableData.forEach(lineAttributes -> lineAttributes.values().stream().filter(Attribute::needVerify).forEach(attribute -> this.verifyAttribute((Map<String, Attribute>)lineAttributes, (Attribute)attribute))));
        return this.tableDatas;
    }

    private void verifyAttribute(Map<String, Attribute> lineAttributes, Attribute attribute) {
        this.checkAttributeValueRepeat(attribute);
        for (Verifier verifier : attribute.getVerifiers()) {
            verifier.initLinkParamsValue(lineAttributes);
            if (!verifier.metPreCondition(this.tableDatas, lineAttributes) || this.doVerify(attribute, verifier)) continue;
            return;
        }
    }

    private void checkAttributeValueRepeat(Attribute attribute) {
        if (!(StringUtils.isNULLStr(attribute.getCheckRepeat()) || StringUtils.isNULLStr(attribute.getValue()) || this.repeatDatas.computeIfAbsent(attribute.getCheckRepeat(), key -> new HashSet()).add(attribute.getValue()))) {
            this.addErrMsgWithPosition(attribute, ResourceUtil.getStringWithParams((String)"importFile.verify.value.exists", (Object[])new Object[]{attribute.getValue()}));
        }
    }

    private boolean doVerify(Attribute attribute, Verifier verifier) {
        if (!verifier.verify(attribute.getValue())) {
            this.addErrMsgWithPosition(attribute, verifier.show());
            return false;
        }
        return true;
    }
}

