/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.distributeddeploy.logic.importfile.verify.precondition;

import com.huawei.ism.tool.distributeddeploy.logic.importfile.entity.Attribute;
import com.huawei.ism.tool.distributeddeploy.logic.importfile.verify.impl.Condition;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public class AttributeMatchValueCondition
extends Condition {
    private String conditionKey;
    private List<String> conditionValues;
    private String acrossTableKey;
    private int acrossLineNum;

    public AttributeMatchValueCondition(String preConditionStr) {
        if (preConditionStr.contains("/")) {
            String[] preConditionStrs = preConditionStr.split("/");
            this.parseAcrossTable(preConditionStrs[0]);
            this.parseCondition(preConditionStrs[1]);
        } else {
            this.parseCondition(preConditionStr);
        }
    }

    private void parseAcrossTable(String acrossTableStr) {
        String[] acrossTableStrs = acrossTableStr.split(":");
        this.acrossTableKey = acrossTableStrs[0];
        this.acrossLineNum = Integer.parseInt(acrossTableStrs[1]);
    }

    private void parseCondition(String preConditionStr) {
        String[] preConditions = preConditionStr.split(":");
        this.conditionKey = preConditions[0];
        this.conditionValues = Arrays.asList(preConditions[1].split(","));
    }

    @Override
    public boolean metCondition(Map<String, List<Map<String, Attribute>>> tableDatas, Map<String, Attribute> verifyAttributeSameLineAttributes) {
        Map<String, Attribute> attributeMap = this.needAcrossTable() ? tableDatas.get(this.acrossTableKey).get(this.acrossLineNum) : verifyAttributeSameLineAttributes;
        if (this.conditionValues.size() == 1 && "!".equals(this.conditionValues.get(0))) {
            return !attributeMap.get(this.conditionKey).getValue().isEmpty();
        }
        return this.conditionValues.contains(attributeMap.get(this.conditionKey).getValue());
    }

    private boolean needAcrossTable() {
        return this.acrossTableKey != null;
    }
}

