/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.distributeddeploy.logic.importfile.verify.precondition;

import com.huawei.ism.tool.distributeddeploy.logic.importfile.entity.Attribute;
import com.huawei.ism.tool.distributeddeploy.logic.importfile.verify.impl.Condition;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;

public class LineContainsValueCondition
extends Condition {
    private boolean negation = false;
    private String lineAttributeKey;
    private String targetTableKey;
    private String targetTableAttributeKey;
    private List<String> targetConstantValues;

    public LineContainsValueCondition(String preConditionStr) {
        if (preConditionStr.startsWith("!")) {
            this.init(preConditionStr.substring(1));
            this.negation = true;
        } else {
            this.init(preConditionStr);
        }
    }

    private void init(String preConditionStr) {
        String[] preConditionStrs = preConditionStr.split(">");
        this.lineAttributeKey = preConditionStrs[0];
        String[] containsTableKeys = preConditionStrs[1].split(":");
        if (containsTableKeys.length == 1) {
            this.targetConstantValues = Arrays.asList(containsTableKeys[0].split(","));
        } else {
            this.targetTableKey = containsTableKeys[0];
            this.targetTableAttributeKey = containsTableKeys[1];
        }
    }

    @Override
    public boolean metCondition(Map<String, List<Map<String, Attribute>>> tableDatas, Map<String, Attribute> verifyAttributeSameLineAttributes) {
        String nowLineAttributeValue = verifyAttributeSameLineAttributes.get(this.lineAttributeKey).getValue();
        boolean contains = (CollectionUtils.isNotEmpty(this.targetConstantValues) ? this.targetConstantValues : tableDatas.get(this.targetTableKey).stream().map(map -> ((Attribute)map.get(this.targetTableAttributeKey)).getValue()).collect(Collectors.toList())).contains(nowLineAttributeValue);
        if (this.negation) {
            return !contains;
        }
        return contains;
    }
}

