/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.distributeddeploy.logic.importfile.verify.verifier;

import com.huawei.ism.tool.distributeddeploy.logic.importfile.verify.impl.Verifier;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import java.util.regex.Pattern;

public class NumRangeVerifier
extends Verifier {
    private final Pattern digitPattern = Pattern.compile("[0-9]*");
    private int start;
    private int end;

    public NumRangeVerifier(String param) {
        this.initParam(param);
    }

    public NumRangeVerifier(int start, int end) {
        this.start = start;
        this.end = end;
    }

    private void initParam(String paramStr) {
        String[] params = paramStr.split(",");
        this.start = Integer.parseInt(params[0]);
        this.end = Integer.parseInt(params[1]);
    }

    @Override
    public boolean verify(String attribute) {
        if (!this.digitPattern.matcher(attribute).matches()) {
            return false;
        }
        try {
            int num = Integer.parseInt(attribute);
            return this.start <= num && num <= this.end;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    @Override
    public String show() {
        return ResourceUtil.getStringWithParams((String)"importFile.verify.num.range", (Object[])new Object[]{this.start, this.end});
    }
}

