/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.distributeddeploy.logic.ssdp;

import com.huawei.ism.tool.distributeddeploy.logic.ssdp.SsdpSearch;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SnMappingIpTask {
    private static final Logger log = LoggerFactory.getLogger(SnMappingIpTask.class);
    private volatile boolean searching = false;
    private volatile Map<String, String> sn2ip = new HashMap<String, String>();
    private static final SnMappingIpTask INS = new SnMappingIpTask();

    private SnMappingIpTask() {
    }

    public static SnMappingIpTask getInstance() {
        return INS;
    }

    public synchronized void mapping() {
        this.searching = true;
        HashSet<InetAddress> inetAddresses = this.getValidLockLinkIps();
        this.sn2ip = new HashMap<String, String>();
        for (InetAddress inetAddress : inetAddresses) {
            ArrayList<String> responses = new SsdpSearch(inetAddress).search();
            LinkedHashMap<String, String> sn2ipMap = this.parseSsdpResponse(responses);
            this.sn2ip.putAll(sn2ipMap);
            log.info("ssdp searched: {}", sn2ipMap);
        }
        this.searching = false;
    }

    public void printNotMatchedSn2Ip(Set<String> nodeSns) {
        Map<String, String> notMatchedMap = this.sn2ip.entrySet().stream().filter(entry -> !nodeSns.contains(entry.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        log.info("ssdp searched but not filled in the LLD template: {}", notMatchedMap);
    }

    public boolean hadSearchIp(String sn) {
        return this.sn2ip.containsKey(sn);
    }

    public String getSearchedIp(String sn) {
        return this.sn2ip.get(sn);
    }

    private HashSet<InetAddress> getValidLockLinkIps() {
        HashSet<InetAddress> localAddress = new HashSet<InetAddress>();
        try {
            Enumeration<NetworkInterface> interfs = NetworkInterface.getNetworkInterfaces();
            while (interfs.hasMoreElements()) {
                Enumeration<InetAddress> addrs = interfs.nextElement().getInetAddresses();
                while (addrs.hasMoreElements()) {
                    String addrString;
                    InetAddress addr = addrs.nextElement();
                    if (!this.isValidAddress(addr, addrString = addr.getHostAddress())) continue;
                    localAddress.add(addr);
                }
            }
        }
        catch (SocketException e) {
            log.error("Connection error.", (Throwable)e);
        }
        return localAddress;
    }

    private boolean isValidAddress(InetAddress addr, String addrString) {
        return addr instanceof Inet6Address && addrString.startsWith("fe80");
    }

    private LinkedHashMap<String, String> parseSsdpResponse(ArrayList<String> responses) {
        LinkedHashMap<String, String> sn2ipMap = new LinkedHashMap<String, String>();
        for (String response : responses) {
            String[] lines;
            String ip = "";
            String sn = "";
            for (String line : lines = response.split("\n")) {
                if (this.isSnDataLine(line)) {
                    sn = this.getSnFromSnDataLine(line);
                }
                if (!this.isIpDataLine(line)) continue;
                ip = this.getIpFromIpDataLine(line);
            }
            if (sn.isEmpty()) continue;
            sn2ipMap.put(sn, ip);
        }
        return sn2ipMap;
    }

    private boolean isSnDataLine(String line) {
        return line.startsWith("SERVER") && (line.contains("SN/") || line.contains("ChassisSN/"));
    }

    private boolean isIpDataLine(String line) {
        return line.startsWith("AL") && line.contains("redfish");
    }

    String getSnFromSnDataLine(String line) {
        String[] strSplit = line.split("\\s+");
        Optional<String> opChassisSn = this.parseSnFromLine(strSplit, "ChassisSN/");
        return opChassisSn.orElseGet(() -> this.parseSnFromLine(strSplit, "SN/").orElse(""));
    }

    private Optional<String> parseSnFromLine(String[] strSplit, String prefix) {
        return Arrays.stream(strSplit).filter(str -> str.startsWith(prefix)).map(str -> str.replaceAll(prefix, "")).findFirst();
    }

    private String getIpFromIpDataLine(String line) {
        String[] strSplit = line.split("/");
        return strSplit[2];
    }

    public boolean isSearching() {
        return this.searching;
    }
}

