/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.distributeddeploy.logic.ssdp;

import com.huawei.ism.tool.distributeddeploy.common.Constants;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Locale;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SsdpSearch {
    private static final Logger LOGGER = LoggerFactory.getLogger(SsdpSearch.class);
    private static final String HTTP_HEAD = "M-SEARCH * HTTP/1.1";
    private static final String HTTP_HEAD_DEST_PORT = "HOST: [FF05::C]:1900";
    private static final String HTTP_HEAD_SSDP = "MAN: \"ssdp:discover\"";
    private static final String HTTP_HEAD_MX = "MX: %s";
    private boolean terminate = false;
    private static final String HTTP_HEAD_ST = "ST: ssdp:all";
    private static int LOCAL_PORT = 64941;
    private static int DEST_PORT = 1900;
    private static int RECEIVE_TIME_OUT = 10000;
    private InetAddress address;

    public SsdpSearch(InetAddress address) {
        this.address = address;
    }

    public ArrayList<String> search() {
        String request = this.makeRequest();
        ArrayList<String> responses = new ArrayList<String>();
        byte[] requestByte = request.getBytes(Charset.defaultCharset());
        InetAddress inetaddress = null;
        try {
            inetaddress = InetAddress.getByName("FF05::C");
        }
        catch (UnknownHostException e) {
            LOGGER.error("Ssdp socket error.", (Throwable)e);
            return responses;
        }
        DatagramPacket sendPacket = new DatagramPacket(requestByte, request.length(), inetaddress, DEST_PORT);
        try (DatagramSocket socket = new DatagramSocket(LOCAL_PORT, this.address);){
            socket.send(sendPacket);
            while (!this.terminate) {
                String response = this.receiveResponseData(socket);
                responses.add(response);
            }
        }
        catch (IOException e) {
            LOGGER.error("Ssdp socket error.");
        }
        return responses;
    }

    private String makeRequest() {
        int mx = 10;
        ArrayList<String> requestList = new ArrayList<String>();
        requestList.add(HTTP_HEAD);
        requestList.add(HTTP_HEAD_DEST_PORT);
        requestList.add(HTTP_HEAD_SSDP);
        requestList.add(String.format(Locale.ENGLISH, HTTP_HEAD_MX, mx));
        requestList.add(HTTP_HEAD_ST);
        return String.join((CharSequence)Constants.LING_SPLIT, requestList) + Constants.LING_SPLIT;
    }

    private String receiveResponseData(DatagramSocket socket) throws IOException {
        DatagramPacket receivePacket = new DatagramPacket(new byte[1024], 1024);
        socket.setSoTimeout(RECEIVE_TIME_OUT);
        socket.receive(receivePacket);
        return new String(receivePacket.getData(), Charset.defaultCharset());
    }

    public boolean isTerminate() {
        return this.terminate;
    }

    public void setTerminate(boolean terminate) {
        this.terminate = terminate;
    }
}

