/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.distributeddeploy.logic.task;

import com.huawei.ism.thread.AsyncExcutor;
import com.huawei.ism.tool.distributeddeploy.common.Constants;
import com.huawei.ism.tool.distributeddeploy.common.Context;
import com.huawei.ism.tool.distributeddeploy.common.ToolConfig;
import com.huawei.ism.tool.distributeddeploy.entity.DeployNode;
import com.huawei.ism.tool.distributeddeploy.enumz.Status;
import com.huawei.ism.tool.distributeddeploy.logic.config.VersionMappingStrategy;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import com.huawei.ism.tool.pyengine.engine.JythonExecuter;
import com.huawei.ism.ui.swing.dialog.ProgressDialog;
import com.huawei.ism.ui.swing.table.IsmTableCell;
import java.awt.Window;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import org.python.core.Py;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BmcIpConfigTask {
    private static final Logger log = LoggerFactory.getLogger(BmcIpConfigTask.class);
    private static final String PASS = "PASS";
    private static final int ERRO_MSG_INDEX = 2;
    private static final String LINE_BREAK = "\n";
    private JythonExecuter jythonExecuter;
    private final Map<String, Object> jythonContext = new ConcurrentHashMap<String, Object>();
    private static final String BMC_IP_CONFIG_PATH = Constants.PYTHON_BUSINESS_SCRIPT_DIR + File.separator + "config_bmc_ip_by_input_ip.py";
    private static final String MODIFY_INDICATOR_STATE_PATH = Constants.PYTHON_BUSINESS_SCRIPT_DIR + File.separator + "modify_indicator_state.py";
    private static final String INITIAL_CONFIG_DETAI_INFO = ResourceUtil.getString((String)"bmcIpFrame.table.config.detail.initial");
    private static final String INITIA_INDICATOR_STATE_DETAI_INFO = ResourceUtil.getString((String)"bmcIpFrame.table.lighting.detail.initial");
    private final DeployNode node;
    private String configDetaiInfo = INITIAL_CONFIG_DETAI_INFO;
    private String indicatorStateDetaiInfo = INITIA_INDICATOR_STATE_DETAI_INFO;
    private Status state = Status.WAITING_EXEC;
    private String nowIp;

    public BmcIpConfigTask(DeployNode node) {
        this.node = node;
        this.nowIp = ToolConfig.getBmcDefaultIpByType(this.node.getDevType(), this.node.getSlotId());
    }

    private void initContext() {
        if (this.jythonExecuter != null) {
            return;
        }
        this.initEnv();
        ArrayList<File> classPathList = new ArrayList<File>();
        classPathList.add(new File(Constants.PYTHON_ROOT_PATH_DIR));
        this.jythonExecuter = new JythonExecuter(classPathList, Py.defaultSystemState);
        this.jythonExecuter.set("py_java_env", this.jythonContext);
    }

    private void initEnv() {
        this.jythonContext.put("devNode", this.node.createDevNodeInfo());
        this.jythonContext.put("deployNode", this.node);
        this.jythonContext.put("mappingStrategy", VersionMappingStrategy.INS.getStrategy().getOrDefault(Context.INS.getCurrentMappingVersion(), new HashMap()));
    }

    public void executeBmcIpConfig(IsmTableCell.MsgTextCell nowIpCell) {
        ProgressDialog progressDialog = new ProgressDialog((Window)Context.INS.getMain(), ResourceUtil.getString((String)"bmcIpFrame.bmc.ip.config.ing"), 220);
        AsyncExcutor.execute((ProgressDialog)progressDialog, (boolean)true, (long)0L, (Callable[])new Callable[]{() -> this.bmcIpConfig(nowIpCell)});
    }

    public void updateNowIp2NodeIp() {
        this.nowIp = this.node.getIp();
    }

    private List<String> bmcIpConfig(IsmTableCell.MsgTextCell nowIpCell) {
        try {
            this.initContext();
            this.jythonExecuter.compileScript(new File(BMC_IP_CONFIG_PATH));
            List ret = this.jythonExecuter.invokeFunction("execute", new Object[]{this});
            nowIpCell.setText(this.nowIp);
            this.state = PASS.equals(ret.get(0).toString()) ? Status.SUCCESSFUL : Status.FAILED;
            this.configDetaiInfo = this.state.getDesc() + LINE_BREAK + ret.get(2).toString();
        }
        catch (Throwable e) {
            log.error("Excute BMC ip config error.", e);
            this.state = Status.FAILED;
            this.configDetaiInfo = this.buildExcuteErroMsg();
        }
        return Collections.emptyList();
    }

    private String buildExcuteErroMsg() {
        return this.state.getDesc() + LINE_BREAK + ResourceUtil.getString((String)"deploy.script.exec.exception");
    }

    public void executeLitLndicatorLED() {
        ProgressDialog progressDialog = new ProgressDialog((Window)Context.INS.getMain(), ResourceUtil.getString((String)"bmcIpFrame.lighting.lit.ing"), 220);
        AsyncExcutor.execute((ProgressDialog)progressDialog, (boolean)true, (long)0L, (Callable[])new Callable[]{() -> this.litLndicatorLED()});
    }

    private List<String> litLndicatorLED() {
        try {
            this.initContext();
            this.jythonExecuter.compileScript(new File(MODIFY_INDICATOR_STATE_PATH));
            List ret = this.jythonExecuter.invokeFunction("lit_indicator_LED", new Object[]{this});
            if (PASS.equals(ret.get(0).toString())) {
                this.state = Status.UNACKNOWLEDGED;
                this.indicatorStateDetaiInfo = INITIA_INDICATOR_STATE_DETAI_INFO;
            } else {
                this.state = Status.LIGHTING_LIT_ERROR;
                this.indicatorStateDetaiInfo = this.state.getDesc() + LINE_BREAK + ret.get(2).toString();
            }
        }
        catch (Throwable e) {
            log.error("Excute lit_indicator_LED error.", e);
            this.state = Status.LIGHTING_LIT_ERROR;
            this.indicatorStateDetaiInfo = this.buildExcuteErroMsg();
        }
        return Collections.emptyList();
    }

    public void exceuteOffLndicatorLED() {
        ProgressDialog progressDialog = new ProgressDialog((Window)Context.INS.getMain(), ResourceUtil.getString((String)"bmcIpFrame.lighting.off.ing"), 220);
        AsyncExcutor.execute((ProgressDialog)progressDialog, (boolean)true, (long)0L, (Callable[])new Callable[]{() -> this.offLndicatorLED()});
    }

    private List<String> offLndicatorLED() {
        try {
            this.initContext();
            this.jythonExecuter.compileScript(new File(MODIFY_INDICATOR_STATE_PATH));
            this.jythonExecuter.invokeFunction("off_indicator_LED", new Object[]{this});
        }
        catch (Throwable e) {
            log.error("Excute off_indicator_LED error.", e);
        }
        return Collections.emptyList();
    }

    public void updateLocationConfirmationResult(Status taskState) {
        this.state = taskState;
        this.indicatorStateDetaiInfo = this.state.getDesc();
    }

    public String getDetaiInfo() {
        return ResourceUtil.getString((String)"bmcIpFrame.task.config.detai.info.head") + this.configDetaiInfo + LINE_BREAK + LINE_BREAK + ResourceUtil.getString((String)"bmcIpFrame.task.indicator.state.detaiInfo.head") + this.indicatorStateDetaiInfo + ResourceUtil.getString((String)"bmcIpFrame.task.period");
    }

    public DeployNode getNode() {
        return this.node;
    }

    public String getConfigDetaiInfo() {
        return this.configDetaiInfo;
    }

    public String getIndicatorStateDetaiInfo() {
        return this.indicatorStateDetaiInfo;
    }

    public Status getState() {
        return this.state;
    }

    public String getNowIp() {
        return this.nowIp;
    }

    public void setNowIp(String nowIp) {
        this.nowIp = nowIp;
    }
}

