/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.distributeddeploy.logic.task;

import com.huawei.ism.tool.distributeddeploy.common.Constants;
import com.huawei.ism.tool.distributeddeploy.common.Context;
import com.huawei.ism.tool.distributeddeploy.entity.DeployNode;
import com.huawei.ism.tool.distributeddeploy.enumz.Status;
import com.huawei.ism.tool.distributeddeploy.fit.common.ObserverManager;
import com.huawei.ism.tool.distributeddeploy.logic.config.PlatformStrategy;
import com.huawei.ism.tool.distributeddeploy.logic.config.ProductStrategy;
import com.huawei.ism.tool.distributeddeploy.logic.config.VersionMappingStrategy;
import com.huawei.ism.tool.distributeddeploy.logic.task.StepTask;
import com.huawei.ism.tool.distributeddeploy.logic.task.Task;
import com.huawei.ism.tool.distributeddeploy.service.connection.ConnectionManager;
import com.huawei.ism.tool.distributeddeploy.service.ui.UIObserver;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import com.huawei.ism.tool.obase.utils.StringUtils;
import com.huawei.ism.tool.pyengine.engine.JythonExecuter;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Observable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.apache.commons.collections4.MapUtils;
import org.python.core.Py;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeployTask
extends Task
implements Runnable,
Comparable<DeployTask> {
    public static final Logger LOGGER = LoggerFactory.getLogger(DeployTask.class);
    private static final String RELEASE_REDFISH_SCRIPT = Constants.PYTHON_BUSINESS_SCRIPT_DIR + File.separator + "release_redfish.py";
    private String threadName = "";
    private int priority = 0;
    private JythonExecuter executor;
    private final Map<String, Object> jythonContext = new ConcurrentHashMap<String, Object>();
    private List<String> fitSteps = new ArrayList<String>();
    private Map<String, Map<String, PlatformStrategy>> strategyMap = new ConcurrentHashMap<String, Map<String, PlatformStrategy>>();
    private final List<String> bmcConfigList = Arrays.asList("bmc_ip_config_by_input", "lit_indicator", "off_indicator");

    public DeployTask(DeployNode node) {
        super(node);
        this.status = Status.WAITING;
    }

    @Override
    public void init() {
        super.init();
    }

    @Override
    public DeployTask prepare() {
        super.prepare();
        this.resetPriority(0);
        this.status = Status.TASK_RUNNING;
        this.initThreadName();
        this.updateUI();
        this.initJythonExecutor();
        this.initEnv();
        return this;
    }

    private void resetPriority(int value) {
        this.priority = value;
    }

    private void initJythonExecutor() {
        ArrayList<File> classPathList = new ArrayList<File>();
        classPathList.add(new File(Constants.PYTHON_ROOT_PATH_DIR));
        this.executor = new JythonExecuter(classPathList, Py.defaultSystemState);
        this.executor.set("py_java_env", this.jythonContext);
    }

    private void initEnv() {
        String mappingVersion = Context.INS.getCurrentMappingVersion();
        if (ObserverManager.getInstance().isDeployHelperServerScene()) {
            mappingVersion = ObserverManager.getInstance().getDeployVersion(this.node.getParentId());
        }
        this.jythonContext.put("devNode", this.node.createDevNodeInfo());
        this.jythonContext.put("deployNode", this.node);
        this.jythonContext.put("armIsoPath", Context.INS.getArmIsoPath());
        this.jythonContext.put("x86IsoPath", Context.INS.getX86IsoPath());
        if (!StringUtils.isNULLStr((String)mappingVersion)) {
            this.putMappingStrategyByScene(mappingVersion);
            this.jythonContext.put("products", ProductStrategy.INS.getProductsByVersion(mappingVersion));
        }
        this.addJsonScene();
    }

    private void addJsonScene() {
        String toolEnv = System.getenv("jsonScene");
        if (!StringUtils.isNULLStr((String)toolEnv) && toolEnv.contains("Distributed Deploy")) {
            this.jythonContext.put("scene", "Distributed Deploy");
        }
    }

    private void putMappingStrategyByScene(String mappingVersion) {
        String nameFromResource = ResourceUtil.getString((String)mappingVersion);
        this.jythonContext.put("mappingVersionDesc", "--".equals(nameFromResource) ? mappingVersion : nameFromResource);
        String version = mappingVersion;
        if (Context.INS.isExpansionScene() && version.equals("nfv.dedicated")) {
            LOGGER.info("expansion scnene put nfv.dedicated.3 mapping version");
            version = version + ".3";
        }
        Map<String, Map<String, PlatformStrategy>> versionMapping = MapUtils.isEmpty(this.strategyMap) ? VersionMappingStrategy.INS.getStrategy() : this.strategyMap;
        this.jythonContext.put("mappingStrategy", versionMapping.getOrDefault(version, Collections.emptyMap()));
        this.jythonContext.put("sourceFile", VersionMappingStrategy.INS.getSourceFile(version));
        this.jythonContext.put("mappingVersion", version);
    }

    public String getPlatformId() {
        return (String)this.jythonContext.get("PlatformId");
    }

    @Override
    public boolean start() {
        try {
            this.isTaskInExecuting = true;
            if (StringUtils.isNULLStr((String)this.getStartDateStr())) {
                this.setStartDateStr(StringUtils.formatDate((Object)new Date(), (String)"yyyy-MM-dd HH:mm:ss"));
            }
            this.prepare().execute().handle();
            boolean bl = true;
            return bl;
        }
        catch (Throwable e) {
            LOGGER.error("Deploy task exec failed.", e);
            boolean bl = false;
            return bl;
        }
        finally {
            this.finish();
            this.isTaskInExecuting = false;
        }
    }

    public List<StepTask> getSubTasks() {
        if (ObserverManager.getInstance().isDeployHelperServerScene()) {
            return this.subTasks.stream().filter(StepTask.class::isInstance).map(StepTask.class::cast).filter(stepTask -> this.fitSteps.contains(stepTask.getStepInfo().getId())).collect(Collectors.toList());
        }
        return this.subTasks;
    }

    public List<StepTask> getSubTaskWithBmcConfig() {
        return this.subTasks.stream().filter(StepTask.class::isInstance).map(StepTask.class::cast).filter(stepTask -> {
            String stepId = stepTask.getStepInfo().getId();
            return this.fitSteps.contains(stepId) || this.bmcConfigList.contains(stepId);
        }).collect(Collectors.toList());
    }

    public List<StepTask> getAllSubTasks() {
        return this.subTasks;
    }

    @Override
    public Task execute() {
        if (this.stopInvoke) {
            return this;
        }
        this.getSubTasks().stream().filter(Task::canExecute).findFirst().ifPresent(this::startStepTask);
        return this;
    }

    private void startStepTask(StepTask firstStep) {
        StepTask stepTask;
        List<StepTask> subTasks = this.getSubTasks();
        for (int i = subTasks.indexOf(firstStep); i < subTasks.size() && this.isStepTaskSuccess(stepTask = subTasks.get(i)); ++i) {
        }
    }

    private boolean isStepTaskSuccess(StepTask stepTask) {
        LOGGER.info("Start to step task [{}]", (Object)stepTask.getStepInfo().getName());
        if (!stepTask.start()) {
            LOGGER.info("Step task [{}] pause to exec.", (Object)stepTask.getStepInfo().getName());
            return false;
        }
        return true;
    }

    @Override
    public Task handle() {
        this.updateProgressUI();
        this.status = this.updateStatus();
        this.updateUI();
        return this;
    }

    private void releaseConn() {
        try {
            ConnectionManager.releaseConnection((DevNode)this.jythonContext.get("devNode"), (String)this.jythonContext.get("PlatformId"));
        }
        catch (Exception e) {
            LOGGER.error("Release connection failed.", (Throwable)e);
        }
    }

    @Override
    public void retry() {
        this.init();
        this.increasePriority();
        StepTask stepTask = this.findPauseStepTask();
        stepTask.retry();
        this.updateUI();
    }

    public void retryAll() {
        this.init();
        this.increasePriority();
        this.getSubTasks().forEach(Task::retry);
        this.updateUI();
    }

    public JythonExecuter getExecutor() {
        return this.executor;
    }

    @Override
    public <T extends Task> T getParent() {
        return null;
    }

    @Override
    public void update(Observable o, Object arg) {
        this.updateWhenItemStatusChange(arg);
        this.updateProgressUI();
    }

    private void updateWhenItemStatusChange(Object arg) {
        if (!UIObserver.UpdateUIStatus.ITEM_STATUS_CHANGE.equals(arg)) {
            return;
        }
        this.status = Status.WAITING_EXEC;
        this.updateUI(arg);
        this.increasePriority();
        if (ObserverManager.getInstance().isDeployHelperServerScene()) {
            return;
        }
        Context.INS.getMain().getDeployTaskManager().startDeployTask(Collections.singletonList(this.node));
    }

    public void increasePriority() {
        this.resetPriority(COMMON_PRIORITY.incrementAndGet());
    }

    public void updateStatus2WaitExec() {
        this.status = Status.WAITING_EXEC;
        super.prepare();
        this.updateUI();
    }

    private Task finish() {
        this.releaseRedfishConnection();
        this.setEndDateStr(StringUtils.formatDate((Object)new Date(), (String)"yyyy-MM-dd HH:mm:ss"));
        this.clearJythonExecutor();
        this.reductionThreadName();
        if (ObserverManager.getInstance().isDeployHelperServerScene()) {
            this.deployHelperServerObserver.finish(this.node);
        } else {
            Context.INS.getUIObs().finish(this.node);
        }
        if (this.fitSteps.contains("lit_indicator") || this.fitSteps.contains("off_indicator") || this.fitSteps.contains("config_bmc_ip_by_input_ip") || this.fitSteps.contains("bmc_ip_config_by_input")) {
            return this;
        }
        this.releaseConn();
        return this;
    }

    private void releaseRedfishConnection() {
        File file = new File(RELEASE_REDFISH_SCRIPT);
        if (!file.exists()) {
            return;
        }
        try {
            this.executor.compileScript(file);
            this.executor.invokeFunction("execute", new Object[]{this});
            LOGGER.info("release redfish success");
        }
        catch (FileNotFoundException fileNotFoundException) {
            LOGGER.error("release redfish failed due to no compile fail");
        }
        catch (Exception e) {
            LOGGER.error("release redfish filed", (Throwable)e);
        }
    }

    private void clearJythonExecutor() {
        this.executor = null;
    }

    public StepTask findRunningSubTask() {
        return this.getSubTasks().stream().filter(Task::isRunning).findFirst().orElse(this.getSubTasks().get(0));
    }

    public StepTask findNowSubTask() {
        return this.getSubTasks().stream().filter(task -> task.isAbnormal() || task.isRunning()).findFirst().orElse(this.getSubTasks().get(0));
    }

    public StepTask findTargetSubTask(String stepId) {
        return this.getSubTasks().stream().filter(subTask -> subTask.getStepInfo().getId().equals(stepId)).findFirst().orElse(this.getSubTasks().get(0));
    }

    public StepTask findPauseStepTask() {
        return this.getSubTasks().stream().filter(Task::isAbnormal).findFirst().orElse(this.getSubTasks().get(0));
    }

    private void initThreadName() {
        this.threadName = Thread.currentThread().getName();
        Thread.currentThread().setName("DeployTask_" + this.node.getIp());
    }

    private void reductionThreadName() {
        Thread.currentThread().setName(this.threadName);
    }

    public void addStepTask(StepTask stepTask) {
        this.getAllSubTasks().add(stepTask);
    }

    @Override
    public void run() {
        this.start();
    }

    @Override
    public int compareTo(DeployTask otherTask) {
        int level = this.priority - otherTask.priority;
        if (level != 0) {
            return level;
        }
        return 0 - this.getNode().compareTo(otherTask.getNode());
    }

    public Map<String, Object> getJythonContext() {
        return this.jythonContext;
    }

    public void setFitSteps(List<String> fitSteps) {
        this.fitSteps = fitSteps;
    }

    public void setStrategyMap(Map<String, Map<String, PlatformStrategy>> strategyMap) {
        this.strategyMap = strategyMap;
    }
}

