/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.distributeddeploy.logic.task;

import com.huawei.ism.tool.base.utils.StringUtils;
import com.huawei.ism.tool.distributeddeploy.common.Constants;
import com.huawei.ism.tool.distributeddeploy.common.Context;
import com.huawei.ism.tool.distributeddeploy.entity.ItemInfo;
import com.huawei.ism.tool.distributeddeploy.entity.Product;
import com.huawei.ism.tool.distributeddeploy.entity.StepInfo;
import com.huawei.ism.tool.distributeddeploy.enumz.Status;
import com.huawei.ism.tool.distributeddeploy.fit.common.ObserverManager;
import com.huawei.ism.tool.distributeddeploy.logic.config.ProductStrategy;
import com.huawei.ism.tool.distributeddeploy.logic.task.StepTask;
import com.huawei.ism.tool.distributeddeploy.logic.task.Task;
import com.huawei.ism.tool.distributeddeploy.service.ignore.IgnoreService;
import com.huawei.ism.tool.distributeddeploy.service.report.HtmlResUtils;
import com.huawei.ism.tool.distributeddeploy.service.ui.UIObserver;
import com.huawei.ism.tool.framework.platform.exception.SignException;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import com.huawei.ism.tool.pyengine.engine.JythonExecuter;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Observable;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ItemTask
extends Task {
    private static final Logger LOGGER = LoggerFactory.getLogger(ItemTask.class);
    private StringBuffer originalInfo = new StringBuffer();
    private StringBuilder singleItemOriginalInfo = new StringBuilder();
    private String errMsg = "";
    private ItemInfo itemInfo;
    private StepTask parentTask;
    private boolean needAutoRetry = false;
    private int autoRetriedTimes = 0;
    private String nowIp;
    private final Map<String, Object> jythonContext;
    private Object param;
    private boolean manualIgnored = false;

    public ItemTask(StepTask stepTask, ItemInfo info) {
        super(stepTask.getNode());
        this.itemInfo = info;
        this.parentTask = stepTask;
        this.jythonContext = this.parentTask.getParent().getJythonContext();
    }

    public void setNowIp() {
        this.nowIp = this.node.getNowBmcIp();
    }

    @Override
    protected void init() {
        super.init();
        this.startDateStr = "";
        this.endDateStr = "";
        this.originalInfo = new StringBuffer();
        this.singleItemOriginalInfo = new StringBuilder();
        this.errMsg = "";
        this.stopInvoke = false;
        this.manualIgnored = false;
    }

    @Override
    public void update(Observable o, Object arg) {
        this.notifyObservers(this.node);
    }

    public void updateNowIp2NodeIp() {
        this.nowIp = this.node.getIp();
        this.node.setNowBmcIp(this.nowIp);
    }

    @Override
    public Task prepare() {
        super.prepare();
        this.getStartDate();
        this.status = Status.ITEM_RUNNING;
        this.updateUI();
        this.initEnv();
        this.compileScript();
        return this;
    }

    private void initEnv() {
        StepInfo.Item item = this.itemInfo.getItem();
        if (item == null || !item.isCheckSupportAlone()) {
            return;
        }
        List supportUids = item.getInvolves().stream().map(involve -> this.getProductsByInvolve((String)involve)).filter(Optional::isPresent).map(Optional::get).map(Product::getDevType2UniqueIds).map(Map::values).flatMap(Collection::stream).flatMap(Collection::stream).distinct().collect(Collectors.toList());
        this.jythonContext.put("support_uids", supportUids);
    }

    private Optional<Product> getProductsByInvolve(String involve) {
        int splitIndex = involve.lastIndexOf(".");
        String productVersion = involve.substring(0, splitIndex);
        String productPlatform = involve.substring(splitIndex + 1);
        Map<String, Product> productsByVersion = ProductStrategy.INS.getProductsByVersion(productVersion);
        if (productsByVersion == null || productsByVersion.isEmpty()) {
            return Optional.empty();
        }
        return Optional.ofNullable(productsByVersion.get(productPlatform));
    }

    private void compileScript() {
        try {
            this.getExecutor().compileScript(new File(this.itemInfo.getScriptPath()));
        }
        catch (FileNotFoundException e) {
            LOGGER.error("Can not find script for {} .", (Object)this.itemInfo.getId());
            this.buildCommonErrorInfo();
        }
        catch (SignException e) {
            LOGGER.error("Item {} sign check not pass.", (Object)this.itemInfo.getId());
            this.buildCommonErrorInfo();
        }
        catch (Exception e) {
            LOGGER.error("item {} compile failed", (Object)this.itemInfo.getId(), (Object)e);
            this.buildCommonErrorInfo();
        }
    }

    @Override
    public Task execute() {
        LOGGER.info("start itemTask [{}].", (Object)this.itemInfo.getName());
        if (this.stopInvoke) {
            return this;
        }
        this.setParam();
        try {
            List ret = this.getExecutor().invokeFunction("execute", new Object[]{this});
            Status status = Status.valueOf(ret.get(0).toString());
            while (this.isAbnormal(status) && this.needAutoRetry && this.autoRetriedTimes < this.itemInfo.getFailedRetryTimes()) {
                LOGGER.info("Auto retry [{}]", (Object)this.itemInfo.getName());
                ++this.autoRetriedTimes;
                this.needAutoRetry = false;
                ret = this.getExecutor().invokeFunction("execute", new Object[]{this});
            }
            this.handleRet(ret);
        }
        catch (Throwable e) {
            LOGGER.error("Item task {} invoke failed.", (Object)this.itemInfo.getId(), (Object)e);
            this.updateUnknownErrorUI();
        }
        finally {
            this.progress = 100;
            this.setEndDateStr(StringUtils.formatDate(new Date(), "yyyy-MM-dd HH:mm:ss"));
        }
        return this;
    }

    private void setParam() {
        this.param = this.getParentTask().getParent().getNode().getConfigParam();
    }

    public void openAutoRetry() {
        this.needAutoRetry = true;
    }

    public void openManualIgnored() {
        this.manualIgnored = true;
    }

    public boolean isManualIgnored() {
        return this.isAbnormal() && this.manualIgnored;
    }

    private void handleRet(List<Object> ret) {
        this.status = this.transStatus2ExactingStatus(Status.valueOf(ret.get(0).toString()));
        this.errMsg = ret.get(2).toString();
        String originalInfoStr = ret.get(1).toString();
        if (ItemInfo.Type.SINGLE.equals((Object)this.getType())) {
            this.updateSingleMsg(this.errMsg);
        }
        this.updateMsg(originalInfoStr);
        if (this.isAbnormal()) {
            IgnoreService.writeAbnormalItemInfo(this);
        }
    }

    private Status transStatus2ExactingStatus(Status status) {
        if (this.isNormal(status)) {
            return this.getNormalStatus();
        }
        if (this.isAbnormal()) {
            return this.getAbnormalStatus();
        }
        return status;
    }

    private void updateUnknownErrorUI() {
        this.stopInvoke = true;
        this.status = Status.NO_CHECK;
        this.originalInfo.append(ResourceUtil.getString((String)"deploy.script.exec.exception"));
        this.updateUI();
    }

    @Override
    public Task handle() {
        LOGGER.info("handle task [{}].", (Object)this.itemInfo.getName());
        if (this.stopInvoke) {
            return this;
        }
        this.updateConfirmStatus();
        this.updateUI();
        return this;
    }

    private void updateConfirmStatus() {
        if ("lit_indicator".equals(this.getId()) && Status.NOT_PASS.equals((Object)this.status)) {
            this.getNode().setIndicatorStatus(Status.UNACKNOWLEDGED);
        }
    }

    @Override
    public boolean next() {
        return this.itemInfo.isFailedContinue() || this.isNormal();
    }

    @Override
    public List<? extends Task> getSubTasks() {
        return this.subTasks;
    }

    @Override
    public Status getNormalStatus() {
        return this.itemInfo.isCheckItem() ? Status.PASS : Status.SUCCESSFUL;
    }

    @Override
    public Status getAbnormalStatus() {
        return this.itemInfo.isCheckItem() ? Status.NOT_PASS : Status.FAILED;
    }

    public boolean canJudgeInvolveAfter() {
        return this.itemInfo.canJudgeInvolveAfter();
    }

    public void refreshInvolveItemTaskInfo() {
        String platformId = this.getParent().getParent().getPlatformId();
        String mappingVersion = Context.INS.getCurrentMappingVersion();
        if (ObserverManager.getInstance().isDeployHelperServerScene()) {
            mappingVersion = ObserverManager.getInstance().getDeployVersion(this.node.getParentId());
        }
        if (!StringUtils.isNULLStr(platformId) && !this.itemInfo.isInvolve(mappingVersion + "." + platformId)) {
            LOGGER.info("Not involve item task [{}].", (Object)this.itemInfo.getName());
            this.status = Status.NOT_INVOLVE;
            this.progress = 100;
            this.updateUI();
        }
    }

    @Override
    public void retry() {
        this.init();
    }

    public StepTask getParent() {
        return this.parentTask;
    }

    public void retryDeploySingle() {
        this.init();
        this.getParentTask().retrySingle();
        this.updateUI((Object)UIObserver.UpdateUIStatus.ITEM_STATUS_CHANGE);
    }

    public ItemInfo.Type getType() {
        return this.itemInfo.getType();
    }

    private void buildCommonErrorInfo() {
        this.stopInvoke = true;
        this.status = Status.NO_CHECK;
        this.originalInfo.append(ResourceUtil.getString((String)"deploy.script.complied.failed"));
        this.updateUI();
    }

    public String getName() {
        return this.itemInfo.getName();
    }

    public String getStartDate() {
        if (!StringUtils.isNULLStr(this.startDateStr)) {
            return this.startDateStr;
        }
        this.startDateStr = StringUtils.formatDate(new Date(), "yyyy-MM-dd HH:mm:ss");
        return this.startDateStr;
    }

    public StepTask getParentTask() {
        return this.parentTask;
    }

    public String getOriginalInfo() {
        return this.originalInfo.toString();
    }

    public String getSingleOriginalInfo() {
        return this.singleItemOriginalInfo.toString();
    }

    public void updateProgress(int pro, String info) {
        this.updateSingleMsg(info);
        this.updateProgress(pro);
    }

    public void updateProgress(int pro) {
        if (pro < this.progress) {
            LOGGER.warn("Invalid pro now {} old {}", (Object)pro, (Object)this.progress);
        }
        this.progress = Math.max(this.progress, pro);
        this.setChanged();
        this.notifyObservers(this.node);
    }

    private void updateMsg(String info) {
        if (StringUtils.isNULLStr(info)) {
            return;
        }
        this.originalInfo.append(info);
    }

    private void updateSingleMsg(String info) {
        if (StringUtils.isNULLStr(info)) {
            return;
        }
        String addTimeInfo = StringUtils.formatDate(new Date(), "yyyy-MM-dd HH:mm:ss") + " " + info + Constants.LING_SPLIT;
        this.updateMsg(addTimeInfo);
        this.singleItemOriginalInfo.append(addTimeInfo);
    }

    private JythonExecuter getExecutor() {
        return this.getParentTask().getExecutor();
    }

    public void ignoredResult() {
        this.status = Status.IGNORED;
        this.progress = 100;
        this.updateUI((Object)UIObserver.UpdateUIStatus.ITEM_STATUS_CHANGE);
    }

    public void changeResult(Status status) {
        this.status = status;
        this.progress = 100;
        this.updateUI((Object)UIObserver.UpdateUIStatus.ITEM_STATUS_CHANGE);
    }

    public String getErrMsg() {
        return this.errMsg;
    }

    public String getRetMsg() {
        return this.status.getDesc() + System.lineSeparator() + System.lineSeparator() + this.errMsg;
    }

    public String getHtmlRetMsg() {
        return HtmlResUtils.handelHtmlContent(this.getRetMsg());
    }

    public String getHtmlOriginalInfo() {
        return HtmlResUtils.handelHtmlContent(this.getOriginalInfo());
    }

    public String getId() {
        return this.itemInfo.getId();
    }

    public String getHtmlStatus() {
        if (this.isNormal()) {
            return "finished";
        }
        return "notFinished";
    }

    public ItemInfo getItemInfo() {
        return this.itemInfo;
    }

    public String getNowIp() {
        return this.nowIp;
    }

    public Map<String, Object> getJythonContext() {
        return this.jythonContext;
    }

    public Object getParam() {
        return this.param;
    }
}

