/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.distributeddeploy.logic.task;

import com.huawei.ism.tool.distributeddeploy.common.Context;
import com.huawei.ism.tool.distributeddeploy.entity.StepInfo;
import com.huawei.ism.tool.distributeddeploy.enumz.Status;
import com.huawei.ism.tool.distributeddeploy.logic.task.DeployTask;
import com.huawei.ism.tool.distributeddeploy.logic.task.ItemTask;
import com.huawei.ism.tool.distributeddeploy.logic.task.Task;
import com.huawei.ism.tool.distributeddeploy.service.ui.IUIObserver;
import com.huawei.ism.tool.distributeddeploy.service.ui.UIObserver;
import com.huawei.ism.tool.distributeddeploy.ui.card.Card;
import com.huawei.ism.tool.pyengine.engine.JythonExecuter;
import java.util.List;
import java.util.Observable;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StepTask
extends Task {
    private static final Logger log = LoggerFactory.getLogger(StepTask.class);
    private final StepInfo stepInfo;
    private final DeployTask parentTask;

    public StepTask(DeployTask parentTask, StepInfo type) {
        super(parentTask.getNode());
        this.stepInfo = type;
        this.parentTask = parentTask;
    }

    @Override
    public void update(Observable o, Object arg) {
        this.updateWhenItemStatusChange(arg);
        this.updateProgressUI();
    }

    void updateWhenItemStatusChange(Object arg) {
        if (!UIObserver.UpdateUIStatus.ITEM_STATUS_CHANGE.equals(arg)) {
            return;
        }
        this.status = Status.WAITING_EXEC;
        this.updateUI(arg);
    }

    public StepInfo getStepInfo() {
        return this.stepInfo;
    }

    @Override
    public Task prepare() {
        super.prepare();
        this.status = Status.TASK_RUNNING;
        this.updateUI();
        return this;
    }

    @Override
    public Task execute() {
        if (this.stopInvoke) {
            return this;
        }
        List<ItemTask> subTasks = this.getSubTasks();
        for (Task task2 : subTasks) {
            if (task2.isFinish() && !task2.next()) {
                return this;
            }
            if (!task2.canExecute()) continue;
            if (!task2.start()) {
                log.info("ItemTask {} terminator step", (Object)((ItemTask)task2).getId());
                return this;
            }
            if (!((ItemTask)task2).canJudgeInvolveAfter()) continue;
            this.subTasks.forEach(task -> ((ItemTask)task).refreshInvolveItemTaskInfo());
            return this.execute();
        }
        return this;
    }

    @Override
    public Task handle() {
        this.status = this.updateStatus();
        this.updateUI();
        return this;
    }

    @Override
    public boolean next() {
        return this.subTasks.stream().allMatch(Task::isNormal);
    }

    public List<ItemTask> getSubTasks() {
        if (Context.INS.getCurrentScene() == Card.CardScene.MATCH_CHECK) {
            Set<String> strategy = Context.INS.getMatchCheckStrategy();
            return this.subTasks.stream().filter(task -> !Status.NOT_INVOLVE.equals((Object)task.getStatus())).filter(task -> {
                String supportScene = task.getItemInfo().getItem().getSupportScene();
                return strategy.stream().anyMatch(supportScene::contains);
            }).collect(Collectors.toList());
        }
        return this.subTasks.stream().filter(task -> !Status.NOT_INVOLVE.equals((Object)task.getStatus())).collect(Collectors.toList());
    }

    public List<ItemTask> getNotInvolveSubTasks() {
        return this.subTasks.stream().filter(task -> Status.NOT_INVOLVE.equals((Object)task.getStatus())).collect(Collectors.toList());
    }

    @Override
    public boolean isFinish() {
        return !Status.WAITING_EXEC.equals((Object)this.status) && !Status.TASK_RUNNING.equals((Object)this.status);
    }

    @Override
    public void retry() {
        super.init();
        this.getSubTasks().forEach(Task::retry);
        this.updateUI();
    }

    public DeployTask getParent() {
        return this.parentTask;
    }

    public JythonExecuter getExecutor() {
        return this.getParent().getExecutor();
    }

    public void initStepTask(IUIObserver obs) {
        this.init();
        this.setDeployHelperServerObserver(obs);
        this.getSubTasks().forEach(itemTask -> {
            itemTask.init();
            itemTask.setDeployHelperServerObserver(obs);
            itemTask.setNowIp();
            itemTask.updateUI();
        });
        this.updateUI();
    }
}

