/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.distributeddeploy.logic.task;

import com.huawei.ism.tool.distributeddeploy.common.Context;
import com.huawei.ism.tool.distributeddeploy.entity.DeployNode;
import com.huawei.ism.tool.distributeddeploy.enumz.Status;
import com.huawei.ism.tool.distributeddeploy.fit.common.ObserverManager;
import com.huawei.ism.tool.distributeddeploy.logic.task.DeployTask;
import com.huawei.ism.tool.distributeddeploy.service.ui.IUIObserver;
import com.huawei.ism.tool.distributeddeploy.service.ui.UIObserver;
import com.huawei.ism.tool.distributeddeploy.ui.card.Card;
import com.huawei.ism.tool.obase.utils.StringUtils;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Task
extends Observable
implements Observer {
    private static final Logger LOGGER = LoggerFactory.getLogger(Task.class);
    protected Status status = Status.WAITING_EXEC;
    protected DeployNode node;
    protected IUIObserver deployHelperServerObserver;
    protected String startDateStr;
    protected String endDateStr;
    protected boolean isTaskInExecuting;
    int progress = 0;
    List<? extends Task> subTasks = new ArrayList<Task>();
    boolean stopInvoke = false;
    protected static final AtomicInteger COMMON_PRIORITY = new AtomicInteger();

    public DeployNode getNode() {
        return this.node;
    }

    Task(DeployNode node) {
        this.node = node;
    }

    public Task(DeployNode node, IUIObserver deployHelperServerObserver) {
        this(node);
        this.deployHelperServerObserver = deployHelperServerObserver;
    }

    protected void init() {
        this.progress = 0;
        this.status = Status.WAITING_EXEC;
        this.endDateStr = "";
    }

    public abstract Task execute();

    public Task prepare() {
        if (ObserverManager.getInstance().isDeployHelperServerScene()) {
            this.addObserver(this.deployHelperServerObserver);
        } else {
            this.addObserver(Context.INS.getUIObs());
        }
        this.getSubTasks().forEach(task -> task.addObserver(this));
        return this;
    }

    public abstract Task handle();

    public boolean next() {
        return Stream.of(Status.PASS, Status.SUCCESSFUL, Status.IGNORED).anyMatch(this.status::equals);
    }

    protected int calcProgress() {
        AtomicInteger totalProgress = new AtomicInteger();
        this.getSubTasks().forEach(task -> totalProgress.getAndAdd(task.progress));
        return totalProgress.get() / this.getSubTasks().size();
    }

    public void setSubTasks(List<? extends Task> subTasks) {
        this.subTasks = subTasks;
    }

    public int getProgress() {
        return this.progress;
    }

    public Status getStatus() {
        return this.status;
    }

    public boolean start() {
        try {
            this.isTaskInExecuting = true;
            boolean bl = this.prepare().execute().handle().next();
            return bl;
        }
        catch (Throwable e) {
            LOGGER.error("Deploy task exec failed.", e);
            boolean bl = false;
            return bl;
        }
        finally {
            this.isTaskInExecuting = false;
        }
    }

    public abstract List<? extends Task> getSubTasks();

    boolean canExecute() {
        return Status.WAITING_EXEC.equals((Object)this.status) || Status.WAITING.equals((Object)this.status);
    }

    protected boolean isNormal(Status status) {
        return Stream.of(Status.PASS, Status.IGNORED, Status.NOT_INVOLVE, Status.SUCCESSFUL).anyMatch(status::equals);
    }

    public boolean isNormal() {
        return this.isNormal(this.status);
    }

    public boolean isFinish() {
        return Status.WAITING_EXEC != this.status && Status.ITEM_RUNNING != this.status && Status.TASK_RUNNING != this.status;
    }

    public boolean isAbnormal() {
        return this.isAbnormal(this.status);
    }

    protected boolean isAbnormal(Status status) {
        return Stream.of(Status.NOT_PASS, Status.PAUSE, Status.FAILED, Status.NO_CHECK).anyMatch(status::equals);
    }

    boolean isRunning() {
        return Status.ITEM_RUNNING == this.status || Status.TASK_RUNNING == this.status;
    }

    public boolean isAlreadyStarted() {
        return this.status != Status.WAITING && this.status != Status.WAITING_EXEC;
    }

    void updateUI(Object arg) {
        this.setChanged();
        this.notifyObservers(arg);
    }

    public void updateUI() {
        this.updateUI((Object)UIObserver.UpdateUIStatus.DEFAULT);
    }

    void updateProgressUI() {
        int oldPro = this.progress;
        int newPro = this.calcProgress();
        if (oldPro == newPro) {
            return;
        }
        this.progress = newPro;
        this.updateUI();
    }

    public Status getNormalStatus() {
        return Context.INS.getCurrentScene() == Card.CardScene.MATCH_CHECK ? Status.PASS : Status.SUCCESSFUL;
    }

    public Status getAbnormalStatus() {
        if (Context.INS.getCurrentScene() == Card.CardScene.MATCH_CHECK) {
            return Status.NOT_PASS;
        }
        if (this.getSubTasks().stream().allMatch(Task::isFinish)) {
            return Status.FAILED;
        }
        return Status.PAUSE;
    }

    Status updateStatus() {
        if (this.getSubTasks().stream().allMatch(Task::isNormal)) {
            return this.getNormalStatus();
        }
        if (this.getSubTasks().stream().anyMatch(Task::isAbnormal)) {
            return this.getAbnormalStatus();
        }
        if (this.getSubTasks().stream().anyMatch(Task::isRunning)) {
            if (this instanceof DeployTask) {
                return Status.TASK_RUNNING;
            }
            return Status.ITEM_RUNNING;
        }
        return Status.WAITING_EXEC;
    }

    abstract void retry();

    void retrySingle() {
        this.status = Status.WAITING_EXEC;
        Object parent = this.getParent();
        if (null != parent) {
            ((Task)parent).retrySingle();
        }
    }

    public abstract <T extends Task> T getParent();

    public String getTimeTaken() {
        if (StringUtils.isNULLStr((String)this.startDateStr) || StringUtils.isNULLStr((String)this.endDateStr)) {
            return "--";
        }
        try {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            Date endTime = sdf.parse(this.endDateStr);
            Date startTime = sdf.parse(this.startDateStr);
            return StringUtils.millls2FormatString((long)(endTime.getTime() - startTime.getTime()));
        }
        catch (ParseException e) {
            LOGGER.error("parse time failed", (Throwable)e);
            return "--";
        }
    }

    public void setStatus(Status status) {
        this.status = status;
    }

    public IUIObserver getDeployHelperServerObserver() {
        return this.deployHelperServerObserver;
    }

    public void setDeployHelperServerObserver(IUIObserver deployHelperServerObserver) {
        this.deployHelperServerObserver = deployHelperServerObserver;
    }

    public String getStartDateStr() {
        return this.startDateStr;
    }

    public void setStartDateStr(String startDateStr) {
        this.startDateStr = startDateStr;
    }

    public String getEndDateStr() {
        return this.endDateStr;
    }

    public void setEndDateStr(String endDateStr) {
        this.endDateStr = endDateStr;
    }

    public boolean isTaskInExecuting() {
        return this.isTaskInExecuting;
    }
}

