/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.distributeddeploy.logic.utils;

import java.io.IOException;
import java.net.InetAddress;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class IpUtils {
    private static final Logger log = LoggerFactory.getLogger(IpUtils.class);
    private static final int PING_DEFAULT_TIMEOUT_MS = 1000;

    public static boolean isReachable(String ip) {
        return IpUtils.isReachable(ip, 1000);
    }

    public static boolean isReachable(String ip, int timeoutMs) {
        try {
            if (StringUtils.isEmpty((CharSequence)ip)) {
                return false;
            }
            return InetAddress.getByName(ip).isReachable(timeoutMs);
        }
        catch (IOException e) {
            log.error("check ip {} reachable failed.", (Object)ip);
            return false;
        }
    }

    private IpUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

