/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.distributeddeploy.service.connection;

import com.huawei.ism.tool.distributeddeploy.logic.config.Platform;
import com.huawei.ism.tool.distributeddeploy.logic.config.SshJudge;
import com.huawei.ism.tool.distributeddeploy.service.connection.IPMIConnection;
import com.huawei.ism.tool.obase.connection.ICliConnection;
import com.huawei.ism.tool.obase.connection.ISshJudge;
import com.huawei.ism.tool.obase.connection.SshConnectionManager;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.exception.ToolException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectionManager {
    private static final String LINUX_PROCESS_KILL_CMD = "3";
    private static final int EXIT_TIME_OUT = 30;
    private static final Logger LOGGER = LoggerFactory.getLogger(ConnectionManager.class);
    private static final Map<String, ICliConnection> POOL = new ConcurrentHashMap<String, ICliConnection>();

    private static String getKey(DevNode node) {
        return node.getDeviceSerialNumber() + node.getIp();
    }

    public static ICliConnection getSshConnection(DevNode devNode, ISshJudge sshJudge, String platformId) throws ToolException {
        LOGGER.info("Build connection for {} platform id {} ", (Object)devNode.getIp(), (Object)platformId);
        String key = ConnectionManager.getKey(devNode);
        if (StringUtils.equalsAny((CharSequence)platformId, (CharSequence[])new CharSequence[]{Platform.TAISHAN_V1.getId(), Platform.HG_X86_64.getId()})) {
            if (POOL.containsKey(key)) {
                return POOL.get(key);
            }
            IPMIConnection connection = new IPMIConnection(devNode.getIp(), devNode.getLoginUser(), devNode.getPort(), devNode.getPriKey(), sshJudge);
            connection.setdNode(devNode);
            connection.connect();
            POOL.put(ConnectionManager.getKey(devNode), (ICliConnection)connection);
            return connection;
        }
        ICliConnection sshConnection = SshConnectionManager.getSshConnection((DevNode)devNode, (ISshJudge)sshJudge);
        POOL.put(key, sshConnection);
        return sshConnection;
    }

    public static void releaseConnection(DevNode devNode) {
        ConnectionManager.releaseConnection(devNode, "");
    }

    public static void releaseConnection(DevNode devNode, String platformId) {
        LOGGER.info("Release connection for {} platform id {} ", (Object)devNode.getIp(), (Object)platformId);
        String key = ConnectionManager.getKey(devNode);
        if (!POOL.containsKey(key)) {
            return;
        }
        if (StringUtils.equalsAny((CharSequence)platformId, (CharSequence[])new CharSequence[]{Platform.TAISHAN_V1.getId(), Platform.HG_X86_64.getId()})) {
            ICliConnection connection = POOL.get(key);
            ConnectionManager.forceInterruptProcess(connection);
            connection.close();
        } else {
            try {
                ConnectionManager.forceInterruptProcess(SshConnectionManager.getSshConnection((DevNode)devNode, (ISshJudge)SshJudge.INS));
            }
            catch (ToolException e) {
                LOGGER.info("getSshConnection failed", (Throwable)e);
            }
            SshConnectionManager.releaseConnection((DevNode)devNode);
        }
        POOL.remove(key);
    }

    public static void releaseConnection(ICliConnection connection, String platformId) {
        ConnectionManager.forceInterruptProcess(connection);
        if (Platform.TAISHAN_V1.getId().equals(platformId)) {
            ConnectionManager.releaseConnection(((IPMIConnection)connection).getdNode());
        } else {
            SshConnectionManager.releaseConnection((ICliConnection)connection);
        }
    }

    private static void forceInterruptProcess(ICliConnection connection) {
        try {
            if (connection == null) {
                return;
            }
            if (connection instanceof IPMIConnection) {
                LOGGER.info("ipmitool force exit");
                ((IPMIConnection)connection).getMonitor().close();
                return;
            }
            connection.execCmdWithTimout(LINUX_PROCESS_KILL_CMD, 30);
        }
        catch (ToolException e) {
            LOGGER.info("force Interrupt Process failed", (Throwable)e);
        }
    }

    public static void releaseConnection(ICliConnection connection) {
        ConnectionManager.releaseConnection(connection, "");
    }
}

