/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.distributeddeploy.service.connection;

import com.huawei.ism.tool.distributeddeploy.service.connection.IPMIMonitor;
import com.huawei.ism.tool.obase.connection.ISshJudge;
import com.huawei.ism.tool.obase.connection.SshConnection;
import com.huawei.ism.tool.obase.entity.PriKeyInfo;
import com.huawei.ism.tool.obase.entity.User;
import com.huawei.ism.tool.obase.exception.ToolException;
import java.io.IOException;
import java.util.Locale;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IPMIConnection
extends SshConnection {
    private static final Logger LOGGER = LoggerFactory.getLogger(IPMIConnection.class);

    IPMIConnection(String sshHostname, User user, int sshHostPort, PriKeyInfo priKeyInfo, ISshJudge sshJudge) {
        super(sshHostname, user, sshHostPort, priKeyInfo, sshJudge);
    }

    public synchronized void connect() throws ToolException {
        this.monitor = new IPMIMonitor(this.getdNode());
        this.monitor.setName(String.format(Locale.ENGLISH, "session monitor for %s", this.getdNode().getIp()));
        LOGGER.info("Start to connect to {}", (Object)this.getdNode().getIp());
        try {
            this.monitor.startShell();
            this.monitor.start();
        }
        catch (IOException e) {
            LOGGER.error("Init connection for {} error. ", (Object)this.getdNode().getIp(), (Object)e);
            this.connected = false;
            throw new ToolException("Init connection error", false);
        }
        this.connected = true;
    }

    public void close() {
        LOGGER.info("close connection for {}", (Object)this.getdNode().getIp());
        this.connected = false;
        this.monitor.close();
    }
}

