/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.distributeddeploy.service.connection;

import com.huawei.fitframework.core.common.util.ThreadUtils;
import com.huawei.ism.tool.distributeddeploy.common.Constants;
import com.huawei.ism.tool.obase.connection.support.CmdRequestBean;
import com.huawei.ism.tool.obase.connection.support.ConnUtils;
import com.huawei.ism.tool.obase.connection.support.SessionMonitor;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.exception.ToolException;
import com.huawei.ism.tool.obase.utils.OSCmdUtils;
import com.huawei.ism.tool.obase.utils.StreamUtils;
import com.huawei.ism.tool.obase.utils.StringUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.Locale;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IPMIMonitor
extends SessionMonitor {
    private static final Logger log = LoggerFactory.getLogger(IPMIMonitor.class);
    private static final String LOGIN_CMD = "\"%s\" -I lanplus -H \"%s\" -U \"%s\" -P \"%s\" -C 17 sol activate";
    private static final String LOGOUT_CMD = "\"%s\" -I lanplus -H \"%s\" -U \"%s\" -P \"%s\" -C 17 sol deactivate";
    private static final String IPMI_CMD = "\"%s\" -I lanplus -H \"%s\" -U \"%s\" -P \"%s\" -C 17 %s";
    private Process ipmiTool;
    private DevNode node;
    private InputStream stdout;
    private InputStream stderr;
    private OutputStream stdin;

    public IPMIMonitor(DevNode node) {
        this.node = node;
    }

    public void startShell() throws IOException {
        block3: {
            String loginCmd = String.format(Locale.ENGLISH, LOGIN_CMD, Constants.UTIL_IPMI_PATH, this.node.getIp(), this.node.getLoginUser().getUserName(), this.node.getLoginUser().getPassword());
            this.ipmiTool = Runtime.getRuntime().exec(loginCmd);
            int retryTimes = 5;
            do {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException ignored) {
                    log.error("Sleep Waiting Exception", (Throwable)ignored);
                }
                if (this.ipmiTool.isAlive()) break block3;
            } while (--retryTimes != 0);
            throw new IOException("ipmi login failed");
        }
        this.stdout = this.ipmiTool.getInputStream();
        this.stderr = this.ipmiTool.getErrorStream();
        this.stdin = this.ipmiTool.getOutputStream();
        this.cmdRequest = new CmdRequestBean();
    }

    public void sendCmd(String cmd) throws IOException {
        this.stdin.write(cmd.getBytes(Charset.defaultCharset()));
        this.stdin.flush();
    }

    public void sendCmd(int cmd) throws IOException {
        this.stdin.write(cmd);
        this.stdin.flush();
    }

    public String getCurrentStdOut(boolean isFlush) {
        try {
            this.cmdRequest.appendStdout(this.getStdString(this.stdout));
        }
        catch (IOException e) {
            log.error("get standard out error.", (Throwable)e);
        }
        return this.cmdRequest.getStdoutResult(isFlush);
    }

    public void close() {
        this.active = false;
        StreamUtils.closeStream((OutputStream)this.stdin, null);
        StreamUtils.closeStream(null, (InputStream)this.stdout);
        StreamUtils.closeStream(null, (InputStream)this.stderr);
        String logoutCmd = String.format(Locale.ENGLISH, LOGOUT_CMD, Constants.UTIL_IPMI_PATH, this.node.getIp(), this.node.getLoginUser().getUserName(), this.node.getLoginUser().getPassword());
        OSCmdUtils.executeCmd((String)logoutCmd);
        if (null != this.ipmiTool) {
            this.ipmiTool.destroy();
            this.ipmiTool = null;
        }
    }

    public void run() {
        while (this.active) {
            if (!this.active || this.ipmiTool == null || !this.ipmiTool.isAlive()) {
                return;
            }
            try {
                this.consumeStdOutAndErr();
            }
            catch (IOException e) {
                log.error("<ssh>read stdout / stderr failed...", (Throwable)e);
            }
            ConnUtils.sleep((int)10);
        }
    }

    protected void consumeStdOutAndErr() throws IOException {
        this.cmdRequest.appendStdout(this.getStdString(this.stdout));
        this.cmdRequest.appendStderr(this.getStdString(this.stderr));
    }

    protected synchronized byte[] getStdString(InputStream inputStream) throws IOException {
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        while (inputStream.available() > 0) {
            int availableLen = inputStream.available();
            byte[] buff = new byte[availableLen];
            int len = inputStream.read(buff, 0, availableLen);
            buffer.write(buff, 0, len);
            ConnUtils.sleep((int)50);
        }
        return buffer.toByteArray();
    }

    public static String execIpmiCmdWithoutSol(String cmd, DevNode node) throws ToolException {
        log.info("exec impi cmd :{}", (Object)cmd);
        String loginCmd = String.format(Locale.ENGLISH, IPMI_CMD, Constants.UTIL_IPMI_PATH, node.getIp(), node.getLoginUser().getUserName(), node.getLoginUser().getPassword(), cmd);
        try {
            Process process = Runtime.getRuntime().exec(loginCmd);
            int retryTimes = 20;
            do {
                ThreadUtils.sleep((long)2000L);
                if (process.isAlive()) continue;
                return IPMIMonitor.getStdout(process);
            } while (--retryTimes != 0);
            log.error("exec ipmi toole time out");
            throw new ToolException("fit.query.bmc.info.error", true);
        }
        catch (IOException e) {
            log.error("ipmi exec failed", (Throwable)e);
            throw new ToolException("fit.query.bmc.info.error", true);
        }
    }

    private static String getStdout(Process process) {
        String result = StreamUtils.readStringFormInputStream((InputStream)process.getInputStream());
        if (!StringUtils.isNULLStr((String)result)) {
            return result;
        }
        return "error-" + StreamUtils.readStringFormInputStream((InputStream)process.getErrorStream());
    }
}

