/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.distributeddeploy.service.report;

import com.huawei.ism.tool.distributeddeploy.common.Context;
import com.huawei.ism.tool.distributeddeploy.enumz.Status;
import com.huawei.ism.tool.distributeddeploy.logic.task.BmcIpConfigTask;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Date;
import java.util.List;
import org.apache.poi.hssf.util.HSSFColor;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BmcIpConfigResultBuilderExcel {
    private static final Logger LOGGER = LoggerFactory.getLogger(BmcIpConfigTask.class);
    private static final String EXCEL_NAME = "BmcIpConfigResult_";
    private static final String EXCEL_NAME_SUFFIX = ".xlsx";
    private static final String[] DEVICE_TABLE_HEAD = new String[]{ResourceUtil.getString((String)"bmcIpFrame.table.model"), ResourceUtil.getString((String)"bmcIpFrame.table.target.ip"), ResourceUtil.getString((String)"bmcIpFrame.table.target.ip.mask"), ResourceUtil.getString((String)"bmcIpFrame.table.target.gateway"), ResourceUtil.getString((String)"bmcIpFrame.table.host.name"), ResourceUtil.getString((String)"bmcIpFrame.table.config.status"), ResourceUtil.getString((String)"bmcIpFrame.table.detail")};
    private Workbook workbook = new XSSFWorkbook();
    private CellStyle tableHeadCellStyle = this.workbook.createCellStyle();

    public BmcIpConfigResultBuilderExcel() {
        this.tableHeadCellStyle.setFillForegroundColor(HSSFColor.HSSFColorPredefined.BLUE_GREY.getIndex());
        Font font = this.workbook.createFont();
        font.setColor(HSSFColor.HSSFColorPredefined.WHITE.getIndex());
        this.tableHeadCellStyle.setFont(font);
        this.tableHeadCellStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
    }

    public void injectData(List<BmcIpConfigTask> taskList) {
        Sheet sheet = this.workbook.createSheet();
        int rowIndex = 0;
        rowIndex = this.initSummaryInformation(rowIndex, sheet, taskList);
        rowIndex = this.initTableHead(rowIndex, sheet);
        this.initTask(rowIndex, sheet, taskList);
    }

    private void initTask(int rowIndex, Sheet sheet, List<BmcIpConfigTask> taskList) {
        for (int i = 0; i < taskList.size(); ++i) {
            Row row = sheet.createRow(i + rowIndex);
            this.buildTaskRow(row, taskList.get(i));
        }
    }

    private void buildTaskRow(Row row, BmcIpConfigTask task) {
        int index = 0;
        this.buildCell(row, index++, task.getNode().getDevType());
        this.buildCell(row, index++, task.getNode().getIp());
        this.buildCell(row, index++, task.getNode().getMask());
        this.buildCell(row, index++, task.getNode().getGateway());
        this.buildCell(row, index++, task.getNode().getNodeName());
        this.buildCell(row, index++, task.getState().getDesc());
        this.buildCell(row, index++, task.getDetaiInfo());
    }

    private void buildCell(Row row, int index, String value) {
        Cell valueCell = row.createCell(index);
        valueCell.setCellValue(value);
    }

    private int initSummaryInformation(int rowIndex, Sheet sheet, List<BmcIpConfigTask> taskList) {
        int devNumber = taskList.size();
        long ipConfigSuccessDev = taskList.stream().filter(task -> task.getConfigDetaiInfo().contains(Status.SUCCESSFUL.getDesc())).count();
        long confirmTrueDevNumber = taskList.stream().filter(task -> task.getIndicatorStateDetaiInfo().contains(Status.CONFIRM_TRUE.getDesc())).count();
        int index = rowIndex;
        this.creatSummaryInformationCell(sheet.createRow(index++), ResourceUtil.getString((String)"bmcIpFrame.result.excel.all.dev.number"), devNumber + "");
        this.creatSummaryInformationCell(sheet.createRow(index++), ResourceUtil.getString((String)"bmcIpFrame.result.excel.config.successful.dev.number"), ipConfigSuccessDev + "");
        this.creatSummaryInformationCell(sheet.createRow(index++), ResourceUtil.getString((String)"bmcIpFrame.result.excel.confirm.true.dev.number"), confirmTrueDevNumber + "");
        return index;
    }

    private void creatSummaryInformationCell(Row row, String tableMsg, String valueMsg) {
        int index = 0;
        Cell tableCell = row.createCell(index++);
        tableCell.setCellStyle(this.tableHeadCellStyle);
        tableCell.setCellValue(tableMsg);
        Cell valueCell = row.createCell(index++);
        valueCell.setCellValue(valueMsg);
    }

    private int initTableHead(int rowIndex, Sheet sheet) {
        Row row = sheet.createRow(rowIndex);
        for (int i = 0; i < DEVICE_TABLE_HEAD.length; ++i) {
            sheet.autoSizeColumn(i);
            sheet.setColumnWidth(i, sheet.getColumnWidth(i) * 2);
            Cell cell = row.createCell(i);
            cell.setCellStyle(this.tableHeadCellStyle);
            cell.setCellValue(DEVICE_TABLE_HEAD[i]);
        }
        return rowIndex + 1;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean saveExcel() {
        try (FileOutputStream fos = new FileOutputStream(Context.INS.getReportDir() + File.separator + EXCEL_NAME + new Date().getTime() + EXCEL_NAME_SUFFIX);){
            this.workbook.write((OutputStream)fos);
            boolean bl = true;
            return bl;
        }
        catch (IOException exception) {
            LOGGER.error("save excel file error");
            return false;
        }
    }
}

