/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.distributeddeploy.service.report;

import com.huawei.ism.tool.distributeddeploy.common.Context;
import com.huawei.ism.tool.distributeddeploy.common.ResourceBoundEnum;
import com.huawei.ism.tool.obase.utils.ApplicationContext;
import com.huawei.ism.tool.obase.utils.StringUtils;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class HtmlResUtils {
    private static final Logger log = LoggerFactory.getLogger(HtmlResUtils.class);
    private static final Map<String, ResourceBundle> RESOURCE = new HashMap<String, ResourceBundle>();

    public static String getString(String key) {
        String value = null;
        try {
            value = RESOURCE.getOrDefault(Context.INS.getScene().getScene(), RESOURCE.get(ResourceBoundEnum.DEFAULT_FIX.getScene())).getString(key);
        }
        catch (MissingResourceException e) {
            log.warn("Can not find resource:{} ", (Object)key);
        }
        return null == value ? "--" : value;
    }

    public static String getStringWithParam(String key, Object ... param) {
        String msg = HtmlResUtils.getString(key);
        return StringUtils.fillValues((String)msg, (Object[])param);
    }

    public static String handelHtmlContent(String content) {
        return content.replaceAll(">", "&gt;").replaceAll("<", "&lt;").replaceAll("\n", "<br/>");
    }

    private HtmlResUtils() {
    }

    static {
        Arrays.stream(ResourceBoundEnum.values()).forEach(resourceEnum -> RESOURCE.put(resourceEnum.getScene(), ResourceBundle.getBundle(resourceEnum.getResourceBundle(), ApplicationContext.getInstance().getCurrentLanguage())));
    }
}

