/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.distributeddeploy.service.report;

import com.huawei.ism.tool.distributeddeploy.common.Constants;
import com.huawei.ism.tool.distributeddeploy.common.Context;
import com.huawei.ism.tool.distributeddeploy.common.ResourceBoundEnum;
import com.huawei.ism.tool.distributeddeploy.entity.DeployNode;
import com.huawei.ism.tool.distributeddeploy.fit.common.ObserverManager;
import com.huawei.ism.tool.distributeddeploy.fit.entity.ClusterNode;
import com.huawei.ism.tool.distributeddeploy.logic.config.ProductStrategy;
import com.huawei.ism.tool.distributeddeploy.service.report.HtmlResUtils;
import com.huawei.ism.tool.distributeddeploy.service.report.TemplateFactory;
import com.huawei.ism.tool.distributeddeploy.service.report.VersionMappingBuilderExcel;
import com.huawei.ism.tool.distributeddeploy.service.report.ZTreeNode;
import com.huawei.ism.tool.framework.platform.util.UserOpDataSaveUtil;
import com.huawei.ism.tool.obase.exception.ToolException;
import com.huawei.ism.tool.obase.utils.ApplicationContext;
import com.huawei.ism.tool.obase.utils.FileAssistant;
import com.huawei.ism.tool.obase.utils.FileUtils;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import com.huawei.ism.tool.obase.utils.StringUtils;
import com.huawei.json.JSONArray;
import com.huawei.yinglong.river.system.storage.distribution.entity.SystemInstallationParams;
import java.io.File;
import java.nio.file.Paths;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReportBuilder {
    private static final String RES_PATH = ApplicationContext.getInstance().getPackagesPath() + File.separator + "html";
    public static final String REPORT_TEMP = ApplicationContext.getInstance().getTmpPath() + File.separator + "report";
    private static final String REPORT_HEAD_PATH = REPORT_TEMP + File.separator + "head";
    private static final String REPORT_NODES_PATH = REPORT_TEMP + File.separator + "nodes";
    private static final String REPORT_NAME = "DeployReport_%s.zip";
    private static final Logger LOGGER = LoggerFactory.getLogger(ReportBuilder.class);
    private static final String PREFIX_CLUSTER = "Device_";
    private static final String SUFFIX_HEAD = "head";
    private static final String SUFFIX_NODES = "nodes";

    public boolean buildReport(List<DeployNode> deployNodes, String targetDir) throws ToolException {
        LOGGER.info("Start build report.");
        try {
            this.init();
            this.buildCheck(targetDir);
            this.buildIndex(REPORT_TEMP);
            this.buildCover(REPORT_HEAD_PATH);
            this.buildLeftTree(deployNodes, REPORT_HEAD_PATH);
            this.buildDeploySummary(deployNodes, REPORT_HEAD_PATH);
            this.buildNodesDetail(deployNodes);
            String fileName = String.format(Locale.ENGLISH, REPORT_NAME, StringUtils.formatDate((Object)new Date(), (String)"yyyyMMddHHmmss"));
            return this.compressFile(targetDir + File.separator + fileName, REPORT_TEMP + File.separator + "**\\*", REPORT_TEMP + File.separator + "*");
        }
        catch (ToolException e) {
            throw e;
        }
        catch (Throwable e) {
            LOGGER.error("Build report err.", e);
            return false;
        }
    }

    private boolean compressFile(String target, String ... sources) {
        String cmdTemp = "\"%s\" a -tzip \"%s\" \"%s\"";
        String cmd = String.format(Locale.ENGLISH, cmdTemp, Constants.UTIL_7Z_PATH, target, String.join((CharSequence)"\" \"", sources));
        return FileAssistant.executeCmd((String)cmd, (boolean)true);
    }

    private void buildCheck(String targetDir) throws ToolException {
        File targetDirFile = new File(targetDir);
        if (!targetDirFile.exists() && !targetDirFile.mkdirs()) {
            throw new ToolException("export.report.makeDir.err");
        }
        if (!targetDirFile.canWrite()) {
            throw new ToolException("export.report.makeFile.err");
        }
    }

    private void init() {
        FileUtils.clearDir((String)REPORT_TEMP);
        FileUtils.copyDir((String)RES_PATH, (String)(REPORT_TEMP + File.separator + "res"));
    }

    private void buildIndex(String targetPath) {
        String fileName = "index.html";
        TemplateFactory.processorFtl(fileName, null, targetPath + File.separator + fileName);
    }

    private void buildCover(String targetPath) {
        String fileName = "cover.html";
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("tool_version", UserOpDataSaveUtil.getToolIniProp("tool.version"));
        String toolboxVer = UserOpDataSaveUtil.getToolBoxIniProp("app.version");
        data.put("toolbox_version", toolboxVer == null ? "--" : toolboxVer);
        data.put("release_date", ApplicationContext.getInstance().getReleaseDate());
        data.put("generation_time", StringUtils.formatDate((Object)new Date(), (String)"yyyy-MM-dd HH:mm:ss 'GMT'Z"));
        TemplateFactory.processorFtl(fileName, data, targetPath + File.separator + fileName);
    }

    private void buildNodesDetail(List<DeployNode> deployNodes) {
        deployNodes.forEach(node -> this.buildNodeDetail((DeployNode)node, REPORT_NODES_PATH + File.separator + node.getIpPath()));
    }

    private void buildNodeDetail(DeployNode node, String targetPath) {
        String fileName = "detailView.html";
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("items", node.getAllItemTasks());
        data.put("nodeTitle", HtmlResUtils.getStringWithParam("node.detail.tittle", node.getHtmlIndex()));
        TemplateFactory.processorFtl(fileName, data, targetPath + File.separator + "index.html");
    }

    private void buildLeftTree(List<DeployNode> deployNodes, String targetPath) {
        String fileName = "indexTree.html";
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("treeNodes", this.buildIndexTreeStr(deployNodes));
        TemplateFactory.processorFtl(fileName, data, targetPath + File.separator + fileName);
    }

    private String buildIndexTreeStr(List<DeployNode> deployNodes) {
        JSONArray zTreeJsonStr = new JSONArray();
        ZTreeNode coverNode = new ZTreeNode(HtmlResUtils.getString("indexTree.cover")).setUrl("cover.html");
        ZTreeNode summaryNode = new ZTreeNode(HtmlResUtils.getString("indexTree.summary")).setUrl("summary.html");
        ZTreeNode detailNode = new ZTreeNode(HtmlResUtils.getString("indexTree.detail")).setParent(true).setOpen(true);
        deployNodes.stream().map(this::buildDevNodeIndex).forEach(detailNode::addChildren);
        zTreeJsonStr.put(coverNode).put(summaryNode).put(detailNode);
        return zTreeJsonStr.toString();
    }

    private ZTreeNode buildDevNodeIndex(DeployNode node) {
        return new ZTreeNode(HtmlResUtils.getStringWithParam("indexTree.node.detail", node.getHtmlIndex())).setUrl(String.format(Locale.ENGLISH, "../nodes/%s/index.html", node.getIpPath()));
    }

    private void buildDeploySummary(List<DeployNode> deployNodes, String targetPath) {
        String fileName = "summary.html";
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put(SUFFIX_NODES, deployNodes);
        data.put("mathVersion", ResourceUtil.getString((String)Context.INS.getCurrentMappingVersion()));
        data.put("nodeNum", deployNodes.size());
        data.put("finishedNum", deployNodes.stream().filter(node -> "finished".equals(node.getHtmlStatus())).count());
        data.put("notFinishedNum", deployNodes.stream().filter(node -> "notFinished".equals(node.getHtmlStatus())).count());
        String currentSceneKey = Context.INS.getCurrentScene().getKey();
        AtomicReference<String> name = new AtomicReference<String>("");
        ProductStrategy.INS.getModeList().stream().filter(info -> info.getSceneId().equals(currentSceneKey)).findFirst().ifPresent(info -> name.set(info.getSceneDes()));
        data.put("scene", Context.INS.getScene().equals((Object)ResourceBoundEnum.DEFAULT_FIX) ? name.get() : null);
        TemplateFactory.processorFtl(fileName, data, targetPath + File.separator + fileName);
    }

    public String buildClusterReport(List<ClusterNode> clusterNodes, String targetDir) throws ToolException {
        LOGGER.info("Start build report.");
        try {
            FileUtils.clearDir((String)REPORT_TEMP);
            for (ClusterNode clusterNode : clusterNodes) {
                this.buildSingleClusterReport(clusterNode);
            }
            String fileName = String.format(Locale.ENGLISH, Context.INS.getScene().getReportName(), StringUtils.formatDate((Object)new Date(), (String)"yyyyMMddHHmmss"));
            boolean result = this.compressFile(targetDir + File.separator + fileName, REPORT_TEMP + File.separator + "*");
            if (result) {
                return String.join((CharSequence)File.separator, targetDir, fileName);
            }
            return "";
        }
        catch (ToolException e) {
            LOGGER.error("build cluster report error.", (Throwable)e);
            throw e;
        }
    }

    private boolean buildSingleClusterReport(ClusterNode clusterNode) throws ToolException {
        String clusterReportPath = this.buildClusterReportPath(clusterNode.getIp());
        this.initClusterPath(clusterReportPath);
        this.buildCheck(clusterReportPath);
        this.buildIndex(clusterReportPath);
        String clusterReportHeadPath = clusterReportPath + File.separator + SUFFIX_HEAD;
        this.buildCover(clusterReportHeadPath);
        List<DeployNode> deployNodes = clusterNode.getNeedDeployNodes();
        this.buildLeftTree(deployNodes, clusterReportHeadPath);
        this.buildClusterSummary(clusterNode, clusterReportHeadPath);
        String clusterReportNodesPath = clusterReportPath + File.separator + SUFFIX_NODES;
        this.buildClusterNodesDetail(deployNodes, clusterReportNodesPath);
        return true;
    }

    private void buildVersionMappingExcel(ClusterNode clusterNode, String clusterReportPath, Map<String, Object> data) {
        VersionMappingBuilderExcel excel = new VersionMappingBuilderExcel();
        excel.injectData(clusterNode);
        String excelName = excel.saveExcel(Paths.get(clusterReportPath, new String[0]).getParent().toString(), clusterNode.getIp().replace(":", "_"));
        data.put("excelFileName", excelName);
        data.put("excelLinkName", ResourceUtil.getStringWithParams((String)"summary.version.mapping.link.name", (Object[])new Object[]{excelName}));
    }

    private String buildClusterReportPath(String clusterIp) {
        String reportDir = clusterIp.replaceAll(":", "_");
        return REPORT_TEMP + File.separator + PREFIX_CLUSTER + reportDir;
    }

    private void initClusterPath(String clusterReportPath) {
        FileUtils.copyDir((String)RES_PATH, (String)(clusterReportPath + File.separator + "res"));
    }

    void buildClusterSummary(ClusterNode clusterNode, String targetPath) {
        List<DeployNode> deployNodes = clusterNode.getNeedDeployNodes();
        Map<String, Object> data = this.buildSummaryData(clusterNode, targetPath, deployNodes);
        String fileName = "summary.html";
        TemplateFactory.processorFtl(fileName, data, targetPath + File.separator + fileName);
    }

    Map<String, Object> buildSummaryData(ClusterNode clusterNode, String targetPath, List<DeployNode> deployNodes) {
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put(SUFFIX_NODES, deployNodes);
        if (ResourceBoundEnum.involveMatchVersion(Context.INS.getScene())) {
            data.put("mathVersion", ResourceUtil.getString((String)clusterNode.getMappingVersion()));
        }
        data.put("nodeNum", deployNodes.size());
        data.put("finishedNum", deployNodes.stream().filter(node -> "finished".equals(node.getHtmlStatus())).count());
        data.put("notFinishedNum", deployNodes.stream().filter(node -> "notFinished".equals(node.getHtmlStatus())).count());
        this.buildExcelByScene(clusterNode, targetPath, data);
        if (Context.INS.getScene().equals((Object)ResourceBoundEnum.DEFAULT_FIX)) {
            String currentSceneKey = ObserverManager.getInstance().getCurrentScene();
            AtomicReference<String> name = new AtomicReference<String>("");
            ProductStrategy.INS.getModeList().stream().filter(info -> info.getSceneId().equals(currentSceneKey)).findFirst().ifPresent(info -> name.set(info.getSceneDes()));
            data.put("scene", name.get());
        }
        data.put("titleInfo", HtmlResUtils.getStringWithParam("summary.title", clusterNode.getIp()));
        if (ResourceBoundEnum.OS_INSTALLATION.equals((Object)Context.INS.getScene())) {
            List paramsList = deployNodes.stream().map(DeployNode::getConfigParam).filter(Objects::nonNull).collect(Collectors.toList());
            SystemInstallationParams params = (SystemInstallationParams)paramsList.get(0);
            data.put("x86IsoPackage", this.getFileName(params.getIsoX86Path()));
            data.put("armIsoPackage", this.getFileName(params.getIsoArmPath()));
            data.put("timeZone", params.getTimezone());
            data.put("isOsInstallScene", true);
        }
        return data;
    }

    private void buildExcelByScene(ClusterNode clusterNode, String targetPath, Map<String, Object> data) {
        boolean isQualityCheck = ResourceBoundEnum.DEPLOYMENT_QUALITY_CHECK.equals((Object)Context.INS.getScene());
        boolean isExpansionScene = Context.INS.isExpansionScene();
        data.put("isQualityCheck", isQualityCheck);
        data.put("isExpansionScene", isExpansionScene);
        if (isQualityCheck || isExpansionScene) {
            this.buildVersionMappingExcel(clusterNode, targetPath, data);
        }
    }

    private void buildClusterNodesDetail(List<DeployNode> deployNodes, String clusterNodePath) {
        deployNodes.forEach(node -> this.buildNodeDetail((DeployNode)node, clusterNodePath + File.separator + node.getIpPath()));
    }

    String getFileName(String filePath) {
        return StringUtils.isNULLStr((String)filePath) ? "" : new File(filePath).getName();
    }
}

