/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.distributeddeploy.service.report;

import com.huawei.ism.tool.obase.utils.ApplicationContext;
import com.huawei.ism.tool.obase.utils.FileUtils;
import freemarker.cache.CacheStorage;
import freemarker.cache.ClassTemplateLoader;
import freemarker.cache.MruCacheStorage;
import freemarker.cache.MultiTemplateLoader;
import freemarker.cache.TemplateLoader;
import freemarker.template.Configuration;
import freemarker.template.Template;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Locale;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TemplateFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(TemplateFactory.class);
    private static final String UTF8ENCODE = "UTF-8";
    private static final String TEMPLATE_DICTIONARY = "/config/template/";
    private static final Configuration CONFIGURATION = new Configuration();
    private static final int MAX = 200;

    private TemplateFactory() {
    }

    public static boolean processorFtl(String ftlPath, Object data, String outHtmlFilePath) {
        boolean flag = false;
        File file = new File(outHtmlFilePath);
        FileUtils.createDir((String)file.getParent());
        try (FileOutputStream fos = new FileOutputStream(outHtmlFilePath);
             OutputStreamWriter osw = new OutputStreamWriter((OutputStream)fos, ApplicationContext.APP_CHARSET);
             BufferedWriter writer = new BufferedWriter(osw);){
            Template template = CONFIGURATION.getTemplate(ftlPath, UTF8ENCODE);
            template.process(data, (Writer)writer);
            flag = true;
        }
        catch (Exception e) {
            LOGGER.error("build freemarker template faild. path is :" + ftlPath, (Throwable)e);
        }
        return flag;
    }

    static {
        ClassTemplateLoader classTemplateLoader = new ClassTemplateLoader(TemplateFactory.class, TEMPLATE_DICTIONARY);
        MultiTemplateLoader loader = new MultiTemplateLoader(new TemplateLoader[]{classTemplateLoader});
        CONFIGURATION.setCacheStorage((CacheStorage)new MruCacheStorage(10, 200));
        CONFIGURATION.setLocale(Locale.getDefault());
        CONFIGURATION.clearEncodingMap();
        CONFIGURATION.setEncoding(Locale.CHINESE, UTF8ENCODE);
        CONFIGURATION.setTemplateLoader((TemplateLoader)loader);
    }
}

