/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.distributeddeploy.service.report;

import com.huawei.ism.tool.distributeddeploy.entity.DeployNode;
import com.huawei.ism.tool.distributeddeploy.entity.VersionKeyEnum;
import com.huawei.ism.tool.distributeddeploy.fit.entity.ClusterNode;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import com.huawei.ism.tool.obase.utils.StringUtils;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import org.apache.poi.hssf.util.HSSFColor;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VersionMappingBuilderExcel {
    private static final Logger log = LoggerFactory.getLogger(VersionMappingBuilderExcel.class);
    private static final String EXCEL_NAME = "VersionMappingResult_%s.xlsx";
    private static final String[] DEVICE_INFO_HEAD = new String[]{ResourceUtil.getString((String)"versionMapping.device.sn"), ResourceUtil.getString((String)"versionMapping.device.name"), ResourceUtil.getString((String)"versionMapping.device.bmc"), ResourceUtil.getString((String)"versionMapping.device.version")};
    private static final String[] DEVICE_DRIVER_HEAD = new String[]{ResourceUtil.getString((String)"versionMapping.driver.os"), ResourceUtil.getString((String)"versionMapping.driver.raid"), ResourceUtil.getString((String)"versionMapping.driver.raid.config"), ResourceUtil.getString((String)"versionMapping.driver.card.driver"), ResourceUtil.getString((String)"versionMapping.driver.card.tool"), ResourceUtil.getString((String)"versionMapping.1822.driver.card"), ResourceUtil.getString((String)"versionMapping.net.driver"), ResourceUtil.getString((String)"versionMapping.driver.sata"), ResourceUtil.getString((String)"versionMapping.driver.sas"), ResourceUtil.getString((String)"versionMapping.driver.sas.expansion"), ResourceUtil.getString((String)"versionMapping.driver.pcieinf"), ResourceUtil.getString((String)"versionMapping.driver.bsp"), ResourceUtil.getString((String)"versionMapping.driver.cma"), ResourceUtil.getString((String)"versionMapping.driver.memf"), ResourceUtil.getString((String)"versionMapping.driver.nvme"), ResourceUtil.getString((String)"versionMapping.driver.idm")};
    private static final String[] DEVICE_FIRMWARE_HEAD = new String[]{ResourceUtil.getString((String)"versionMapping.firmware.raid"), ResourceUtil.getString((String)"versionMapping.firmware.card"), ResourceUtil.getString((String)"versionMapping.firmware.ibmc"), ResourceUtil.getString((String)"versionMapping.firmware.board.cpld"), ResourceUtil.getString((String)"versionMapping.firmware.raid.cpld"), ResourceUtil.getString((String)"versionMapping.firmware.bios"), ResourceUtil.getString((String)"versionMapping.firmware.sas1"), ResourceUtil.getString((String)"versionMapping.firmware.sas2"), ResourceUtil.getString((String)"versionMapping.firmware.sp")};
    private static final String FONT_NAME = "\u5b8b\u4f53";
    private static final short FONT_SIZE = 12;
    private static final short HEAD_FONT_SIZE = 14;
    private static final short WHITE = HSSFColor.HSSFColorPredefined.WHITE.getIndex();
    private static final short BLACK = HSSFColor.HSSFColorPredefined.BLACK.getIndex();
    private final CellStyle defaultStyle;
    private final CellStyle headerCellStyle;
    private final CellStyle subHeaderCellStyle;
    private final CellStyle notPass;
    private final Workbook workBook = new XSSFWorkbook();

    public VersionMappingBuilderExcel() {
        this.defaultStyle = this.newDefaultCellStyle();
        this.subHeaderCellStyle = this.newDefaultCellStyle();
        this.subHeaderCellStyle.setFillForegroundColor(HSSFColor.HSSFColorPredefined.GREY_25_PERCENT.getIndex());
        this.subHeaderCellStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        this.subHeaderCellStyle.setFont(this.createFont(FONT_NAME, (short)12, BLACK, true));
        this.headerCellStyle = this.newDefaultCellStyle();
        this.headerCellStyle.setFillForegroundColor(HSSFColor.HSSFColorPredefined.LIGHT_CORNFLOWER_BLUE.getIndex());
        this.headerCellStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        this.headerCellStyle.setAlignment(HorizontalAlignment.LEFT);
        this.headerCellStyle.setWrapText(true);
        this.headerCellStyle.setFont(this.createFont(FONT_NAME, (short)14, BLACK, true));
        this.notPass = this.newDefaultCellStyle();
        this.notPass.setFillForegroundColor(HSSFColor.HSSFColorPredefined.RED.getIndex());
        this.notPass.setFont(this.createFont(FONT_NAME, (short)12, WHITE, true));
        this.notPass.setFillPattern(FillPatternType.SOLID_FOREGROUND);
    }

    private CellStyle newDefaultCellStyle() {
        CellStyle style = this.workBook.createCellStyle();
        VersionMappingBuilderExcel.addBorder(style);
        style.setFont(this.createFont(FONT_NAME, (short)12, BLACK, false));
        style.setDataFormat(this.workBook.createDataFormat().getFormat("@"));
        style.setAlignment(HorizontalAlignment.CENTER);
        style.setVerticalAlignment(VerticalAlignment.CENTER);
        return style;
    }

    private Font createFont(String name, short fontSize, short colorIndex, boolean isBold) {
        Font font = this.workBook.createFont();
        font.setFontName(name);
        font.setFontHeightInPoints(fontSize);
        font.setColor(colorIndex);
        font.setBold(isBold);
        return font;
    }

    private static void addBorder(CellStyle style) {
        style.setBorderBottom(BorderStyle.THIN);
        style.setBorderLeft(BorderStyle.THIN);
        style.setBorderRight(BorderStyle.THIN);
        style.setBorderTop(BorderStyle.THIN);
    }

    public void injectData(ClusterNode clusterNode) {
        Sheet sheet = this.workBook.createSheet();
        this.workBook.setSheetName(0, ResourceUtil.getString((String)"versionMapping.excel.sheet.name"));
        this.initTableHead(sheet, clusterNode.getIp(), ResourceUtil.getString((String)clusterNode.getMappingVersion()));
        this.injectNodeInfo(3, sheet, clusterNode.getNeedDeployNodes());
    }

    private void initTableHead(Sheet sheet, String ip, String mappingVersion) {
        int rowIndex = 0;
        Row headerRow = sheet.createRow(rowIndex++);
        Row parentRow = sheet.createRow(rowIndex++);
        Row row = sheet.createRow(rowIndex);
        int columnIndex = 0;
        columnIndex = this.creatTableHead(columnIndex, row, parentRow, DEVICE_INFO_HEAD, ResourceUtil.getString((String)"versionMapping.device.head"));
        columnIndex = this.creatTableHead(columnIndex, row, parentRow, DEVICE_DRIVER_HEAD, ResourceUtil.getString((String)"versionMapping.driver.head"));
        columnIndex = this.creatTableHead(columnIndex, row, parentRow, DEVICE_FIRMWARE_HEAD, ResourceUtil.getString((String)"versionMapping.firmware.head"));
        Cell cell = headerRow.createCell(0);
        cell.setCellValue(ResourceUtil.getStringWithParams((String)"versionMapping.excel.name", (Object[])new Object[]{ip, mappingVersion}));
        sheet.addMergedRegion(new CellRangeAddress(headerRow.getRowNum(), headerRow.getRowNum(), 0, columnIndex - 1));
        cell.setCellStyle(this.headerCellStyle);
        headerRow.createCell(columnIndex - 1).setCellStyle(this.headerCellStyle);
        headerRow.setHeight((short)1300);
    }

    private void injectNodeInfo(int rowIndex, Sheet sheet, List<DeployNode> deployNodes) {
        for (int i = 0; i < deployNodes.size(); ++i) {
            Row row = sheet.createRow(i + rowIndex);
            this.buildInfoRow(row, deployNodes.get(i));
        }
    }

    private void buildInfoRow(Row row, DeployNode deployNode) {
        int index = 0;
        this.buildCell(row, index++, deployNode.getSn());
        this.buildCell(row, index++, deployNode.getNodeName());
        this.buildCell(row, index++, deployNode.getIpAddress().getIp());
        this.buildCell(row, index++, deployNode.getDevType());
        this.buildCell(row, index++, deployNode, VersionKeyEnum.OS.getKey());
        this.buildCell(row, index++, deployNode, VersionKeyEnum.RAID_DRIVER.getKey());
        this.buildCell(row, index++, deployNode, VersionKeyEnum.RAID_CONFIG.getKey());
        this.buildCell(row, index++, deployNode, VersionKeyEnum.NIC_DRIVER.getKey());
        this.buildCell(row, index++, deployNode, VersionKeyEnum.NIC_TOOL.getKey());
        this.buildCell(row, index++, deployNode, VersionKeyEnum.NIC_1822_V120.getKey());
        this.buildCell(row, index++, deployNode, VersionKeyEnum.NET_VERSION.getKey());
        this.buildCell(row, index++, deployNode, VersionKeyEnum.SATA_OS_DRIVER.getKey());
        this.buildCell(row, index++, deployNode, VersionKeyEnum.SAS_DATA_DRIVER.getKey());
        this.buildCell(row, index++, deployNode, VersionKeyEnum.SAS_EXPANSION_MODULE_DRIVER.getKey());
        this.buildCell(row, index++, deployNode, VersionKeyEnum.BASE_PCIEINF.getKey());
        this.buildCell(row, index++, deployNode, VersionKeyEnum.BASE_BSP.getKey());
        this.buildCell(row, index++, deployNode, VersionKeyEnum.BASE_CMA.getKey());
        this.buildCell(row, index++, deployNode, VersionKeyEnum.BASE_MEMF.getKey());
        this.buildCell(row, index++, deployNode, VersionKeyEnum.NVME.getKey());
        this.buildCell(row, index++, deployNode, VersionKeyEnum.IDM.getKey());
        this.buildCell(row, index++, deployNode, VersionKeyEnum.RAID_FW.getKey());
        this.buildCell(row, index++, deployNode, VersionKeyEnum.NIC_FW.getKey());
        this.buildCell(row, index++, deployNode, VersionKeyEnum.IBMC_FW.getKey());
        this.buildCell(row, index++, deployNode, VersionKeyEnum.MAIN_BOARD_CPLD_FW.getKey());
        this.buildCell(row, index++, deployNode, VersionKeyEnum.RAID_CPLD_FW.getKey());
        this.buildCell(row, index++, deployNode, VersionKeyEnum.BIOS_FW.getKey());
        this.buildCell(row, index++, deployNode, VersionKeyEnum.SAS_EXPANSION_MODULE_FW10.getKey());
        this.buildCell(row, index++, deployNode, VersionKeyEnum.SAS_EXPANSION_MODULE_FW20.getKey());
        this.buildCell(row, index, deployNode, VersionKeyEnum.SP.getKey());
    }

    private void buildCell(Row row, int index, String value) {
        Cell cell = row.createCell(index);
        cell.setCellStyle(this.defaultStyle);
        cell.setCellValue(value);
    }

    private void buildCell(Row row, int index, DeployNode deployNode, String versionKey) {
        String value = deployNode.getVersionFromMap(versionKey);
        boolean result = deployNode.getResultFromMap(versionKey);
        Cell cell = row.createCell(index);
        if (StringUtils.isNULLStr((String)value)) {
            cell.setCellValue(ResourceUtil.getString((String)"deploy.status.notSupport"));
        } else {
            cell.setCellValue(value);
        }
        if (!result) {
            cell.setCellStyle(this.notPass);
        } else {
            cell.setCellStyle(this.defaultStyle);
        }
    }

    private int creatTableHead(int columnIndex, Row row, Row parentRow, String[] heads, String parentHead) {
        parentRow.createCell(columnIndex).setCellValue(parentHead);
        parentRow.getSheet().addMergedRegion(new CellRangeAddress(parentRow.getRowNum(), parentRow.getRowNum(), columnIndex, columnIndex + heads.length - 1));
        for (int i = 0; i < heads.length; ++i) {
            int index = columnIndex + i;
            Cell subCell = row.createCell(index);
            subCell.setCellStyle(this.subHeaderCellStyle);
            subCell.setCellValue(heads[i]);
            row.getSheet().setColumnWidth(index, 5120);
            parentRow.createCell(index).setCellStyle(this.subHeaderCellStyle);
        }
        parentRow.getCell(columnIndex).setCellValue(parentHead);
        return columnIndex + heads.length;
    }

    public String saveExcel(String tempPath, String ip) {
        String excelName = String.format(EXCEL_NAME, ip);
        try (FileOutputStream fos = new FileOutputStream(tempPath + File.separator + excelName);){
            this.workBook.write((OutputStream)fos);
        }
        catch (FileNotFoundException exception) {
            log.error("The temporary path does not exist.");
            return "";
        }
        catch (IOException exception) {
            log.error("save excel file error: ", (Throwable)exception);
            return "";
        }
        return excelName;
    }

    public Workbook getWorkBook() {
        return this.workBook;
    }
}

